/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.setters;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.client.common.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
public class AddSADDataToExistingInvoice {
    private Logger log = Logger.getLogger(AddSADDataToExistingInvoice.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private CommentService commentService;
    private final String[] TEMPORARY_ADMISSION_TABLE_COLUMN_IDS = new String[]{"pdszf_numer_sad", "pdszf_kwota_odprawy_cze", "pdszf_procent_z_calosci", "pdszf_assignment", "pdszf_podglad"};

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("add-sad-data-to-existing-invoice-setter")).name("setter.add-sad-data-to-existing-invoice.name")).description("setter.add-sad-data-to-existing-invoice.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.TABLE_ROW_INSERT)).parameter().id("sadNo").name("setter.add-sad-data-to-existing-invoice.sadNo.name").type((Type)Types.STRING).create()).parameter().id("amount").name("setter.add-sad-data-to-existing-invoice.amount.name").type((Type)Types.FLOAT).create()).parameter().id("percentOfInv").name("setter.add-sad-data-to-existing-invoice.percentOfInv.name").type((Type)Types.FLOAT).create()).parameter().id("processIdToUpdate").name("setter.add-sad-data-to-existing-invoice.processIdToUpdate.name").type((Type)Types.STRING).create()).parameter().id("referenceNo").name("setter.add-sad-data-to-existing-invoice.referenceNo.name").type((Type)Types.STRING).create();
    }

    public void set(@Param String sadNo, @Param Double amount, @Param Double percentOfInv, @Param String processIdToUpdate, @Param String referenceNo, AcceptanceContext acceptanceContext) {
        try {
            this.updateActivityContext(sadNo, amount, percentOfInv, referenceNo, processIdToUpdate);
            this.updateProcessContext(sadNo, amount, percentOfInv, referenceNo, processIdToUpdate);
            this.addCommentWithUpdatedData(sadNo, amount, processIdToUpdate);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void updateActivityContext(String sadNo, Double amount, Double percentOfInv, String referenceNo, String processIdToUpdate) {
        List activities = this.activityFinder.findOpenedActivities(processIdToUpdate);
        for (Activity activity : activities) {
            Map activityContextMap = this.activityService.getActivityContext(processIdToUpdate, activity.getActivityId());
            HashMap<String, String> toAdd = new HashMap<String, String>();
            toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[0], sadNo);
            toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[1], String.valueOf(amount));
            toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[2], String.valueOf(percentOfInv));
            toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[3], "");
            toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[4], this.getDocLink(referenceNo));
            Map addedRecords = DynamicTableFunctions.addRecords((Map)activityContextMap, (String[])this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS, toAdd);
            this.log.debug((Object)("Rekordy dodane do zadania " + activity.getActivityId() + ": " + addedRecords));
            activityContextMap.putAll(addedRecords);
            this.activityService.setActivityContext(processIdToUpdate, activity.getActivityId(), activityContextMap);
        }
    }

    private void updateProcessContext(String sadNo, Double amount, Double percentOfInv, String referenceNo, String processIdToUpdate) {
        Map processContextMap = this.processService.getProcessContext(processIdToUpdate);
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[0], sadNo);
        toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[1], String.valueOf(amount));
        toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[2], String.valueOf(percentOfInv));
        toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[3], "");
        toAdd.put(this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS[4], this.getDocLink(referenceNo));
        Map addedRecords = DynamicTableFunctions.addRecords((Map)processContextMap, (String[])this.TEMPORARY_ADMISSION_TABLE_COLUMN_IDS, toAdd);
        this.log.debug((Object)("Rekordy dodane do procesu " + processIdToUpdate + ": " + addedRecords));
        processContextMap.putAll(addedRecords);
        this.processService.setProcessContext(processIdToUpdate, processContextMap);
    }

    private void addCommentWithUpdatedData(String sadNo, Double amount, String processId) {
        String activityId = this.activityFinder.findLastActivity(processId).getActivityId();
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(activityId);
        comment.setUserId("admin");
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment("Dodano odpraw\u0119 cz\u0119\u015bciow\u0105 przypisan\u0105 do tej faktury. Kwota odprawy = " + this.convertFromStringToAmount(amount) + ", Numer SAD = " + sadNo);
        this.commentService.createComment(comment);
    }

    public String convertFromStringToAmount(Double value) {
        String sAmount = new DecimalFormat("#.##").format(value);
        sAmount = sAmount.replace(",", ".");
        return sAmount;
    }

    private String getDocLink(String referenceNo) {
        String link = SystemProperties.getString((String)"HTTPLink");
        return link + "/ShowDocumentFromArchive.do?type=docclass&objectName=Faktury%20-%20odprawy%20cz%C4%99%C5%9Bciowe&indexName=Numer%20dziennika&value=" + referenceNo;
    }
}

