/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.servlets;

import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/controller"})
public class PaymentTermsCalculations {
    private Logger log = LoggerFactory.getLogger(PaymentTermsCalculations.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String PAYMENT_COND_BD_QUERY = "select max_legal_payment_terms, bad_debt_indicator, company_status, valid_on from pm_cust_warunki_platnosci_bd where company_code = :companyCode and vendor_code = :vendorCode and TO_DATE(:issueDate,'YYYY-MM-DD') >= valid_on order by valid_on desc limit 1";

    @RequestMapping(value={"getPaymentTermsDBData"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getPaymentTermsDBData(String companyCode, String vendorCode, String blindDate, String issueDate, String basicPaymentTerm) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("status_przedsiebiorstwa", "");
        data.put("warunek_platnosci_bd", "");
        data.put("termin_platnosci_bd", "");
        this.log.debug("companyCode: " + companyCode + ", vendorCode: " + vendorCode);
        this.log.debug("blindDate: " + blindDate + ", issueDate: " + issueDate + ", basicPaymentTerm: " + basicPaymentTerm);
        try {
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery(this.PAYMENT_COND_BD_QUERY);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("companyCode", companyCode);
            params.put("vendorCode", vendorCode);
            params.put("issueDate", issueDate);
            builder.setParameters(params);
            SQLFinder sqlFinder = FinderFactory.getSQLFinder();
            List queryResult = sqlFinder.find(builder);
            if (queryResult != null && queryResult.size() == 1) {
                Map row = (Map)queryResult.get(0);
                this.log.debug("result: " + row);
                String companyStatus = String.valueOf(row.get("company_status"));
                data.put("status_przedsiebiorstwa", companyStatus);
                String paymentCondition = String.valueOf(row.get("max_legal_payment_terms"));
                data.put("warunek_platnosci_bd", paymentCondition);
                String indicatorBD = String.valueOf(row.get("bad_debt_indicator"));
                Date calculatedPaymentTermBd = this.getPaymentTermBD(paymentCondition, indicatorBD, companyStatus, blindDate, basicPaymentTerm);
                data.put("termin_platnosci_bd", this.sdf.format(calculatedPaymentTermBd));
                this.log.debug("Result data: " + data);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("wystapi\u0142 problem podczas obliczania terminu p\u0142atno\u015bci BD " + e.getMessage());
        }
        return data;
    }

    private Date getPaymentTermBD(String paymentCondition, String indicatorBD, String companyStatus, String blindDate, String basicPaymentTerm) throws ParseException {
        if (StringUtils.isBlank((String)indicatorBD.toUpperCase().trim()) || StringUtils.equals((String)indicatorBD.toUpperCase().trim(), (String)"X") && StringUtils.equals((String)companyStatus.toUpperCase().trim(), (String)"LARGE")) {
            return this.sdf.parse(basicPaymentTerm);
        }
        if (StringUtils.equals((String)indicatorBD.toUpperCase().trim(), (String)"X") && !StringUtils.equals((String)companyStatus.toUpperCase().trim(), (String)"LARGE")) {
            Integer addDays = Integer.valueOf(paymentCondition.replaceAll("[^0-9]+", ""));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.sdf.parse(blindDate));
            calendar.add(5, addDays);
            Date paymentTermDate = calendar.getTime();
            if (paymentTermDate.compareTo(this.sdf.parse(basicPaymentTerm)) < 0) {
                return paymentTermDate;
            }
        }
        return new SimpleDateFormat("yyyy-MM-dd").parse(basicPaymentTerm);
    }
}

