/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.script;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.IndexData;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDocumentActionHandler
implements DocumentEventHandler {
    private Logger log = LoggerFactory.getLogger(CustomDocumentActionHandler.class);
    private static final String SAD_ENTRY_DOC_CLASS = "SAD - Wpisy";
    private static final String PARTIAL_CLEARANCE_INVOICE_DOC_CLASS = "Faktury - odprawy cz\u0119\u015bciowe";
    private static final String SAD_STATEMENTS_DOC_CLASS = "SAD - O\u015bwiadczenie";
    private static final String SAD_NO_INDEX = "Numer SAD";
    private static final String REFERENCE_NO_INDEX = "Numer dziennika";
    private static final String INVOICES_NO_NO_INDEX = "Numer faktury";
    private static final String STATEMENT_INVOICES_DOC_DECRIPTION = "Oswiadczenie do faktury SAD";
    private static final String PARTIAL_CLEARANCE_INVOICE_DOC_DECRIPTION = "Odprawa cz\u0119\u015bciowa do faktury";
    private static final String INOVICE_PROC_DEF_ID = "pro_fakt_zw";
    private static final String INOVICE_PROC_SAD_NO_ID = "numer_sad";
    private static final String INOVICE_PROC_SAD_INV_NO_ID = "numer_sad_faktury";
    private static final String INOVICE_PROC_REFERENCE_NO_ID = "identyfikator_faktury";
    private static final String INOVICE_PROC_PARTIAL_CLEARANCE_ID = "odprawa_czesciowa";
    private static final String INOVICE_PROC_INVOICE_NO_ID = "numer_faktury";
    private static final String INOVICE_PROC_REGISTER_ACTIVITY_DEF_ID = "rejestracja_faktury";
    private ProcessFinder processFinder = FinderFactory.getProcessFinder();
    private ProcessService processService = ServiceFactory.getProcessService();
    private ActivityFinder activityFinder = FinderFactory.getActivityFinder();
    private ActivityService activityService = ServiceFactory.getActivityService();
    private DocumentService documentService = ServiceFactory.getDocumentService();
    private FileService fileService = ServiceFactory.getFileService();

    public CustomDocumentActionHandler(String processId) {
    }

    public void handleEvent(WfActivityTransaction st, DocumentEvent de) throws Exception {
        String docClassName = de.getDocument().getLDocClassName();
        if (StringUtils.equals((CharSequence)docClassName, (CharSequence)SAD_ENTRY_DOC_CLASS)) {
            this.findAndAttachDocumentDocumentToProcess(de, DOC_CLASS.SAD_ENTRY);
        } else if (StringUtils.equals((CharSequence)docClassName, (CharSequence)PARTIAL_CLEARANCE_INVOICE_DOC_CLASS)) {
            this.findAndAttachDocumentDocumentToProcess(de, DOC_CLASS.PARTIAL_CLEARANCE_INVOICE);
        } else if (StringUtils.equals((CharSequence)docClassName, (CharSequence)SAD_STATEMENTS_DOC_CLASS)) {
            this.findAndAttachDocumentDocumentToProcess(de, DOC_CLASS.SAD_STATEMENTS);
        }
    }

    private void findAndAttachDocumentDocumentToProcess(DocumentEvent de, DOC_CLASS docClassType) {
        String sadNo = "";
        String invoiceNo = "";
        Long fileId = de.getDocument().getLFileId();
        this.log.debug("fileId: " + fileId);
        List indexesList = de.getDocument().getAlIndecies();
        for (IndexData indexData : indexesList) {
            if (StringUtils.equals((CharSequence)SAD_NO_INDEX, (CharSequence)indexData.getName())) {
                sadNo = indexData.getValue();
                this.log.debug("sadNoIndex: " + sadNo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)INVOICES_NO_NO_INDEX, (CharSequence)indexData.getName())) continue;
            invoiceNo = indexData.getValue();
            this.log.debug("invoiceNoIndex: " + invoiceNo);
        }
        if (docClassType.equals((Object)DOC_CLASS.SAD_ENTRY)) {
            if (StringUtils.isNotEmpty((CharSequence)sadNo)) {
                this.attachDocumentToProcess(docClassType, sadNo, null, fileId);
            }
        } else if ((docClassType.equals((Object)DOC_CLASS.SAD_STATEMENTS) || docClassType.equals((Object)DOC_CLASS.PARTIAL_CLEARANCE_INVOICE)) && StringUtils.isNotEmpty((CharSequence)sadNo) && StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            this.attachDocumentToProcess(docClassType, sadNo, invoiceNo, fileId);
        }
    }

    private void attachDocumentToProcess(DOC_CLASS docClassType, String sadNo, String invoice, long fileId) {
        WfDocument wfDocument = this.documentService.getDocument(Long.valueOf(fileId));
        HashMap<String, String> indexes = new HashMap<String, String>();
        if (docClassType.equals((Object)DOC_CLASS.SAD_ENTRY)) {
            indexes.put(INOVICE_PROC_SAD_NO_ID, sadNo);
        } else if (docClassType.equals((Object)DOC_CLASS.PARTIAL_CLEARANCE_INVOICE) || docClassType.equals((Object)DOC_CLASS.SAD_STATEMENTS)) {
            indexes.put(INOVICE_PROC_SAD_INV_NO_ID, sadNo);
        }
        List foundProcesses = this.processFinder.findByIndexes(INOVICE_PROC_DEF_ID, indexes, new String[0]);
        for (Process process : foundProcesses) {
            String processId = process.getProcessId();
            String activityId = this.activityFinder.findLastActivity(processId).getActivityId();
            this.log.debug("processId: " + processId + ", activityId: " + activityId);
            Map procCtx = this.processService.getProcessContext(processId);
            String referenceNo = (String)procCtx.get(INOVICE_PROC_REFERENCE_NO_ID);
            this.log.debug("referenceNo: " + referenceNo);
            if (docClassType.equals((Object)DOC_CLASS.SAD_STATEMENTS)) {
                String[] invoicesNoArray = StringUtils.split((String)invoice.toUpperCase(), (String)"_");
                HashSet<String> invoicesNoSet = new HashSet<String>(Arrays.asList(invoicesNoArray));
                this.log.debug("invoicesNoSet: " + invoicesNoSet);
                String invoiceNo = (String)procCtx.get(INOVICE_PROC_INVOICE_NO_ID);
                this.log.debug("invoiceNo: " + invoiceNo);
                if (!invoicesNoSet.contains(invoiceNo.toUpperCase())) continue;
                wfDocument.setIndexValue(INVOICES_NO_NO_INDEX, (Object)StringUtils.join(new HashSet<String>(Arrays.asList(StringUtils.split((String)invoice, (String)"_"))), (String)";"));
                WfFile file = wfDocument.getFile();
                file.setDescription(STATEMENT_INVOICES_DOC_DECRIPTION);
                this.fileService.updateFile(file);
            } else if (docClassType.equals((Object)DOC_CLASS.PARTIAL_CLEARANCE_INVOICE)) {
                String invoiceNo = (String)procCtx.get(INOVICE_PROC_INVOICE_NO_ID);
                this.log.debug("invoiceNo: " + invoiceNo);
                if (!StringUtils.equalsIgnoreCase((CharSequence)invoiceNo, (CharSequence)invoice)) continue;
                WfFile file = wfDocument.getFile();
                file.setDescription(PARTIAL_CLEARANCE_INVOICE_DOC_DECRIPTION);
                this.fileService.updateFile(file);
            }
            wfDocument.setIndexValue(REFERENCE_NO_INDEX, (Object)referenceNo);
            this.documentService.updateDocument(wfDocument);
            this.documentService.attachDocumentToProcess(wfDocument, "admin", processId, activityId);
            if (!docClassType.equals((Object)DOC_CLASS.PARTIAL_CLEARANCE_INVOICE)) continue;
            Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
            this.log.debug("activityId: " + activity.getActivityId());
            if (!StringUtils.equals((CharSequence)activity.getActivityDefinitionId(), (CharSequence)INOVICE_PROC_REGISTER_ACTIVITY_DEF_ID)) continue;
            Map context = this.activityService.getActivityContext(processId, activityId);
            context.put(INOVICE_PROC_PARTIAL_CLEARANCE_ID, "TAK");
            this.activityService.setActivityContext(processId, activityId, context);
        }
    }

    private static enum DOC_CLASS {
        SAD_ENTRY,
        PARTIAL_CLEARANCE_INVOICE,
        SAD_STATEMENTS;

    }
}

