/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.scheduledtasks;

import com.suncode.plugin.client.common.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class WaitingForSADAcceptTask {
    private Logger log = Logger.getLogger(WaitingForSADAcceptTask.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("waiting-for-sad-scheduled-task-id")).name("waiting-for-sad.name")).description("waiting-for-sad.desc")).category(new Category[]{Categories.INVOICES})).cancelable().parameter().id("processDefId").name("waiting-for-sad.processDefId.name").type((Type)Types.STRING).create()).parameter().id("acitivityDefId").name("waiting-for-sad.acitivityDefId.name").type((Type)Types.STRING).create()).parameter().id("actionId").name("waiting-for-sad.actionId.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String processDefId, @Param String acitivityDefId, @Param String actionId, CancelationHandler cancelationHandler, Logger logger, ProgressHolder progressHolder) throws Exception {
        progressHolder.setProgress(Double.valueOf(0.0));
        int activitiesCounter = 0;
        List<Activity> foundOpenedActivities = this.findOpenActivityByActivityDefId(acitivityDefId);
        for (Activity activity : foundOpenedActivities) {
            if (!cancelationHandler.isCanceled().booleanValue()) {
                Process process = this.processService.getProcess(activity.getProcessId(), new String[]{"processDefinition"});
                String foundProcessDefId = process.getProcessDefinition().getProcessDefinitionId();
                this.log.debug((Object)("foundProcessDefId: " + foundOpenedActivities));
                if (StringUtils.equals((CharSequence)processDefId, (CharSequence)foundProcessDefId)) {
                    logger.debug((Object)("Przetwarzanie zadania dla procesu " + process.getName()));
                    String userName = SystemProperties.getString((String)"Bufor.username");
                    this.log.debug((Object)("userName: " + userName));
                    try {
                        logger.debug((Object)("Akceptacja zadania " + activity.getActivityId()));
                        AcceptationDefinition acceptation = new AcceptationDefinition(activity.getProcessId(), activity.getActivityId(), userName, actionId);
                        acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                        acceptation.setIgnoreValidators(Boolean.valueOf(false));
                        this.activityService.acceptActivity(acceptation);
                        logger.debug((Object)"Zaakceptowano");
                        Comment comment = new Comment();
                        comment.setActivityId(activity.getActivityId());
                        comment.setProcessId(activity.getProcessId());
                        comment.setUserId(userName);
                        comment.setTimestamp(Long.valueOf(DateTime.now().getMillis()));
                        comment.setComment("Zadanie zosta\u0142o zaakceptowane automatycznie przez u\u017cytkownika " + userName);
                        this.commentService.createComment(comment);
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        String validationException = StringUtils.substringBetween((String)sw.toString(), (String)"validationErrors {", (String)"}");
                        if (validationException != null) {
                            logger.debug((Object)("Zadanie nie zosta\u0142o zaakceptowane: " + validationException));
                        }
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                        logger.debug((Object)("B\u0142\u0105d akceptacji zadania " + e.getMessage()));
                    }
                }
                progressHolder.setProgress(Double.valueOf(activitiesCounter++ / foundOpenedActivities.size()));
                continue;
            }
            logger.debug((Object)"Anulowano");
        }
        progressHolder.setProgress(Double.valueOf(1.0));
    }

    private List<Activity> findOpenActivityByActivityDefId(String activityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Activity.class);
        dc.add((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)activityDefId));
        List activityList = this.activityFinder.findByCriteria(dc);
        ArrayList<Activity> result = new ArrayList<Activity>();
        for (Activity activity : activityList) {
            if (!activity.isOpen()) continue;
            result.add(activity);
        }
        return result;
    }
}

