/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pdfutils.util;

import com.lowagie.text.Image;
import com.suncode.pdfutils.support.ElementAlignment;
import com.suncode.pdfutils.support.ElementAnchor;
import com.suncode.pdfutils.support.RotationMechanism;

public class WatermarkPositionerUtils {
    private static final float RIGHT_ANGLE_90_DEGREES = 90.0f;
    private static final float STRAIGHT_ANGLE_180_DEGREES = 180.0f;
    private static final float REFLEX_ANGLE_270_DEGREES = 270.0f;
    private static final float FULL_ANGLE_360_DEGREES = 360.0f;
    private static float xTriangleSide = 0.0f;
    private static float yTriangleSide = 0.0f;
    private static float xRotationSide = 0.0f;
    private static float yRotationSide = 0.0f;

    public static float calcPositionX(Integer percentageWidth, float pageWidth, ElementAlignment alignment) {
        switch (alignment) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return pageWidth / 100.0f * (float)percentageWidth.intValue();
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return pageWidth / 100.0f * (float)Math.abs(percentageWidth - 100);
            }
        }
        throw new IllegalArgumentException("Wrong alignment value");
    }

    public static float calcPositionY(Integer percentageHeight, float pageHeight, ElementAlignment alignment) {
        switch (alignment) {
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return pageHeight / 100.0f * (float)percentageHeight.intValue();
            }
            case TOP_LEFT: 
            case TOP_RIGHT: {
                return pageHeight / 100.0f * (float)Math.abs(percentageHeight - 100);
            }
        }
        throw new IllegalArgumentException("Wrong alignment value");
    }

    public static void setRotationBasedOnAnchor(Image image, float rotationDegrees, ElementAnchor anchor) {
        switch (anchor) {
            case TOP_LEFT: {
                WatermarkPositionerUtils.setRotationBasedOnTopLeftAnchor(image, rotationDegrees);
                break;
            }
            case TOP_MIDDLE: {
                WatermarkPositionerUtils.setRotationBasedOnTopMiddleAnchor(image, rotationDegrees);
                break;
            }
            case TOP_RIGHT: {
                WatermarkPositionerUtils.setRotationBasedOnTopRightAnchor(image, rotationDegrees);
                break;
            }
            case CENTER_LEFT: {
                WatermarkPositionerUtils.setRotationBasedOnCenterLeftAnchor(image, rotationDegrees);
                break;
            }
            case CENTER_MIDDLE: {
                WatermarkPositionerUtils.setRotationBasedOnCenterMiddleAnchor(image);
                break;
            }
            case CENTER_RIGHT: {
                WatermarkPositionerUtils.setRotationBasedOnCenterRightAnchor(image, rotationDegrees);
                break;
            }
            case BOTTOM_LEFT: {
                WatermarkPositionerUtils.setRotationBasedOnBottomLeftAnchor(image, rotationDegrees);
                break;
            }
            case BOTTOM_MIDDLE: {
                WatermarkPositionerUtils.setRotationBasedOnBottomMiddleAnchor(image, rotationDegrees);
                break;
            }
            case BOTTOM_RIGHT: {
                WatermarkPositionerUtils.setRotationBasedOnBottomRightAnchor(image, rotationDegrees);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong anchor value");
            }
        }
    }

    public static float setAngleDegreesBasedOnSpecifiedDirection(float rotationDegrees, RotationMechanism rotationMechanism) {
        if (rotationMechanism.equals((Object)RotationMechanism.METHOD_2)) {
            float resolvedRotationDegrees = rotationDegrees < 0.0f ? 360.0f + rotationDegrees % 360.0f : rotationDegrees % 360.0f;
            return 360.0f - resolvedRotationDegrees;
        }
        return rotationDegrees;
    }

    private static void setRotationBasedOnTopLeftAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            yRotationSide = (float)((double)image.getPlainHeight() * Math.cos(Math.toRadians(rotationDegrees)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, 0.0f, yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xRotationSide = (float)((double)image.getPlainWidth() * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, 0.0f);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            yRotationSide = (float)((double)image.getPlainWidth() * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, image.getScaledWidth(), yRotationSide);
        } else {
            xRotationSide = (float)((double)image.getPlainHeight() * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, image.getScaledHeight());
        }
    }

    private static void setRotationBasedOnTopMiddleAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees)));
            xRotationSide = image.getScaledWidth() / 2.0f - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees)));
            yRotationSide = image.getScaledHeight() / 2.0f + yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f + xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f + xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f + yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        }
    }

    private static void setRotationBasedOnTopRightAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xRotationSide = (float)((double)image.getPlainWidth() * Math.cos(Math.toRadians(rotationDegrees)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, image.getScaledHeight());
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            yRotationSide = (float)((double)image.getPlainWidth() * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, 0.0f, yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xRotationSide = (float)((double)image.getPlainHeight() * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, 0.0f);
        } else {
            yRotationSide = (float)((double)image.getPlainHeight() * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, image.getScaledWidth(), yRotationSide);
        }
    }

    private static void setRotationBasedOnCenterLeftAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees)));
            yRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            xRotationSide = image.getScaledWidth() - xTriangleSide;
            yRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            xRotationSide = image.getScaledWidth() - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            yRotationSide = image.getScaledHeight() - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else {
            xRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            yRotationSide = image.getScaledHeight() - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        }
    }

    private static void setRotationBasedOnCenterMiddleAnchor(Image image) {
        WatermarkPositionerUtils.updateImageAbsolutePosition(image, image.getScaledWidth() / 2.0f, image.getScaledHeight() / 2.0f);
    }

    private static void setRotationBasedOnCenterRightAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees)));
            xRotationSide = image.getScaledWidth() - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees)));
            yRotationSide = image.getScaledHeight() - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            yRotationSide = image.getScaledHeight() - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            yRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            xRotationSide = image.getScaledWidth() - xTriangleSide;
            yRotationSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        }
    }

    private static void setRotationBasedOnBottomLeftAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xRotationSide = (float)((double)image.getPlainHeight() * Math.sin(Math.toRadians(rotationDegrees)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, 0.0f);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            yRotationSide = (float)((double)image.getPlainHeight() * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, image.getScaledWidth(), yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xTriangleSide = (float)((double)image.getPlainWidth() * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xTriangleSide, image.getScaledHeight());
        } else {
            yTriangleSide = (float)((double)image.getPlainWidth() * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, 0.0f, yTriangleSide);
        }
    }

    private static void setRotationBasedOnBottomMiddleAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees)));
            xRotationSide = image.getScaledWidth() / 2.0f + xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees)));
            yRotationSide = image.getScaledHeight() / 2.0f - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f + xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 90.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f + yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 180.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f + yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        } else {
            xTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.cos(Math.toRadians(rotationDegrees - 270.0f)));
            xRotationSide = image.getScaledWidth() / 2.0f - xTriangleSide;
            yTriangleSide = (float)((double)(image.getPlainHeight() / 2.0f) * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            yRotationSide = image.getScaledHeight() / 2.0f - yTriangleSide;
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, yRotationSide);
        }
    }

    private static void setRotationBasedOnBottomRightAnchor(Image image, float rotationDegrees) {
        if (rotationDegrees >= 0.0f && rotationDegrees <= 90.0f) {
            yRotationSide = (float)((double)image.getPlainWidth() * Math.sin(Math.toRadians(rotationDegrees)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, image.getScaledWidth(), yRotationSide);
        } else if (rotationDegrees > 90.0f && rotationDegrees <= 180.0f) {
            xRotationSide = (float)((double)image.getPlainHeight() * Math.cos(Math.toRadians(rotationDegrees - 90.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, image.getScaledHeight());
        } else if (rotationDegrees > 180.0f && rotationDegrees <= 270.0f) {
            yRotationSide = (float)((double)image.getPlainHeight() * Math.cos(Math.toRadians(rotationDegrees - 180.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, 0.0f, yRotationSide);
        } else {
            xRotationSide = (float)((double)image.getPlainWidth() * Math.sin(Math.toRadians(rotationDegrees - 270.0f)));
            WatermarkPositionerUtils.updateImageAbsolutePosition(image, xRotationSide, 0.0f);
        }
    }

    private static void updateImageAbsolutePosition(Image image, float xSide, float ySide) {
        image.setAbsolutePosition(image.getAbsoluteX() - xSide, image.getAbsoluteY() - ySide);
    }
}

