/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pdfutils.restrictions;

import com.suncode.pdfutils.restrictions.Restrictions;

public class AdvancedRestrictions
extends Restrictions {
    private boolean allowDegradedPrinting = true;
    private boolean allowAssembly = true;
    private boolean allowFillIn = true;
    private boolean allowModifyAnnotations = true;
    private boolean allowScreenreaders = true;

    public boolean isAllowDegradedPrinting() {
        return this.allowDegradedPrinting;
    }

    public void setAllowDegradedPrinting(boolean allowDegradedPrinting) {
        this.allowDegradedPrinting = allowDegradedPrinting;
    }

    public boolean isAllowAssembly() {
        return this.allowAssembly;
    }

    public void setAllowAssembly(boolean allowAssembly) {
        this.allowAssembly = allowAssembly;
    }

    public boolean isAllowFillIn() {
        return this.allowFillIn;
    }

    public void setAllowFillIn(boolean allowFillIn) {
        this.allowFillIn = allowFillIn;
    }

    public boolean isAllowModifyAnnotations() {
        return this.allowModifyAnnotations;
    }

    public void setAllowModifyAnnotations(boolean allowModifyAnnotations) {
        this.allowModifyAnnotations = allowModifyAnnotations;
    }

    public boolean isAllowScreenreaders() {
        return this.allowScreenreaders;
    }

    public void setAllowScreenreaders(boolean allowScreenreaders) {
        this.allowScreenreaders = allowScreenreaders;
    }

    @Override
    public int getRestrictions() {
        int restrictions = 0;
        if (this.isAllowPrinting()) {
            restrictions |= 0x804;
        }
        if (this.isAllowCopy()) {
            restrictions |= 0x10;
        }
        if (this.isAllowModifyContents()) {
            restrictions |= 0x20;
        }
        if (this.allowDegradedPrinting) {
            restrictions |= 4;
        }
        if (this.allowAssembly) {
            restrictions |= 0x400;
        }
        if (this.allowFillIn) {
            restrictions |= 0x100;
        }
        if (this.allowModifyAnnotations) {
            restrictions |= 0x20;
        }
        if (this.allowScreenreaders) {
            restrictions |= 0x200;
        }
        return restrictions;
    }

    @Override
    public void setAllRestrictions(boolean value) {
        super.setAllRestrictions(value);
        this.setAllowDegradedPrinting(value);
        this.setAllowAssembly(value);
        this.setAllowFillIn(value);
        this.setAllowModifyAnnotations(value);
        this.setAllowScreenreaders(value);
    }
}

