/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pdfutils;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.suncode.pdfutils.exception.CompressionFileSizeNotReachedException;
import com.suncode.pdfutils.exception.NotSupportedImageException;
import com.suncode.pdfutils.resize.PdfContentScaler;
import com.suncode.pdfutils.resize.PdfResizer;
import com.suncode.pdfutils.restrictions.PasswordProtection;
import com.suncode.pdfutils.restrictions.Restrictions;
import com.suncode.pdfutils.support.ElementCoordinates;
import com.suncode.pdfutils.support.InsertedFileProperties;
import com.suncode.pdfutils.support.RotationMechanism;
import com.suncode.pdfutils.support.TemporaryFile;
import com.suncode.pdfutils.support.TextInfo;
import com.suncode.pdfutils.util.WatermarkPositionerUtils;
import com.suncode.pdfutils.watermark.Watermark;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.pdfutils.watermark.WatermarkText;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfUtils {
    /*
     * Exception decompiling
     */
    public static InputStream addWatermarkAsImage(InputStream stream, WatermarkImage watermark, TemporaryFile temporaryFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static InputStream addWatermarkAsImageOnSpecifiedPage(InputStream stream, WatermarkImage watermark, TemporaryFile temporaryFile, Integer pageNumber) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static InputStream addWatermarkAsText(InputStream stream, WatermarkText watermark, TemporaryFile temporaryFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream addRestrictions(InputStream is, Restrictions restrictions, TemporaryFile tFile) throws Exception {
        ByteArrayInputStream bais;
        File file = null;
        FileOutputStream fos = null;
        try {
            file = tFile.getFile();
            fos = new FileOutputStream(file);
            PdfReader reader = new PdfReader(is);
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)fos);
            PasswordProtection pp = restrictions.getPasswordProtection();
            stamp.setEncryption(StringUtils.getBytesUtf8((String)pp.getUserPassword()), StringUtils.getBytesUtf8((String)pp.getOwnerPassword()), restrictions.getRestrictions(), pp.getEncryption());
            stamp.close();
            is = new FileInputStream(file);
            bais = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)is));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(fos);
            FileUtils.deleteQuietly((File)file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fos);
        FileUtils.deleteQuietly((File)file);
        return bais;
    }

    public static List<byte[]> convertPdfToImagesAsync(byte[] pdfFile, String imageFormat, int dpi) {
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        try (PDDocument document = Loader.loadPDF((byte[])pdfFile);){
            int pageCount = document.getNumberOfPages();
            ExecutorService executor = Executors.newFixedThreadPool(Math.min(pageCount, Runtime.getRuntime().availableProcessors()));
            ArrayList<Future<byte[]>> futures = new ArrayList<Future<byte[]>>();
            int i = 0;
            while (i < pageCount) {
                int n = i++;
                futures.add(executor.submit(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }));
            }
            for (Future future : futures) {
                images.add((byte[])future.get());
            }
            executor.shutdown();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failed to convert PDF to images", e);
        }
        return images;
    }

    public static List<byte[]> convertPdfToImages(byte[] pdfFile, String imageFormat, int dpi) {
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        try (PDDocument document = Loader.loadPDF((byte[])pdfFile);){
            PDFRenderer renderer = new PDFRenderer(document);
            int pageCount = document.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, (float)dpi);
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)image, imageFormat, outputStream);
                    images.add(outputStream.toByteArray());
                    continue;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert PDF to images", e);
        }
        return images;
    }

    public static void resizePdf(String sourcePath, String destinationPath, double scalar, Float compression, boolean deleteSource) throws IOException, NotSupportedImageException {
        PdfUtils.resizePdf(sourcePath, destinationPath, scalar, compression, deleteSource, null);
    }

    public static void resizePdf(String sourcePath, String destinationPath, double scalar, Float compression, boolean deleteSource, PdfResizer.ResizeMethod method) throws IOException, NotSupportedImageException {
        PdfResizer resizer = compression != null && compression.floatValue() > 0.0f && (double)compression.floatValue() <= 1.0 ? new PdfResizer(sourcePath, destinationPath, scalar, compression.floatValue()) : new PdfResizer(sourcePath, destinationPath, scalar);
        resizer.setDeleteSource(deleteSource);
        resizer.setResizeMethod(method != null ? method : PdfResizer.ResizeMethod.ULTRA);
        resizer.resize();
    }

    public static InputStream resizePdfToTargetSize(float thresholdMB, InputStream inputPdf) throws IOException, NotSupportedImageException, CompressionFileSizeNotReachedException {
        PdfResizer resizer = new PdfResizer();
        byte[] pdfData = IOUtils.toByteArray((InputStream)inputPdf);
        resizer.determineCompressionParametersForFile(thresholdMB, new ByteArrayInputStream(pdfData));
        return resizer.resize(new ByteArrayInputStream(pdfData));
    }

    public static InputStream addImageWithContentScaling(InputStream inputPdf, InsertedFileProperties insertedFileProperties) throws IOException, DocumentException {
        return PdfContentScaler.scaleContentWithAddedImage(inputPdf, insertedFileProperties);
    }

    private static void insertTextOnPage(int pageNumber, PdfReader reader, PdfStamper stamper, PdfGState gstate, WatermarkText watermark, BaseFont baseFont) {
        PdfContentByte watermarkContent = stamper.getOverContent(pageNumber);
        watermarkContent.setGState(gstate);
        Chunk textChunk = new Chunk(watermark.getText(), new Font(baseFont, watermark.getSize().floatValue(), -1, watermark.getColor()));
        if (watermark.getBackgroundColor() != null) {
            textChunk.setBackground(watermark.getBackgroundColor());
        }
        ElementCoordinates elementCoordinates = PdfUtils.calculateElementCoordinatesOnPage(watermark, reader, pageNumber);
        TextInfo textInfo = new TextInfo(elementCoordinates.getX(), elementCoordinates.getY(), watermark.getSize().floatValue());
        watermark.getAnchor().fixPosition(textInfo);
        ColumnText.showTextAligned((PdfContentByte)watermarkContent, (int)watermark.getAnchor().getLowagieAlignment().getLowagieAlignmentValue(), (Phrase)new Phrase(textChunk), (float)textInfo.getTextPositionX(), (float)textInfo.getTextPositionY(), (float)watermark.getRotation().floatValue());
    }

    private static ElementCoordinates calculateElementCoordinatesOnPage(Watermark watermark, PdfReader reader, int pageNumber) {
        Rectangle pageSize = reader.getPageSizeWithRotation(pageNumber);
        float x = watermark.getPercentagePositionX() >= 0 ? WatermarkPositionerUtils.calcPositionX(watermark.getPercentagePositionX(), pageSize.getWidth(), watermark.getAlignment()) : watermark.getPositionX().floatValue();
        float y = watermark.getPercentagePositionY() >= 0 ? WatermarkPositionerUtils.calcPositionY(watermark.getPercentagePositionY(), pageSize.getHeight(), watermark.getAlignment()) : watermark.getPositionY().floatValue();
        return new ElementCoordinates(x, y);
    }

    private static void removePDFPasswordAgainstModification(PdfReader reader) {
        Field field = reader.getClass().getDeclaredField("encrypted");
        field.setAccessible(true);
        if (((Boolean)field.get(reader)).booleanValue()) {
            field.set(reader, false);
        }
    }

    private static /* synthetic */ void lambda$addWatermarkAsText$1(PdfReader reader, PdfStamper stamper, PdfGState gstate, WatermarkText watermark, BaseFont baseFont, int pageNumber) {
        PdfUtils.insertTextOnPage(pageNumber, reader, stamper, gstate, watermark, baseFont);
    }

    private static /* synthetic */ void lambda$addWatermarkAsImage$0(PdfStamper stamper, PdfGState gstate, WatermarkImage watermark, PdfReader reader, Image image, float rotationDegrees, int i) {
        PdfContentByte watermarkContent = stamper.getOverContent(i);
        watermarkContent.setGState(gstate);
        try {
            ElementCoordinates elementCoordinates = PdfUtils.calculateElementCoordinatesOnPage(watermark, reader, i);
            image.setAbsolutePosition(elementCoordinates.getX(), elementCoordinates.getY());
            if (watermark.getRotationMechanism().equals((Object)RotationMechanism.METHOD_2)) {
                WatermarkPositionerUtils.setRotationBasedOnAnchor(image, rotationDegrees, watermark.getAnchor());
            } else {
                watermark.getAnchor().fixPosition(image);
            }
            watermarkContent.addImage(image);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }
}

