/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pdfutils.support;

import com.lowagie.text.Image;
import com.suncode.pdfutils.support.LowagieAlignment;
import com.suncode.pdfutils.support.TextInfo;
import java.beans.ConstructorProperties;

public enum ElementAnchor {
    TOP_LEFT(LowagieAlignment.LEFT, 0.0f, 1.0f),
    TOP_MIDDLE(LowagieAlignment.MIDDLE, 0.5f, 1.0f),
    TOP_RIGHT(LowagieAlignment.RIGHT, 1.0f, 1.0f),
    CENTER_LEFT(LowagieAlignment.LEFT, 0.0f, 0.5f),
    CENTER_MIDDLE(LowagieAlignment.MIDDLE, 0.5f, 0.5f),
    CENTER_RIGHT(LowagieAlignment.RIGHT, 1.0f, 0.5f),
    BOTTOM_LEFT(LowagieAlignment.LEFT, 0.0f, 0.0f),
    BOTTOM_MIDDLE(LowagieAlignment.MIDDLE, 0.5f, 0.0f),
    BOTTOM_RIGHT(LowagieAlignment.RIGHT, 1.0f, 0.0f);

    private final LowagieAlignment lowagieAlignment;
    private float xFactor;
    private float yFactor;

    public void fixPosition(Image image) {
        float posX = image.getAbsoluteX();
        float posY = image.getAbsoluteY();
        float width = image.getWidth();
        float height = image.getHeight();
        image.setAbsolutePosition(posX - this.xFactor * width, posY - this.yFactor * height);
    }

    public void fixPosition(TextInfo textInfo) {
        float posY = textInfo.getTextPositionY();
        float textSize = textInfo.getTextSize();
        textInfo.setTextPositionY(posY - this.yFactor * textSize);
    }

    public LowagieAlignment getLowagieAlignment() {
        return this.lowagieAlignment;
    }

    public float getXFactor() {
        return this.xFactor;
    }

    public float getYFactor() {
        return this.yFactor;
    }

    @ConstructorProperties(value={"lowagieAlignment", "xFactor", "yFactor"})
    private ElementAnchor(LowagieAlignment lowagieAlignment, float xFactor, float yFactor) {
        this.lowagieAlignment = lowagieAlignment;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }
}

