/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pdfutils.resize;

import com.suncode.pdfutils.support.InsertedFileProperties;
import com.suncode.pdfutils.support.enums.ImageDestinationPage;
import com.suncode.pdfutils.support.enums.ImagePositionOnPage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfContentScaler {
    private static final Logger log = LoggerFactory.getLogger(PdfContentScaler.class);
    private static final float DEFAULT_MARGIN = 20.0f;
    private static final float CONTENT_SPACING = 5.0f;
    private static final float TOP_MARGIN_REDUCTION = 18.0f;
    private static final float MIN_SCALE_FACTOR = 0.3f;

    private PdfContentScaler() {
    }

    public static InputStream scaleContentWithAddedImage(InputStream inputPdf, InsertedFileProperties insertedFileProperties) throws IOException {
        byte[] imageData;
        byte[] pdfData = IOUtils.toByteArray((InputStream)inputPdf);
        try (InputStream imageInputStream = insertedFileProperties.getFileInputStream();){
            imageData = IOUtils.toByteArray((InputStream)imageInputStream);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (PDDocument originalDocument = Loader.loadPDF((byte[])pdfData);
             PDDocument outputDocument = new PDDocument();){
            float imageY;
            float imageX;
            int totalPages = originalDocument.getNumberOfPages();
            int targetPageIndex = insertedFileProperties.getImageDestinationPage() == ImageDestinationPage.FIRST_PAGE ? 0 : Math.max(0, totalPages - 1);
            PDPage targetPage = originalDocument.getPage(targetPageIndex);
            PDRectangle pageSize = targetPage.getMediaBox();
            float pageWidth = pageSize.getWidth();
            float pageHeight = pageSize.getHeight();
            PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)originalDocument, (byte[])imageData, (String)"image");
            float originalWidth = image.getWidth();
            float originalHeight = image.getHeight();
            ImagePositionOnPage position = insertedFileProperties.getImagePositionOnPage();
            switch (position) {
                case TOP_MIDDLE: {
                    imageX = (pageWidth - originalWidth) / 2.0f;
                    imageY = pageHeight - 20.0f - originalHeight;
                    break;
                }
                case TOP_RIGHT: {
                    imageX = pageWidth - 20.0f - originalWidth;
                    imageY = pageHeight - 20.0f - originalHeight;
                    break;
                }
                case BOTTOM_LEFT: {
                    imageX = 20.0f;
                    imageY = 20.0f;
                    break;
                }
                case BOTTOM_MIDDLE: {
                    imageX = (pageWidth - originalWidth) / 2.0f;
                    imageY = 20.0f;
                    break;
                }
                case BOTTOM_RIGHT: {
                    imageX = pageWidth - 20.0f - originalWidth;
                    imageY = 20.0f;
                    break;
                }
                default: {
                    imageX = 20.0f;
                    imageY = pageHeight - 20.0f - originalHeight;
                }
            }
            float contentScaleFactor = PdfContentScaler.calculateContentScaleFactorForCollision(originalHeight, pageHeight);
            log.debug("Content will be scaled regardless of collisions. Factor: {}", (Object)Float.valueOf(contentScaleFactor));
            for (int pageNum = 0; pageNum < totalPages; ++pageNum) {
                PDPage originalPage = originalDocument.getPage(pageNum);
                PDPage newPage = new PDPage(pageSize);
                outputDocument.addPage(newPage);
                if (pageNum == targetPageIndex) {
                    PdfContentScaler.processPage(outputDocument, newPage, originalPage, image, contentScaleFactor, imageX, imageY, pageWidth, pageHeight, position);
                    continue;
                }
                PdfContentScaler.copyPageContent(outputDocument, newPage, originalPage);
            }
            outputDocument.save((OutputStream)outputStream);
            log.debug("The graphic was successfully added to the document with {} pages", (Object)totalPages);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static float calculateContentScaleFactorForCollision(float imageHeight, float pageHeight) {
        float totalImageHeight = 20.0f + imageHeight + 5.0f;
        float imageAreaHeight = totalImageHeight - 18.0f;
        float availableHeight = pageHeight - imageAreaHeight;
        float scaleFactor = availableHeight / pageHeight;
        log.debug("Scaling calculation: graphic {}px, area {}px, available {}px, factor {}", new Object[]{Float.valueOf(imageHeight), Float.valueOf(imageAreaHeight), Float.valueOf(availableHeight), Float.valueOf(scaleFactor)});
        return Math.max(scaleFactor, 0.3f);
    }

    private static void processPage(PDDocument outputDoc, PDPage newPage, PDPage originalPage, PDImageXObject image, float contentScaleFactor, float imageX, float imageY, float pageWidth, float pageHeight, ImagePositionOnPage position) throws IOException {
        try (PDPageContentStream contentStream = new PDPageContentStream(outputDoc, newPage);){
            log.debug("Content scaling factor: {}", (Object)Float.valueOf(contentScaleFactor));
            PDFormXObject form = PdfContentScaler.createFormFromPage(outputDoc, originalPage);
            float scaledWidth = pageWidth * contentScaleFactor;
            float scaledHeight = pageHeight * contentScaleFactor;
            float offsetX = (pageWidth - scaledWidth) / 2.0f;
            float imageAreaHeight = 20.0f + (float)image.getHeight() + 5.0f - 18.0f;
            boolean placeAtTop = position == ImagePositionOnPage.TOP_LEFT || position == ImagePositionOnPage.TOP_MIDDLE || position == ImagePositionOnPage.TOP_RIGHT;
            float offsetY = placeAtTop ? pageHeight - imageAreaHeight - scaledHeight : imageAreaHeight;
            contentStream.saveGraphicsState();
            Matrix matrix = Matrix.getScaleInstance((float)contentScaleFactor, (float)contentScaleFactor);
            matrix.translate(offsetX / contentScaleFactor, offsetY / contentScaleFactor);
            contentStream.transform(matrix);
            contentStream.drawForm(form);
            contentStream.restoreGraphicsState();
            log.debug("Content scaled by {} and shifted by ({}, {})", new Object[]{Float.valueOf(contentScaleFactor), Float.valueOf(offsetX), Float.valueOf(offsetY)});
            contentStream.drawImage(image, imageX, imageY);
        }
    }

    private static PDFormXObject createFormFromPage(PDDocument outputDoc, PDPage originalPage) throws IOException {
        if (originalPage.getContents() == null) {
            return null;
        }
        PDFormXObject form = new PDFormXObject(outputDoc);
        form.setResources(originalPage.getResources());
        form.setBBox(originalPage.getMediaBox());
        COSStream formStream = form.getCOSObject();
        try (InputStream originalContent = originalPage.getContents();
             OutputStream formOutput = formStream.createOutputStream();){
            IOUtils.copy((InputStream)originalContent, (OutputStream)formOutput);
        }
        return form;
    }

    private static void copyPageContent(PDDocument outputDoc, PDPage newPage, PDPage originalPage) throws IOException {
        newPage.setResources(originalPage.getResources());
        PDFormXObject form = PdfContentScaler.createFormFromPage(outputDoc, originalPage);
        if (form != null) {
            try (PDPageContentStream contentStream = new PDPageContentStream(outputDoc, newPage);){
                contentStream.drawForm(form);
            }
        }
    }
}

