// definicje komponentow zawartych w CUFscripts
//Plik ten jest ładowany przez PWE, dlatego tłumaczenia są dodane tutaj na sztywno.
var CUFDefs = {
  t: function (key) {
    var localized = CUFDefs.translations[Suncode.getUserLocale()];
    if (!localized) {
      localized = CUFDefs.translations['en'];
    }
    return localized[key] ? localized[key] : key;
  },

  translations: {
    pl: {
      showHidden: 'Uwzględnij ukryte kolumny',
      fileName: 'Nazwa pliku',
      windowTitle: 'Tytuł okna',

      'importFromExcel.name': 'Import pliku Excel',
      'importFromExcel.description': 'Import linii tabeli z pliku Excel',
      'importFromExcel.button.name': 'Importuj',
      'importFromExcel.button.tooltip': 'Importuj linie z pliku',
      'importFromExcel.param.saveData': 'Zapisz dane po wczytaniu',
      'importFromExcel.param.fileButtonLabel': 'Przycisk wyboru pliku',
      'importFromExcel.param.fileButtonLabel.defaultValue': 'Wybierz plik',
      'importFromExcel.param.loadButtonLabel': 'Przycisk importowania',
      'importFromExcel.param.functionName': 'Dodatkowa funkcja',

      'exportDTScheme.name': 'Eksport schematu tabeli',
      'exportDTScheme.description': 'Eksport nagłówka tabeli',
      'exportDTScheme.button.name': 'Pobierz schemat',
      'exportDTScheme.button.tooltip': 'Pobierz schemat tabeli',

      'exportToXls.name': 'Eksport do pliku Excel',
      'exportToXls.description': 'Eksport linii z tabeli do pliku Excel',
      'exportToXls.button.name': 'Eksportuj',
      'exportToXls.button.tooltip': 'Eksportuj linie do pliku',

      'saveDT.name': 'Zapis tabeli',
      'saveDT.description': 'Zapisuje całą zawartość tabeli',
      'saveDT.button.name': 'Zapisz',
      'saveDT.button.tooltip': 'Zapisz zawartość tabeli',
      'saveDT.param.saveHidden': 'Zapis ukrytych',
      'saveDT.param.enableSetAsDefault': 'Zapis jako domyślny',
      'saveDT.param.excludedColumns': 'Wykluczone kolumny',
      'saveDT.param.optionalTabTitle': 'Opcjonalna nazwa zapisu',

      'loadDT.name': 'Uzupełnij tabelę',
      'loadDT.description': 'Uzupełnia zawartość tabeli za pomocą wcześniejszego zapisu',
      'loadDT.button.name': 'Załaduj',
      'loadDT.button.tooltip': 'Załaduj zawartość tabeli',
      'loadDT.param.windowTitle.defaultValue': 'Zarządzanie zawartością tabeli dynamicznej',
      'loadDT.param.limitByUser': 'Limitowanie po użytkowniku',
      'loadDT.param.enableLoad': 'Możliwość ładowania',
      'loadDT.param.enableLoadButtonLabel': 'Tekst przycisku ładowania',
      'loadDT.param.askBeforeAdd': 'Zapytaj przed ładowaniem',
      'loadDT.param.deleteWhenAdd': 'Usuń przed ładowaniem',
      'loadDT.param.enableShow': 'Możliwość podglądu',
      'loadDT.param.enableShowButtonLabel': 'Tekst przycisku podglądu',
      'loadDT.param.enableShowButtonLabel.defaultValue': 'Podgląd',
      'loadDT.param.enableSetDefault': 'Zmień domyślny',
      'loadDT.param.enableSetDefaultButtonLabel': 'Tekst przycisku zmiany domyślnego',
      'loadDT.param.enableSetDefaultButtonLabel.defaultValue': 'Domyślny',
      'loadDT.param.enableDelete': 'Możliwość usuwania',
      'loadDT.param.enableDeleteButtonLabel': 'Tekst przycisku usuwania',
      'loadDT.param.enableDeleteButtonLabel.defaultValue': 'Usuń',
      'loadDT.param.optionalTabTitle': 'Opcjonalna nazwa zapisu',

      'removeAll.name': 'Usuń wszystkie rekordy',
      'removeAll.description': 'Usuwa wszystkie rekordy z tabeli',
      'removeAll.button.name': 'Usuń wszystkie',
      'removeAll.button.tooltip': 'Usuń wszystkie rekordy',

      'checkComment.description': 'Sprawdza, czy w obecnym zadaniu został dodany komentarz',
      'saveAllVariables.description': 'Zapisuje formularz',
    },
    en: {
      showHidden: 'Show hidden',
      fileName: 'File name',
      windowTitle: 'Window title',

      'importFromExcel.name': 'Import from xls',
      'importFromExcel.description': 'Import variable set lines from xls file',
      'importFromExcel.button.name': 'Import',
      'importFromExcel.button.tooltip': 'Import variable set lines from file',
      'importFromExcel.param.saveData': 'Save date after load',
      'importFromExcel.param.fileButtonLabel': 'Choose file button',
      'importFromExcel.param.fileButtonLabel.defaultValue': 'Choose file',
      'importFromExcel.param.loadButtonLabel': 'Import button',
      'importFromExcel.param.functionName': 'Additional function',

      'exportDTScheme.name': 'Variable set schema export',
      'exportDTScheme.description': 'Variable set header export',
      'exportDTScheme.button.name': 'Export schema',
      'exportDTScheme.button.tooltip': 'Export variable set schema',

      'exportToXls.name': 'Export to xls',
      'exportToXls.description': 'Export variable set lines to xls file',
      'exportToXls.button.name': 'Export',
      'exportToXls.button.tooltip': 'Export variable set lines to file',

      'saveDT.name': 'Save variable set',
      'saveDT.description': 'Save variable set content',
      'saveDT.button.name': 'Save',
      'saveDT.button.tooltip': 'Save variable set content',
      'saveDT.param.saveHidden': 'Save hidden',
      'saveDT.param.enableSetAsDefault': 'Enable save as default',
      'saveDT.param.excludedColumns': 'Excluded columns',
      'saveDT.param.optionalTabTitle': 'Optional save name',

      'loadDT.name': 'Load variable set',
      'loadDT.description': 'Load variable set content using saved data',
      'loadDT.button.name': 'Load',
      'loadDT.button.tooltip': 'Load variable set content',
      'loadDT.param.windowTitle.defaultValue': 'Variable set content management',
      'loadDT.param.limitByUser': 'Limit by user',
      'loadDT.param.enableLoad': 'Enable load',
      'loadDT.param.enableLoadButtonLabel': 'Load button label',
      'loadDT.param.askBeforeAdd': 'Ask before load',
      'loadDT.param.deleteWhenAdd': 'Remove before load',
      'loadDT.param.enableShow': 'Enable preview',
      'loadDT.param.enableShowButtonLabel': 'Preview button label',
      'loadDT.param.enableShowButtonLabel.defaultValue': 'Preview',
      'loadDT.param.enableSetDefault': 'Change default',
      'loadDT.param.enableSetDefaultButtonLabel': 'Change default button label',
      'loadDT.param.enableSetDefaultButtonLabel.defaultValue': 'Default',
      'loadDT.param.enableDelete': 'Enable delete',
      'loadDT.param.enableDeleteButtonLabel': 'Delete button label',
      'loadDT.param.enableDeleteButtonLabel.defaultValue': 'Delete',
      'loadDT.param.optionalTabTitle': 'Optional save name',

      'removeAll.name': 'Remove all records',
      'removeAll.description': 'Remove all records from variable set',
      'removeAll.button.name': 'Remove all',
      'removeAll.button.tooltip': 'Remove all records',

      'checkComment.description': 'Checks, if comment has been added to current activity',
      'saveAllVariables.description': 'Saves form',
    },
  },
};

CUFDefs.DTButtons = {
  importFromXls: {
    name: CUFDefs.t('importFromExcel.name'),
    descr: CUFDefs.t('importFromExcel.description'),
    buttonId: 'CUF_import_from_xls_button',
    text: CUFDefs.t('importFromExcel.button.name'),
    icon: 'style/img/fam/page_excel.png',
    tooltip: CUFDefs.t('importFromExcel.button.tooltip'),
    handler: 'CUF.table.service.TableButton.importFromExcel',
    params: [
      {
        viewName: CUFDefs.t('showHidden'),
        realName: 'showHidden',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('importFromExcel.param.saveData'),
        realName: 'saveData',
        type: 'boolean',
        defaultValue: true,
      },
      {
        viewName: CUFDefs.t('importFromExcel.param.fileButtonLabel'),
        realName: 'fileButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('importFromExcel.param.fileButtonLabel.defaultValue'),
      },
      {
        viewName: CUFDefs.t('importFromExcel.param.loadButtonLabel'),
        realName: 'loadButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('importFromExcel.button.name'),
      },
      {
        viewName: CUFDefs.t('windowTitle'),
        realName: 'windowTitle',
        type: 'string',
        defaultValue: CUFDefs.t('importFromExcel.name'),
      },
      {
        viewName: CUFDefs.t('importFromExcel.param.functionName'),
        realName: 'functionName',
        type: 'string',
        defaultValue: '',
      },
    ],
  },
  exportDTScheme: {
    name: CUFDefs.t('exportDTScheme.name'),
    descr: CUFDefs.t('exportDTScheme.description'),
    buttonId: 'CUF_export_dt_scheme_button',
    text: CUFDefs.t('exportDTScheme.button.name'),
    icon: 'style/img/fam/page_excel.png',
    tooltip: CUFDefs.t('exportDTScheme.button.tooltip'),
    handler: 'CUF.table.service.TableButton.exportSchemaToExcel',
    params: [
      {
        viewName: CUFDefs.t('showHidden'),
        realName: 'showHidden',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('fileName'),
        realName: 'title',
        type: 'string',
        defaultValue: '',
      },
    ],
  },
  exportToXls: {
    name: CUFDefs.t('exportToXls.name'),
    descr: CUFDefs.t('exportToXls.description'),
    buttonId: 'CUF_export_to_xls_button',
    text: CUFDefs.t('exportToXls.button.name'),
    icon: 'style/img/fam/page_excel.png',
    tooltip: CUFDefs.t('exportToXls.button.tooltip'),
    handler: 'CUF.table.service.TableButton.exportToExcel',
    params: [
      {
        viewName: CUFDefs.t('showHidden'),
        realName: 'showHidden',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('fileName'),
        realName: 'title',
        type: 'string',
        defaultValue: '',
      },
    ],
  },
  saveDT: {
    name: CUFDefs.t('saveDT.name'),
    descr: CUFDefs.t('saveDT.description'),
    buttonId: 'CUF_save_dt_button',
    text: CUFDefs.t('saveDT.button.name'),
    icon: 'style/img/fam/database_add.png',
    tooltip: CUFDefs.t('saveDT.button.tooltip'),
    handler: 'CUF_executeSaveDynamicTableContent',
    params: [
      {
        viewName: CUFDefs.t('windowTitle'),
        realName: 'windowTitle',
        type: 'string',
        defaultValue: CUFDefs.t('saveDT.name'),
      },
      {
        viewName: CUFDefs.t('saveDT.param.saveHidden'),
        realName: 'saveHidden',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('saveDT.param.enableSetAsDefault'),
        realName: 'enableSetAsDefault',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('saveDT.param.excludedColumns'),
        realName: 'excludedColumns',
        type: 'string',
        defaultValue: '',
      },
      {
        viewName: CUFDefs.t('saveDT.param.optionalTabTitle'),
        realName: 'optionalTabTitle',
        type: 'string',
        defaultValue: '',
      },
    ],
  },
  loadDT: {
    name: CUFDefs.t('loadDT.name'),
    descr: CUFDefs.t('loadDT.description'),
    buttonId: 'CUF_load_dt_button',
    text: CUFDefs.t('loadDT.button.name'),
    icon: 'style/img/fam/table_edit.png',
    tooltip: CUFDefs.t('loadDT.button.tooltip'),
    handler: 'CUF_executeDynamicTableContentManagement',
    params: [
      {
        viewName: CUFDefs.t('windowTitle'),
        realName: 'windowTitle',
        type: 'string',
        defaultValue: CUFDefs.t('loadDT.param.windowTitle.defaultValue'),
      },
      {
        viewName: CUFDefs.t('loadDT.param.limitByUser'),
        realName: 'limitByUser',
        type: 'boolean',
        defaultValue: true,
      },
      {
        viewName: CUFDefs.t('showHidden'),
        realName: 'hidden',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableLoad'),
        realName: 'enableLoad',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableLoadButtonLabel'),
        realName: 'enableLoadButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('loadDT.button.name'),
      },
      {
        viewName: CUFDefs.t('loadDT.param.askBeforeAdd'),
        realName: 'askBeforeAdd',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.deleteWhenAdd'),
        realName: 'deleteWhenAdd',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableShow'),
        realName: 'enableShow',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableShowButtonLabel'),
        realName: 'enableShowButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('loadDT.param.enableShowButtonLabel.defaultValue'),
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableSetDefault'),
        realName: 'enableSetDefault',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableSetDefaultButtonLabel'),
        realName: 'enableSetDefaultButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('loadDT.param.enableSetDefaultButtonLabel.defaultValue'),
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableDelete'),
        realName: 'enableDelete',
        type: 'boolean',
        defaultValue: false,
      },
      {
        viewName: CUFDefs.t('loadDT.param.enableDeleteButtonLabel'),
        realName: 'enableDeleteButtonLabel',
        type: 'string',
        defaultValue: CUFDefs.t('loadDT.param.enableDeleteButtonLabel.defaultValue'),
      },
      {
        viewName: CUFDefs.t('loadDT.param.optionalTabTitle'),
        realName: 'optionalTabTitle',
        type: 'string',
        defaultValue: '',
      },
    ],
  },
  removeAll: {
    name: CUFDefs.t('removeAll.name'),
    descr: CUFDefs.t('removeAll.description'),
    buttonId: 'CUF_remove_all_button',
    text: CUFDefs.t('removeAll.button.name'),
    icon: 'style/img/fam/bin_empty.png',
    tooltip: CUFDefs.t('removeAll.button.tooltip'),
    handler: 'CUF_removeAllFromDT',
    params: [],
  },
};

CUFDefs.AcceptButtonFunctions = {
  checkComment: {
    handler: 'CUF_checkComment',
    descr: CUFDefs.t('checkComment.description'),
  },
  saveAllVariables: {
    handler: 'CUF_saveAllVariables',
    descr: CUFDefs.t('saveAllVariables.description'),
  },
};

//Pozostawione tylko dla wstecz kompatybilności
var CUF = {
  DTButtons: {
    pl: {
      importFromXls: {
        name: 'Import pliku Excel',
        descr: 'Import linii tabeli z pliku Excel',
        buttonId: 'CUF_import_from_xls_button',
        text: 'Importuj',
        icon: 'style/img/fam/page_excel.png',
        tooltip: 'Importuj linie z pliku',
        handler: 'CUF.table.service.TableButton.importFromExcel',
        params: [
          {
            viewName: 'Uwzględnij ukryte kolumny',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Zapisz dane po wczytaniu',
            realName: 'saveData',
            type: 'boolean',
            defaultValue: true,
          },
          {
            viewName: 'Przycisk wyboru pliku',
            realName: 'fileButtonLabel',
            type: 'string',
            defaultValue: 'Wybierz plik',
          },
          {
            viewName: 'Przycisk importowania',
            realName: 'loadButtonLabel',
            type: 'string',
            defaultValue: 'Importuj',
          },
          {
            viewName: 'Tytuł okna',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Import pliku Excel',
          },
          {
            viewName: 'Dodatkowa funkcja',
            realName: 'functionName',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      exportDTScheme: {
        name: 'Eksport schematu tabeli',
        descr: 'Eksport nagłówka tabeli',
        buttonId: 'CUF_export_dt_scheme_button',
        text: 'Pobierz schemat',
        icon: 'style/img/fam/page_excel.png',
        tooltip: 'Pobierz schemat tabeli',
        handler: 'CUF.table.service.TableButton.exportSchemaToExcel',
        params: [
          {
            viewName: 'Uwzględnij ukryte kolumny',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Nazwa pliku',
            realName: 'title',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      exportToXls: {
        name: 'Eksport do pliku Excel',
        descr: 'Eksport linii z tabeli do pliku Excel',
        buttonId: 'CUF_export_to_xls_button',
        text: 'Eksportuj',
        icon: 'style/img/fam/page_excel.png',
        tooltip: 'Eksportuj linie do pliku',
        handler: 'CUF.table.service.TableButton.exportToExcel',
        params: [
          {
            viewName: 'Uwzględnij ukryte kolumny',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Nazwa pliku',
            realName: 'title',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      saveDT: {
        name: 'Zapis tabeli',
        descr: 'Zapisuje całą zawartość tabeli',
        buttonId: 'CUF_save_dt_button',
        text: 'Zapisz',
        icon: 'style/img/fam/database_add.png',
        tooltip: 'Zapisz zawartość tabeli',
        handler: 'CUF_executeSaveDynamicTableContent',
        params: [
          {
            viewName: 'Tytuł okna',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Zapis zawartości tabeli dynamicznej',
          },
          {
            viewName: 'Zapis ukrytych',
            realName: 'saveHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Zapis jako domyślny',
            realName: 'enableSetAsDefault',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Wykluczone kolumny',
            realName: 'excludedColumns',
            type: 'string',
            defaultValue: '',
          },
          {
            viewName: 'Opcjonalna nazwa zapisu',
            realName: 'optionalTabTitle',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      loadDT: {
        name: 'Uzupełnij tabelę',
        descr: 'Uzupełnia zawartość tabeli za pomocą wcześniejszego zapisu',
        buttonId: 'CUF_load_dt_button',
        text: 'Załaduj',
        icon: 'style/img/fam/table_edit.png',
        tooltip: 'Załaduj zawartość tabeli',
        handler: 'CUF_executeDynamicTableContentManagement',
        params: [
          {
            viewName: 'Tytuł okna',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Zarządzanie zawartością tabeli dynamicznej',
          },
          {
            viewName: 'Limitowanie po użytkowniku',
            realName: 'limitByUser',
            type: 'boolean',
            defaultValue: true,
          },
          {
            viewName: 'Ładowanie ukrytych',
            realName: 'hidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Możliwość ładowania',
            realName: 'enableLoad',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Tekst przycisku ładowania',
            realName: 'enableLoadButtonLabel',
            type: 'string',
            defaultValue: 'Załaduj',
          },
          {
            viewName: 'Zapytaj przed ładowaniem',
            realName: 'askBeforeAdd',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Usuń przed ładowaniem',
            realName: 'deleteWhenAdd',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Możliwość podglądu',
            realName: 'enableShow',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Tekst przycisku podglądu',
            realName: 'enableShowButtonLabel',
            type: 'string',
            defaultValue: 'Podgląd',
          },
          {
            viewName: 'Zmień domyślny',
            realName: 'enableSetDefault',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Tekst przycisku zmiany domyślnego',
            realName: 'enableSetDefaultButtonLabel',
            type: 'string',
            defaultValue: 'Domyślny',
          },
          {
            viewName: 'Możliwość usuwania',
            realName: 'enableDelete',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Tekst przycisku usuwania',
            realName: 'enableDeleteButtonLabel',
            type: 'string',
            defaultValue: 'Usuń',
          },
          {
            viewName: 'Opcjonalna nazwa zapisu',
            realName: 'optionalTabTitle',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      removeAll: {
        name: 'Usuń wszystkie rekordy',
        descr: 'Usuwa wszystkie rekordy z tabeli',
        buttonId: 'CUF_remove_all_button',
        text: 'Usuń wszystkie',
        icon: 'style/img/fam/bin_empty.png',
        tooltip: 'Usuń wszystkie rekordy',
        handler: 'CUF_removeAllFromDT',
        params: [],
      },
    },
    en: {
      importFromXls: {
        name: 'Import from xls',
        descr: 'Import variable set lines from xls file',
        buttonId: 'CUF_import_from_xls_button',
        text: 'Import',
        icon: 'style/img/fam/tab_edit.png',
        tooltip: 'Importuj variable set lines from file',
        handler: 'CUF_importDynamicTableFromXls',
        params: [
          {
            viewName: 'Show hidden',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Choose file button',
            realName: 'fileButtonLabel',
            type: 'string',
            defaultValue: 'Choose file',
          },
          {
            viewName: 'Import button',
            realName: 'loadButtonLabel',
            type: 'string',
            defaultValue: 'Load',
          },
          {
            viewName: 'Window title',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Xls file loading',
          },
          {
            viewName: 'Additional function',
            realName: 'functionName',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      exportDTScheme: {
        name: 'Variable set schema export',
        descr: 'Variable set header export',
        buttonId: 'CUF_export_dt_scheme_button',
        text: 'Export schema',
        icon: 'style/img/fam/page_excel.png',
        tooltip: 'Export variable set schema',
        handler: 'CUF_executeExportDynamicTableSchame',
        params: [
          {
            viewName: 'Show hidden',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
        ],
      },
      exportToXls: {
        name: 'Export to xls',
        descr: 'Export variable set lines to xls file',
        buttonId: 'CUF_export_to_xls_button',
        text: 'Export',
        icon: 'style/img/fam/table_go.png',
        tooltip: 'Export variable set lines to file',
        handler: 'CUF_executeExportDynamicTableToXls',
        params: [
          {
            viewName: 'Show hidden',
            realName: 'showHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Ask for file name',
            realName: 'askForFileName',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'File name',
            realName: 'fileName',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      attachDocument: {
        name: 'Attach document',
        descr: 'Attach document to process and/or variable set',
        buttonId: 'CUF_attach_document_button',
        text: 'Attach',
        icon: 'style/img/fam/page_white_add.png',
        tooltip: 'Attach document',
        handler: 'CUF_attachDocument',
        params: [
          {
            viewName: 'Document class',
            realName: 'addDocDocClasses',
            type: 'docclass',
            defaultValue: '',
          },
          {
            viewName: 'Check protection',
            realName: 'addDocCheckProtection',
            type: 'boolean',
            defaultValue: true,
          },
          {
            viewName: 'Show indexes',
            realName: 'addDocShowIndexes',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Window title',
            realName: 'addDocWindowTitle',
            type: 'string',
            defaultValue: 'Document attachment',
          },
          {
            viewName: 'Button label',
            realName: 'addDocButtonLabel',
            type: 'string',
            defaultValue: 'Add',
          },
          {
            viewName: 'Additional function',
            realName: 'funcNameAfterDocAction',
            type: 'string',
            defaultValue: '',
          },
          {
            viewName: 'Add to process',
            realName: 'attachToProcess',
            type: 'boolean',
            defaultValue: true,
          },
          {
            viewName: 'Add to variable set',
            realName: 'attachToDT',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Variable set no',
            realName: 'gridNumber',
            type: 'int',
            defaultValue: 1,
          },
        ],
      },
      saveDT: {
        name: 'Save variable set',
        descr: 'Save variable set content',
        buttonId: 'CUF_save_dt_button',
        text: 'Save',
        icon: 'style/img/fam/database_add.png',
        tooltip: 'Save variable set content',
        handler: 'CUF_executeSaveDynamicTableContent',
        params: [
          {
            viewName: 'Window title',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Save variable set content',
          },
          {
            viewName: 'Save hidden',
            realName: 'saveHidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Enable save as default',
            realName: 'enableSetAsDefault',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Excluded columns',
            realName: 'excludedColumns',
            type: 'string',
            defaultValue: '',
          },
          {
            viewName: 'Optional save name',
            realName: 'optionalTabTitle',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      loadDT: {
        name: 'Load variable set',
        descr: 'Load variable set content using saved data',
        buttonId: 'CUF_load_dt_button',
        text: 'Load',
        icon: 'style/img/fam/table_edit.png',
        tooltip: 'Load variable set content',
        handler: 'CUF_executeDynamicTableContentManagement',
        params: [
          {
            viewName: 'Window title',
            realName: 'windowTitle',
            type: 'string',
            defaultValue: 'Variable set content management',
          },
          {
            viewName: 'Limit by user',
            realName: 'limitByUser',
            type: 'boolean',
            defaultValue: true,
          },
          {
            viewName: 'Load hidden',
            realName: 'hidden',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Enable load',
            realName: 'enableLoad',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Load button label',
            realName: 'enableLoadButtonLabel',
            type: 'string',
            defaultValue: 'Load',
          },
          {
            viewName: 'Ask before load',
            realName: 'askBeforeAdd',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Remove before load',
            realName: 'deleteWhenAdd',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Enable preview',
            realName: 'enableShow',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Preview button label',
            realName: 'enableShowButtonLabel',
            type: 'string',
            defaultValue: 'Preview',
          },
          {
            viewName: 'Change default',
            realName: 'enableSetDefault',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Change default button label',
            realName: 'enableSetDefaultButtonLabel',
            type: 'string',
            defaultValue: 'Default',
          },
          {
            viewName: 'Enable delete',
            realName: 'enableDelete',
            type: 'boolean',
            defaultValue: false,
          },
          {
            viewName: 'Delete button label',
            realName: 'enableDeleteButtonLabel',
            type: 'string',
            defaultValue: 'Delete',
          },
          {
            viewName: 'Optional save name',
            realName: 'optionalTabTitle',
            type: 'string',
            defaultValue: '',
          },
        ],
      },
      removeAll: {
        name: 'Remove all records',
        descr: 'Remove all records from variable set',
        buttonId: 'CUF_remove_all_button',
        text: 'Remove all',
        icon: 'style/img/fam/bin_empty.png',
        tooltip: 'Remove all records',
        handler: 'CUF_removeAllFromDT',
        params: [],
      },
    },
  },
  AcceptButtonFunctions: {
    pl: {
      checkComment: {
        handler: 'CUF_checkComment',
        descr: 'Sprawdza, czy w obecnym zadaniu został dodany komentarz',
      },
      saveAllVariables: {
        handler: 'CUF_saveAllVariables',
        descr: 'Zapisuje formularz',
      },
    },
    en: {
      checkComment: {
        handler: 'CUF_checkComment',
        descr: 'Checks, if comment has been added to current activity',
      },
      saveAllVariables: {
        handler: 'CUF_saveAllVariables',
        descr: 'Saves form',
      },
    },
  },
};
