/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.dataFileSync;

import com.plusmpm.CUF.database.dataFileSync.ListConf;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import com.plusmpm.database.hibernate.DirectQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.AbstractStandardBasicType;

public class ListConfManager {
    public static void save(ListConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.save((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void update(ListConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void delete(ListConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void deleteAll() throws HibernateException, Exception {
        List<ListConf> AllConfList = ListConfManager.getAll();
        try {
            for (ListConf oneConf : AllConfList) {
                ListConfManager.delete(oneConf);
            }
        }
        catch (HibernateException he) {
            throw he;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static List<ListConf> getAll() throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createCriteria(ListConf.class).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static ListConf getListConfByName(String sName) throws HibernateException, Exception {
        ListConf result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = (ListConf)session.createQuery("from ListConf where listName=:name").setParameter("name", (Object)sName).uniqueResult();
            transaction.commit();
            ListConf listConf = result;
            return listConf;
        }
        catch (HibernateException e) {
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<Map<String, String>> getAllByCriteria(String sQuery, LinkedHashMap<String, AbstractStandardBasicType> hmQueryIds) throws Exception {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        DirectQuery dc = new DirectQuery();
        HashMap hmWhereCondition = new HashMap();
        List list = null;
        list = dc.createHibrenateQuery(sQuery, 0, 0, hmQueryIds, hmWhereCondition);
        if (list != null) {
            Set<String> sKey = hmQueryIds.keySet();
            for (Object[] singleRow : list) {
                HashMap<String, String> singleRowMap = new HashMap<String, String>();
                int i = 0;
                for (String singleKey : sKey) {
                    singleRowMap.put(singleKey, singleRow[i].toString());
                    ++i;
                }
                results.add(singleRowMap);
            }
        }
        return results;
    }
}

