/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.mail;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.HolidaysFunctions;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.administration.email.EmailInfo;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.system.SystemPropertiesHelper;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityAssignment;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.variable.format.ValueFormatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

@ScheduledTask
@ScheduledTaskScript(value="scripts/mail/send-new-task-email-form.js")
public class SendEmailTask {
    private static final Logger log = LoggerFactory.getLogger(SendEmailTask.class);
    private static final String DEADLINETIME = "deadlinetime";
    private static final String PROCESSDEFID = "processdefid";
    private static final String RESOURCEID = "resourceid";
    private static final String PROCESSID = "processid";
    private static final String ACTIVITYSTARTTIME = "activitystarttime";
    private static final String ACTIVITYID = "activityid";
    private static final String PROCESSSTARTTIME = "processstarttime";
    private static final String PROCESSNAME_PREFIX = "processname_";
    private static final String ACTIVITYNAME_PREFIX = "activityname_";
    private static final String ACTIVITYNAME = "activityname";
    private static final String PROCESSNAME = "processname";
    private static final int NOT_FOUND_INDEX = -1;
    private final UserSettingsService userSettingsService = (UserSettingsService)SpringContext.getBean(UserSettingsService.class);
    private final EmailService emailService = (EmailService)SpringContext.getBean(EmailService.class);
    private final EmailConfigurationService emailConfigurationService = (EmailConfigurationService)SpringContext.getBean(EmailConfigurationService.class);
    private final SystemPropertiesHelper systemPropertiesHelper = (SystemPropertiesHelper)SpringContext.getBean(SystemPropertiesHelper.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("send-new-task-email-task")).name("sendNewTaskEmail")).description("sendNewTaskEmail_desc")).parameter().id("process_def_id").name("advancedTask.paramName.processDefId").description("advancedTask.paramDesc.processDefIdCES").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("task_names").name("advancedTask.paramName.taskName").description("advancedTask.paramDesc.taskNameCES").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create()).parameter().id("is_superior").name("advancedTask.paramName.isSuperiorCES").description("advancedTask.paramDesc.isSuperiorCES").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).create()).parameter().id("only_own_task").name("advancedTask.paramName.onlyOwnTaskCES").description("advancedTask.paramDesc.onlyOwnTaskCES").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).create()).parameter().id("group_sending").name("advancedTask.paramName.groupSendingCES").description("advancedTask.paramDesc.groupSendingCES").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).create()).parameter().id("subject").name("advancedTask.paramName.subject").description("advancedTask.paramDesc.subject").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("email_template").name("advancedTask.paramName.emailTemplateCES").description("advancedTask.paramDesc.emailTemplateCES").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("skip_sending_email_on_holiday").name("advancedTask.paramName.skipSendingEmailOnHoliday").description("advancedTask.paramDesc.skipSendingEmailOnHoliday").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).create();
    }

    public void execute(@Param(value="process_def_id") String processDefId, @Param(value="task_names") String[] taskDefNames, @Param(value="is_superior") boolean isSuperior, @Param(value="only_own_task") boolean onlyOwnTask, @Param(value="group_sending") boolean isGroupSending, @Param(value="subject") String subject, @Param(value="email_template") String emailTemplatePath, @Param(value="skip_sending_email_on_holiday") boolean skipSendingEmailOnHoliday) {
        log.info("sendNewTaskEmail(processDefId={}, taskDefNames={}, isSuperior={}, onlyOwnTask={}, isGroupSending={}, subject={}, emailTemplatePath={}, skipSendingEmailOnHoliday={})", new Object[]{processDefId, Arrays.toString(taskDefNames), isSuperior, onlyOwnTask, isGroupSending, subject, emailTemplatePath, skipSendingEmailOnHoliday});
        long startTime = new Date().getTime();
        if (skipSendingEmailOnHoliday && HolidaysFunctions.checkHoliday(Calendar.getInstance(), null) != -1) {
            log.info("Dzis jest swieto, zgodnie z ustawionym parametrem powiadomienia o nowym zadaniu nie beda wysylane");
            return;
        }
        if (taskDefNames == null || taskDefNames.length == 0 || Arrays.asList(taskDefNames).contains("*")) {
            taskDefNames = new String[]{"*"};
        }
        LinkedHashMap<String, List> recipientsNotifications = new LinkedHashMap<String, List>();
        for (String taskDefName : taskDefNames) {
            Map<String, List<Map<String, String>>> recipientsToMailInfo = this.getAllRecipientsForEmailSending(isSuperior, onlyOwnTask, this.getProcessAndTaskInfo(processDefId, taskDefName));
            for (Map.Entry<String, List<Map<String, String>>> entry : recipientsToMailInfo.entrySet()) {
                recipientsNotifications.computeIfAbsent(entry.getKey(), key -> new LinkedList()).addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry entry : recipientsNotifications.entrySet()) {
            String recipient = (String)entry.getKey();
            List recipientNotification = (List)entry.getValue();
            String userEmail = (String)Sneaky.throwing(() -> Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(recipient));
            if (StringUtils.isBlank((CharSequence)userEmail)) {
                log.warn("Nie mozna wysla\u0107 maila do uzytkownika <{}> gdy\u017c nie ma on ustawionego adresu email", (Object)recipient);
                continue;
            }
            String emailToSend = isGroupSending ? this.prepareGroupEmailToSend(recipientNotification, emailTemplatePath, recipient) : this.prepareIndividualEmailToSend(recipientNotification, emailTemplatePath, recipient);
            this.sendEmail(userEmail, subject, emailToSend);
        }
        log.info("Czas wykonywania zadania zaplanowanego sendNewTaskEmail: {}", (Object)CUFTools.plannedTaskDuration(new Date().getTime() - startTime));
    }

    private Map<String, List<Map<String, String>>> getAllRecipientsForEmailSending(boolean isSuperior, boolean onlyOwnTask, List<Map<String, String>> taskResults) {
        HashMap<String, List<Map<String, String>>> recipientsNotification = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> mapResult : taskResults) {
            String performer = mapResult.get(RESOURCEID);
            if (onlyOwnTask && !isSuperior) {
                List recipientNotification = Optional.ofNullable((List)recipientsNotification.get(performer)).orElseGet(LinkedList::new);
                recipientNotification.add(mapResult);
                recipientsNotification.put(performer, recipientNotification);
                continue;
            }
            if (!isSuperior) continue;
            List superiors = ((PositionFinder)SpringContext.getBean(PositionFinder.class)).getUserSuperiors(performer);
            for (String superior : superiors) {
                List recipientNotification = Optional.ofNullable((List)recipientsNotification.get(superior)).orElseGet(LinkedList::new);
                recipientNotification.add(mapResult);
                recipientsNotification.put(superior, recipientNotification);
            }
        }
        return recipientsNotification;
    }

    private List<Map<String, String>> getProcessAndTaskInfo(String processDefId, String taskDefName) {
        LinkedList<Map<String, String>> results = new LinkedList<Map<String, String>>();
        List supportedLocales = this.systemPropertiesHelper.getSupportedLanguagesParameter();
        StringBuilder sQuery = new StringBuilder("SELECT ");
        for (String locale : supportedLocales) {
            sQuery.append("(SELECT pt.name FROM pm_process_translation pt WHERE pt.processId = processes.id AND pt.language = '").append(locale).append("' ) processname_").append(locale).append(", ");
            sQuery.append("(SELECT at.name FROM pm_activity_translation at WHERE at.packageid = processdefinitions.packageid and at.processdefid = processdefinitions.processdefinitionid and at.activitydefid = activities.activitydefinitionid and at.language = '").append(locale).append("' ) activityname_").append(locale).append(", ");
        }
        sQuery.append("processes.started processstarttime, assignmentstable.activityid activityid,assignmentstable.activityprocessid processid, activities.activated activitystarttime, assignmentstable.resourceid resourceid, processdefinitions.processdefinitionid processdefid, d.min_deadlinetime deadlinetime  FROM assignmentstable JOIN  activities ON assignmentstable.activityid = activities.id JOIN  processes ON assignmentstable.activityprocessid = processes.id LEFT JOIN ( SELECT activity, MIN(timelimit) AS min_deadlinetime FROM deadlines GROUP BY activity) d ON assignmentstable.activity = d.activity JOIN  processdefinitions ON assignmentstable.activityprocessdefname = processdefinitions.name ");
        LinkedHashMap<String, Type> hmQueryIds = new LinkedHashMap<String, Type>();
        HashMap<String, String> hmWhereCondition = new HashMap<String, String>();
        for (String locale : supportedLocales) {
            hmQueryIds.put(PROCESSNAME_PREFIX + locale, (Type)StandardBasicTypes.STRING);
            hmQueryIds.put(ACTIVITYNAME_PREFIX + locale, (Type)StandardBasicTypes.STRING);
        }
        hmQueryIds.put(PROCESSSTARTTIME, (Type)StandardBasicTypes.LONG);
        hmQueryIds.put(ACTIVITYID, (Type)StandardBasicTypes.STRING);
        hmQueryIds.put(ACTIVITYSTARTTIME, (Type)StandardBasicTypes.LONG);
        hmQueryIds.put(PROCESSID, (Type)StandardBasicTypes.STRING);
        hmQueryIds.put(RESOURCEID, (Type)StandardBasicTypes.STRING);
        hmQueryIds.put(PROCESSDEFID, (Type)StandardBasicTypes.STRING);
        hmQueryIds.put(DEADLINETIME, (Type)StandardBasicTypes.STRING);
        StringBuilder sbQuery = new StringBuilder(sQuery.toString());
        sbQuery.append("WHERE activities.state < 1000006 ");
        if (StringUtils.isNotBlank((CharSequence)processDefId) && processDefId.compareTo("*") != 0) {
            sbQuery.append("AND processdefinitions.processdefinitionid=(:processDefId) ");
            hmWhereCondition.put("processDefId", processDefId);
        }
        if (StringUtils.isNotBlank((CharSequence)taskDefName)) {
            sbQuery.append("AND ");
            if (taskDefName.contains("*")) {
                sbQuery.append("activities.name LIKE(:activityname)");
                taskDefName = taskDefName.replace("*", "%");
            } else {
                sbQuery.append("activities.name=(:activityname)");
            }
            hmWhereCondition.put(ACTIVITYNAME, taskDefName);
        }
        sQuery = new StringBuilder(sbQuery.toString());
        List<Object[]> result = this.createHibernateQuery(sQuery.toString(), hmQueryIds, hmWhereCondition);
        Set queryIds = hmQueryIds.keySet();
        for (Object[] row : result) {
            int i = 0;
            HashMap<String, String> hmRow = new HashMap<String, String>();
            for (String sQueryIdsKeyIterator : queryIds) {
                Object column = row[i];
                ++i;
                if (column instanceof Long) {
                    Long longColumn = (Long)column;
                    hmRow.put(sQueryIdsKeyIterator, longColumn.toString());
                    continue;
                }
                hmRow.put(sQueryIdsKeyIterator, (String)column);
            }
            results.add(hmRow);
        }
        return results;
    }

    private String prepareGroupEmailToSend(List<Map<String, String>> recipientNotification, String emailTemplate, String username) {
        try {
            Locale userLocale = Optional.ofNullable(this.userSettingsService.getUserLocale(username)).orElse(LocaleContextHolder.getLocale());
            String emailContent = this.getEmailContentFromFile(emailTemplate, userLocale.getLanguage());
            String rowsPrefix = "@@rows@@";
            String endRowsPrefix = "@@end_rows@@";
            int groupTemplateStartPosition = emailContent.indexOf(rowsPrefix);
            int groupTemplateEndPosition = emailContent.indexOf(endRowsPrefix);
            if (groupTemplateStartPosition == -1 || groupTemplateEndPosition == -1) {
                throw new IllegalArgumentException("@@rows@@ or @@end_rows@@ not found inside email template");
            }
            String row = emailContent.substring(groupTemplateStartPosition + rowsPrefix.length(), groupTemplateEndPosition);
            StringBuilder newRow = new StringBuilder();
            for (Map<String, String> mapTaskParams : recipientNotification) {
                newRow.append(this.prepareEmailContent(row, mapTaskParams, userLocale));
            }
            String startPart = this.prepareEmailContent(emailContent.substring(0, groupTemplateStartPosition), null, userLocale);
            String endPart = this.prepareEmailContent(emailContent.substring(groupTemplateEndPosition + endRowsPrefix.length()), null, userLocale);
            return startPart + String.valueOf(newRow) + endPart;
        }
        catch (IOException | BaseException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private String prepareIndividualEmailToSend(List<Map<String, String>> recipientNotification, String emailTemplate, String username) {
        try {
            Locale userLocale = Optional.ofNullable(this.userSettingsService.getUserLocale(username)).orElse(LocaleContextHolder.getLocale());
            String emailContent = this.getEmailContentFromFile(emailTemplate, userLocale.getLanguage());
            String finalContent = null;
            for (Map<String, String> mapTaskParams : recipientNotification) {
                finalContent = this.prepareEmailContent(emailContent, mapTaskParams, userLocale);
            }
            return finalContent;
        }
        catch (IOException | BaseException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private String prepareEmailContent(String row, Map<String, String> mapTaskParams, Locale userLocale) throws BaseException {
        if (mapTaskParams == null) {
            return row;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm");
        Date dateActivity = new Date(Long.parseLong(mapTaskParams.get(PROCESSSTARTTIME)));
        String activityDate = simpleDateFormat.format(dateActivity);
        String activityTime = simpleTimeFormat.format(dateActivity);
        Date dateProcess = new Date(Long.parseLong(mapTaskParams.get(PROCESSSTARTTIME)));
        String processDate = simpleDateFormat.format(dateProcess);
        String processTime = simpleTimeFormat.format(dateProcess);
        String processId = mapTaskParams.get(PROCESSID);
        String activityId = mapTaskParams.get(ACTIVITYID);
        String taskUsers = this.getAssignedUsers(processId, activityId);
        String httpSystemLink = ((SystemPropertiesHelper)SpringContext.getBean(SystemPropertiesHelper.class)).prepareHttpLinkParameter();
        String link = httpSystemLink + "/ProcesActivity.do?processKey=" + processId + "&activityId=" + activityId;
        link = "<A Href=" + link + ">" + MessageHelper.getMessage((String)"Przejdz_do_zadania", (Locale)userLocale, (Object[])new Object[0]) + "</A>";
        String historyLink = httpSystemLink + "/ShowDetailHistory.do?ProcessId=" + processId + "&histActivityId=" + activityId;
        historyLink = "<A Href=" + historyLink + ">" + MessageHelper.getMessage((String)"Zobacz_zadanie", (Locale)userLocale, (Object[])new Object[0]) + "</A>";
        String deadline = Optional.ofNullable(mapTaskParams.get(DEADLINETIME)).map(Long::valueOf).map(this::getDeadline).orElse("");
        row = this.replace(row, "(@taskUsers@)", taskUsers);
        row = this.replace(row, "(@processtype@)", mapTaskParams.get(PROCESSDEFID));
        row = this.replace(row, "(@processname@)", this.getLocalizedProperty(mapTaskParams, PROCESSNAME, userLocale));
        row = this.replace(row, "(@activitystarttime@)", activityTime);
        row = this.replace(row, "(@activitystartday@)", activityDate);
        row = this.replace(row, "(@processstartday@)", processDate);
        row = this.replace(row, "(@processstarttime@)", processTime);
        row = this.replace(row, "(@activityid@)", mapTaskParams.get(ACTIVITYID));
        row = this.replace(row, "(@activityname@)", this.getLocalizedProperty(mapTaskParams, ACTIVITYNAME, userLocale));
        row = this.replace(row, "(@deadlinetime@)", deadline);
        row = this.replace(row, "(@deadlineTime@)", deadline);
        row = this.replace(row, "(@link@)", link);
        row = this.replace(row, "(@historylink@)", historyLink);
        Map processContext = SharkFunctions.GetProcessContext((WfProcess)SharkFunctions.getWfProcess((String)mapTaskParams.get(PROCESSID)));
        Iterator indicesIterator = processContext.keySet().iterator();
        WorkflowProcess workflowProcess = SharkFunctions.getWorkflowProcessById((String)mapTaskParams.get(PROCESSID));
        while (indicesIterator.hasNext()) {
            String variableName = (String)indicesIterator.next();
            Object objValue = processContext.get(variableName);
            if (objValue != null) {
                String value = ValueFormatter.getFormattedValue(objValue, (DataField)workflowProcess.getDataField(variableName));
                row = row.replaceAll("(@" + variableName + "@)", value);
                if (!Shark.getInstance().getAdminInterface().getUserGroupAdministration().doesUserExist(value)) continue;
                String realName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(value);
                row = row.replaceAll("(@realusername_" + variableName + "@)", realName);
                continue;
            }
            row = row.replaceAll("(@" + variableName + "@)", "");
        }
        return row;
    }

    private String replace(String row, String toReplace, String replacement) {
        return replacement == null ? row : row.replaceAll(toReplace, replacement);
    }

    private String getLocalizedProperty(Map<String, String> map, String property, Locale locale) {
        return map.get(property + "_" + locale.getLanguage());
    }

    private String getAssignedUsers(String processId, String activityId) {
        String taskUsers = "";
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return taskUsers;
        }
        UserService userService = ServiceFactory.getUserService();
        ActivityService activityService = ServiceFactory.getActivityService();
        LinkedList<User> users = new LinkedList<User>();
        ActivityEntity activity = (ActivityEntity)activityService.getActivity(processId, activityId, new String[]{"assignments"});
        String userName = activity.getResourceId();
        if (StringUtils.isEmpty((CharSequence)userName)) {
            Set assignments = Optional.ofNullable(activity.getAssignments()).orElseGet(HashSet::new);
            for (ActivityAssignment assignment : assignments) {
                users.add(userService.getUser(assignment.getUserName(), new String[0]));
            }
        } else {
            users.add(userService.getUser(userName, new String[0]));
        }
        for (User user : users) {
            if (StringUtils.isBlank((CharSequence)taskUsers)) {
                taskUsers = StringUtils.join((Object[])new String[]{taskUsers, user.getFullName()});
                continue;
            }
            taskUsers = StringUtils.join((Object[])new String[]{taskUsers, ", ", user.getFullName()});
        }
        return taskUsers;
    }

    /*
     * Exception decompiling
     */
    private String getEmailContentFromFile(String emailTemplate, String language) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendEmail(final String recipient, final String emailSubject, final String emailContent) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    double dRand = Math.random() * 10000.0;
                    EmailConfiguration emailConfiguration = SendEmailTask.this.emailConfigurationService.getDefaultConfiguration();
                    log.info("Wysylanie maila z adresu {} do uzytkownika: {}", (Object)emailConfiguration.getMailUser(), (Object)recipient);
                    Thread.sleep((long)dRand);
                    EmailMessage emailMessage = EmailMessage.builder().recipient(recipient).subject(emailSubject).content(emailContent).isHtml(true).emailInfo(EmailInfo.builder().scheduledTaskName("sendNewTaskEmail").build()).build();
                    SendEmailTask.this.emailService.send(emailMessage, emailConfiguration);
                    log.info("Wyslanie maila z adresu {} do uzytkownika: {} powiodlo sie", (Object)emailConfiguration.getMailUser(), (Object)recipient);
                }
                catch (Exception e) {
                    log.error("Exception in SendEmailTask: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }, 5000L);
    }

    private List<Object[]> createHibernateQuery(String query, Map<String, Type> queryIds, Map<String, String> whereCondition) {
        Session session = HibernateUtil.getSession();
        Transaction transaction = session.beginTransaction();
        NativeQuery sqlQuery = session.createNativeQuery(query);
        Set<String> setWhereCondition = whereCondition.keySet();
        for (String string : setWhereCondition) {
            String value = whereCondition.get(string);
            sqlQuery.setParameter(string, (Object)value);
        }
        Set<String> setQueryIds = queryIds.keySet();
        for (String sQueryIdsKey : setQueryIds) {
            sqlQuery.addScalar(sQueryIdsKey, queryIds.get(sQueryIdsKey));
        }
        List list = sqlQuery.list();
        transaction.commit();
        return list;
    }

    private String getDeadline(long deadlineTime) {
        long currentTime = System.currentTimeMillis();
        long delay = currentTime - deadlineTime;
        if (delay <= 0L) {
            return "";
        }
        float delayInDays = (float)delay / 1000.0f / 3600.0f / 24.0f;
        return String.format("%.2f", Float.valueOf(delayInDays));
    }
}

