/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.documentViews.DocumentViewsMethods;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.Tools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.json.JSONObject;

public class VerifyDocumentView
extends HttpServlet {
    public static Logger log = Logger.getLogger(VerifyDocumentView.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* VerifyDocumentView Servlet ****************************");
        PrintWriter printWriter = null;
        JSONObject jsObj = null;
        boolean bSuccess = false;
        Object addFiles = "";
        Object removeFiles = "";
        String procDefId = "";
        String actDefId = "";
        AdminMisc adminMisc = null;
        try {
            String userId = request.getParameter("userId");
            String processId = request.getParameter("processId");
            String activityId = request.getParameter("activityId");
            String oldDocIds = request.getParameter("oldDocIds");
            ArrayList<String> oldDocIdsList = new ArrayList<String>();
            String newDocIds = request.getParameter("newDocIds");
            List<Object> newDocIdsList = new ArrayList<String>();
            int iDocsInView = 0;
            if (Tools.isNullOrEmpty((String)userId)) {
                throw new CUFException("Brak loginu u\u017cytkownika.");
            }
            if (!Tools.isNullOrEmpty((String)oldDocIds)) {
                oldDocIdsList.addAll(Arrays.asList(oldDocIds.split(",")));
                iDocsInView = oldDocIdsList.size();
            }
            newDocIdsList.addAll(Arrays.asList(newDocIds.split(",")));
            adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
            procDefId = adminMisc.getProcessDefinitionId(processId);
            actDefId = adminMisc.getActivityDefinitionId(processId, activityId);
            List viewsForUser = DocumentViewsMethods.getDocumentViewForCurrentTask((String)procDefId, (String)actDefId, (String)userId);
            try {
                if (viewsForUser == null || viewsForUser.size() == 0) {
                    throw new CUFException("Brak widokow dokumentow dla uzytkownika o loginie " + userId);
                }
                DocumentViewsTable view = (DocumentViewsTable)viewsForUser.get(0);
                Integer iAmount = view.getAmount();
                Boolean bDescending = view.getIs_descending();
                Long lDocClassId = view.getDoc_class_id();
                String regex = view.getRegex();
                boolean bControlAmount = false;
                boolean bShowNewest = false;
                boolean bControlDocClass = false;
                if (iAmount != null) {
                    bControlAmount = true;
                }
                if (bDescending != null) {
                    bShowNewest = bDescending;
                }
                if (lDocClassId != null) {
                    bControlDocClass = true;
                }
                if (bControlDocClass) {
                    newDocIdsList = VerifyDocumentView.verifyDocClassAndRegex(newDocIds, lDocClassId, regex);
                }
                if (bControlAmount) {
                    if (iDocsInView >= iAmount) {
                        if (!bShowNewest) throw new CUFException("U\u017cytkownik o loginie " + userId + " osiagnal juz limit ilosci wyswietlanych plikow w widoku dokumentow");
                        while (newDocIdsList.size() > 0 && newDocIdsList.size() > iAmount) {
                            newDocIdsList.remove(0);
                        }
                        while (oldDocIdsList.size() > 0 && oldDocIdsList.size() + newDocIdsList.size() > iAmount) {
                            fileIdToRemove = (String)oldDocIdsList.remove(0);
                            removeFiles = (String)removeFiles + fileIdToRemove + ",";
                        }
                    } else if (bShowNewest) {
                        while (newDocIdsList.size() > 0 && newDocIdsList.size() > iAmount) {
                            newDocIdsList.remove(0);
                        }
                        while (oldDocIdsList.size() > 0 && oldDocIdsList.size() + newDocIdsList.size() > iAmount) {
                            fileIdToRemove = (String)oldDocIdsList.remove(0);
                            removeFiles = (String)removeFiles + fileIdToRemove + ",";
                        }
                    } else {
                        oldDocIdsList.clear();
                        while (newDocIdsList.size() > 0 && newDocIdsList.size() > iAmount - iDocsInView) {
                            newDocIdsList.remove(newDocIdsList.size() - 1);
                        }
                    }
                } else {
                    oldDocIdsList.clear();
                }
                for (String string : newDocIdsList) {
                    addFiles = (String)addFiles + string + ",";
                }
                if (((String)addFiles).endsWith(",")) {
                    addFiles = ((String)addFiles).substring(0, ((String)addFiles).length() - 1);
                }
                if (((String)removeFiles).endsWith(",")) {
                    removeFiles = ((String)removeFiles).substring(0, ((String)removeFiles).length() - 1);
                }
            }
            catch (CUFException e) {
                log.warn((Object)e.getMessage());
            }
            bSuccess = true;
            return;
        }
        catch (CUFException e) {
            bSuccess = false;
            addFiles = e.getMessage();
            log.warn(addFiles);
            return;
        }
        catch (Exception e) {
            bSuccess = false;
            addFiles = "B\u0142\u0105d podczas weryfikacji widk\u00f3w dokument\u00f3w dla u\u017cytkownika.";
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            try {
                jsObj = new JSONObject();
                jsObj.put("success", bSuccess);
                jsObj.put("addFiles", addFiles);
                jsObj.put("removeFiles", removeFiles);
                response.setContentType("text/html;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.println(jsObj.toString());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static List<String> verifyDocClassAndRegex(String newDocIds, Long lDocClassId, String regex) throws Exception {
        ArrayList<String> filesList = new ArrayList<String>();
        String[] newDocIdsTab = newDocIds.split(",");
        DBManagement dbm = new DBManagement();
        Files file = null;
        FilesManager filesManager = new FilesManager();
        DocClassTable docClassTable = DBManagement.getDocClass((String)lDocClassId.toString());
        String docClassName = docClassTable.getDocClassName();
        Pattern pattern = null;
        boolean bCheckFileName = false;
        if (!Tools.isNullOrEmpty((String)regex)) {
            bCheckFileName = true;
        }
        if (bCheckFileName) {
            pattern = Pattern.compile(regex);
        }
        for (String fileId : newDocIdsTab) {
            String thisDocClassName = ArchiveServices.GetDocClassNameForDocument(fileId);
            if (docClassName.compareTo(thisDocClassName) != 0) continue;
            if (bCheckFileName) {
                Matcher matcher;
                file = filesManager.GetFile(Long.valueOf(fileId));
                String fileName = file.getName();
                if (Tools.isNullOrEmpty((String)fileName) || !(matcher = pattern.matcher(fileName)).matches()) continue;
                filesList.add(fileId);
                continue;
            }
            filesList.add(fileId);
        }
        return filesList;
    }
}

