/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.view;

import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.view.ViewService;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.SharkFunctions;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.view.ViewAccessLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ViewServiceImpl
implements ViewService {
    private static DBManagement dbm = new DBManagement();

    @Override
    public void addView(String name, String description, Boolean groupAcceptation, Boolean acceptFromAllPages, Boolean showResults, Boolean showFilterForm, String userName, List<AdvanceSearchVariableTable> variables) {
        UserSearchViewTable userSearchView = new UserSearchViewTable(name, description, ViewAccessLevel.PRIVATE, "advanceSearch", userName, "");
        userSearchView.setShowFormOnResult(showFilterForm.toString());
        userSearchView.setAcceptManyTasks(groupAcceptation.toString());
        userSearchView.setAcceptFromAllPages(acceptFromAllPages.toString());
        userSearchView.setShowSearchResultOnResult(showResults.toString());
        Long id = dbm.addUserSearchView(userSearchView);
        for (AdvanceSearchVariableTable av : variables) {
            av.setViewid(id.toString());
            dbm.addAdvanceSearchVariable(av);
        }
    }

    @Override
    public void addView(String name, String description, Boolean groupAcceptation, Boolean showResults, Boolean showFilterForm, String userName, List<AdvanceSearchVariableTable> variables) {
        UserSearchViewTable userSearchView = new UserSearchViewTable(name, description, ViewAccessLevel.PRIVATE, "advanceSearch", userName, "");
        userSearchView.setShowFormOnResult(showFilterForm.toString());
        userSearchView.setAcceptManyTasks(groupAcceptation.toString());
        userSearchView.setShowSearchResultOnResult(showResults.toString());
        Long id = dbm.addUserSearchView(userSearchView);
        for (AdvanceSearchVariableTable av : variables) {
            av.setViewid(id.toString());
            dbm.addAdvanceSearchVariable(av);
        }
    }

    @Override
    public void importFromExcel(String path) throws Exception {
        ExcelReader er = new ExcelReader();
        List<Map<String, Object>> data = er.readExcel(path);
        HashSet<String> processed = new HashSet<String>();
        int rowNum = 1;
        for (Map<String, Object> row : data) {
            this.validate(row, rowNum);
            String viewName = (String)row.get("Nazwa widoku");
            if (!processed.contains(viewName)) {
                String userName = (String)row.get("Nazwa u\u017cytkownika");
                String viewDesc = (String)row.get("Opis widoku");
                Boolean groupAcceptation = this.readBoolean(row.get("Grupowa akceptacja"));
                Boolean acceptFromAllPages = this.readBoolean(row.get("Akceptuj zadania ze wszystkich stron"));
                Boolean showResults = this.readBoolean(row.get("Poka\u017c wyniki wyszukiwania"));
                Boolean showFilterForm = this.readBoolean(row.get("Otw\u00f3rz filtr wynik\u00f3w"));
                List<AdvanceSearchVariableTable> variables = this.readViewVariables(viewName, groupAcceptation, row, data);
                this.addView(viewName, viewDesc, groupAcceptation, acceptFromAllPages, showResults, showFilterForm, userName, variables);
                processed.add(viewName);
            }
            ++rowNum;
        }
    }

    private List<AdvanceSearchVariableTable> readViewVariables(String viewName, Boolean groupAcceptation, Map<String, Object> row, List<Map<String, Object>> data) {
        Map<String, String> variablesNameIdMap = this.getStandardVariablesMap();
        ArrayList<AdvanceSearchVariableTable> variables = new ArrayList<AdvanceSearchVariableTable>();
        String processName = (String)row.get("Nazwa procesu");
        if (StringUtils.isNotBlank((String)processName)) {
            variablesNameIdMap.putAll(this.getVarIdName(processName));
            String processDefId = this.getProcessDefIdByName(processName);
            variables.add(this.getProcDefIdVar(processDefId));
        }
        variables.addAll(this.readProcessVariables(viewName, variablesNameIdMap, data));
        this.validateVars(variables, groupAcceptation, row);
        return variables;
    }

    private void validateVars(List<AdvanceSearchVariableTable> variables, Boolean groupAcceptation, Map<String, Object> row) {
        boolean onlyLoggedUserTask = false;
        boolean onlyActiveTask = false;
        boolean taskNameDefined = false;
        if (groupAcceptation.booleanValue()) {
            for (AdvanceSearchVariableTable av : variables) {
                if (av.getName().equals("onlyLoggedUserTask")) {
                    onlyLoggedUserTask = true;
                }
                if (av.getName().equals("onlyActiveTask")) {
                    onlyActiveTask = true;
                }
                if (!av.getName().equals("taskName") || !StringUtils.isNotBlank((String)av.getValue())) continue;
                taskNameDefined = true;
            }
            if (!(onlyLoggedUserTask && onlyActiveTask && taskNameDefined)) {
                throw new IllegalArgumentException("Przy grupowej akceptacji nale\u017cy poda\u0107 Nazw\u0119 zadania i zaznaczyc tylko zadania do wykonania i tylko moje zadania");
            }
        }
    }

    private boolean readBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String s = object.toString();
        return s.equalsIgnoreCase("tak");
    }

    private void validate(Map<String, Object> row, int rowNum) {
        String viewName = (String)row.get("Nazwa widoku");
        String userName = (String)row.get("Nazwa u\u017cytkownika");
        if (StringUtils.isBlank((String)viewName)) {
            throw new IllegalArgumentException("Nie podano nazwy widoku. Wiersz: " + rowNum);
        }
        if (StringUtils.isBlank((String)userName)) {
            throw new IllegalArgumentException("Nie podano nazwy u\u017cytkownika. Wiersz: " + rowNum);
        }
    }

    private Map<String, String> getStandardVariablesMap() {
        I18N oMessage = new I18N();
        HashMap<String, String> hmVariablesViewName = new HashMap<String, String>();
        hmVariablesViewName.put(oMessage.getString("Typ_procesu"), "processType");
        hmVariablesViewName.put(oMessage.getString("Nazwa_procesu"), "procName");
        hmVariablesViewName.put(oMessage.getString("Opis_procesu"), "procDescr");
        hmVariablesViewName.put(oMessage.getString("Inicjator"), "procInitiator");
        hmVariablesViewName.put(oMessage.getString("Status_procesu"), "procStateSelect");
        hmVariablesViewName.put(oMessage.getString("Procent_realizacji"), "realizationPercent");
        hmVariablesViewName.put(oMessage.getString("Data_rozpoczecia"), "procStart");
        hmVariablesViewName.put(oMessage.getString("Data_zakonczenia"), "procFinish");
        hmVariablesViewName.put(oMessage.getString("Przekroczenie_terminu_w_dn"), "processDeadline");
        hmVariablesViewName.put(oMessage.getString("Nazwa_zadania"), "taskName");
        hmVariablesViewName.put(oMessage.getString("Status_zadania"), "taskStateSelect");
        hmVariablesViewName.put(oMessage.getString("Uzytkownik"), "taskUser");
        hmVariablesViewName.put(oMessage.getString("Data_rozpoczecia"), "taskStart");
        hmVariablesViewName.put(oMessage.getString("Data_zakonczenia"), "taskFinish");
        hmVariablesViewName.put(oMessage.getString("Przekroczenie_terminu_zadania_w_dn"), "taskDeadline");
        hmVariablesViewName.put(oMessage.getString("Tylko_zadania_do_wykonania"), "onlyActiveTask");
        hmVariablesViewName.put(oMessage.getString("Tylko_moje_zadania"), "onlyLoggedUserTask");
        hmVariablesViewName.put(oMessage.getString("n_a"), "procDefId");
        hmVariablesViewName.put(oMessage.getString("Nazwa_terminu_ostatecznego"), "taskDeadlineName");
        hmVariablesViewName.put(oMessage.getString("Wyswietl_wyniki_zmiennych__tabelarycznych_w_jednym_wierszu"), "resultsInOneRow");
        return hmVariablesViewName;
    }

    private AdvanceSearchVariableTable getProcDefIdVar(String processDefId) {
        String varName = "procDefId";
        String varValue = processDefId;
        AdvanceSearchVariableTable advanceSearchVariableTable = new AdvanceSearchVariableTable("", varName, varValue, null, null, null, null, null);
        return advanceSearchVariableTable;
    }

    private String getProcessDefIdByName(String processName) {
        return CUFFactory.getProcessHelper().getProcessDefIdByName(processName);
    }

    private Map<String, String> getVarIdName(String processName) {
        String processDefId = this.getProcessDefIdByName(processName);
        WorkflowProcess wp = SharkFunctions.getWorkflowProcessByDefId((String)processDefId);
        if (wp == null) {
            throw new IllegalArgumentException("Nie znaleziono procesu o nazwie: " + processName);
        }
        HashMap<String, String> varNameId = new HashMap<String, String>();
        DataFields fields = wp.getDataFields();
        for (int i = 0; i < fields.size(); ++i) {
            DataField df = (DataField)fields.get(i);
            varNameId.put(df.getName(), df.getId());
        }
        return varNameId;
    }

    private List<AdvanceSearchVariableTable> readProcessVariables(String name, Map<String, String> varNameId, List<Map<String, Object>> data) {
        ArrayList<AdvanceSearchVariableTable> vars = new ArrayList<AdvanceSearchVariableTable>();
        for (Map<String, Object> row : data) {
            String viewName = (String)row.get("Nazwa widoku");
            if (!viewName.equals(name)) continue;
            String varName = (String)row.get("Nazwa zmiennej");
            String varValue = (String)row.get("Warto\u015b\u0107 zmiennej");
            String varValue2 = (String)row.get("Warto\u015b\u0107 zmiennej 2");
            String sort = this.readSort(row.get("Sortowanie"));
            String active = this.readBooleanValue(row.get("Widoczno\u015b\u0107"));
            String position = this.readInteger(row.get("Pozycja"));
            String uppercase = this.readBooleanValue(row.get("Pomi\u0144 wielko\u015b\u0107 liter"));
            String varId = varNameId.get(varName);
            AdvanceSearchVariableTable advanceSearchVariableTable = new AdvanceSearchVariableTable("", varId, varValue, varValue2, sort, position, active, uppercase);
            vars.add(advanceSearchVariableTable);
        }
        return vars;
    }

    private String readSort(Object object) {
        if (object == null) {
            return "";
        }
        String sort = object.toString();
        if (sort.equalsIgnoreCase("Rosn\u0105co")) {
            return "asc";
        }
        return "desc";
    }

    private String readInteger(Object object) {
        if (object == null) {
            return "999";
        }
        Double d = (Double)object;
        return String.valueOf(d.intValue());
    }

    private String readBooleanValue(Object object) {
        if (object == null || object.toString().equalsIgnoreCase("nie")) {
            return null;
        }
        return "on";
    }
}

