/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.xpdl;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.cuf.xpdl.XPDLService;
import com.suncode.cuf.xpdl.definition.CheckAcceptation;
import com.suncode.cuf.xpdl.definition.FormVariable;
import com.suncode.cuf.xpdl.exception.UnsupportedVariableType;
import com.suncode.cuf.xpdl.type.DateType;
import com.suncode.cuf.xpdl.type.FloatType;
import com.suncode.cuf.xpdl.type.IntegerType;
import com.suncode.cuf.xpdl.type.LongType;
import com.suncode.cuf.xpdl.type.StringType;
import com.suncode.cuf.xpdl.type.VariableType;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.SharkTransactional;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XPDLServiceImpl
implements XPDLService {
    private final String CHECK_ACCEPTATION = "CHECK_ACCEPTATION";
    private final String ACCEPT_VAR_KEY = "acceptVar";
    private final String CHECK_VAR_KEY = "checkVar";
    private final String SET_VAR_KEY = "setVar";
    private static final Logger log = Logger.getLogger(XPDLServiceImpl.class);
    @Autowired
    private SharkTransactionManager stm;

    @Override
    @SharkTransactional
    public List<CheckAcceptation> getCheckAcceptationDefinitions(String processId, String activityId) {
        return this.getCheckAcceptationDefinitions(this.stm.getSharkTransaction(), processId, activityId);
    }

    @Override
    public List<CheckAcceptation> getCheckAcceptationDefinitions(SharkTransaction st, String processId, String activityId) {
        try {
            Package pack = this.getPackage(st, processId);
            String processDefId = this.getProcessDefId(st, processId);
            String activityDefId = this.getActivityDefId(st, processId, activityId);
            log.info((Object)("Pack: " + pack.getId() + " processDefId: " + processDefId + " activityDefId: " + activityDefId));
            Activity act = this.getActivity(pack, processDefId, activityDefId);
            ExtendedAttributes eas = act.getExtendedAttributes();
            List<String> extendedAttributes = this.getExtendedAttributes(eas, "CHECK_ACCEPTATION");
            List<CheckAcceptation> defs = this.buildDefinitions(extendedAttributes);
            return defs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getActivityDefId(SharkTransaction st, String processId, String activityId) throws BaseException {
        return Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(st, processId, activityId);
    }

    private String getProcessDefId(SharkTransaction st, String processId) throws BaseException {
        return Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(st, processId);
    }

    private Package getPackage(SharkTransaction st, String processId) throws BaseException, ConnectFailed, NotConnected {
        return XpdlPackageManager.getInstance().getPackageByProcessId(st, processId);
    }

    private List<CheckAcceptation> buildDefinitions(List<String> extendedAttributes) {
        ArrayList<CheckAcceptation> defs = new ArrayList<CheckAcceptation>();
        for (String attr : extendedAttributes) {
            defs.add(this.buildDefinition(attr));
        }
        return defs;
    }

    private CheckAcceptation buildDefinition(String attr) {
        Properties props = this.readProperties(attr);
        CheckAcceptation ca = new CheckAcceptation();
        ca.setAcceptVarId(props.getProperty("acceptVar"));
        ca.setCheckVarId(props.getProperty("checkVar"));
        String resultVar = this.readResultVar(props.getProperty("setVar"));
        ca.setResultVarId(resultVar);
        ca.setRawDefinition(attr);
        return ca;
    }

    private String readResultVar(String value) {
        String[] split = value.split(":");
        if (split.length == 0) {
            return null;
        }
        return split[0];
    }

    private Properties readProperties(String attr) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(attr));
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("B\u0142\u0105d \u0142adowania: " + attr, e);
        }
    }

    private List<String> getExtendedAttributes(ExtendedAttributes eas, String type) {
        ArrayList elements = eas.getElementsForName("CHECK_ACCEPTATION");
        ArrayList<String> list = new ArrayList<String>();
        if (elements == null) {
            return list;
        }
        for (Object el : elements) {
            if (el instanceof ExtendedAttribute) {
                ExtendedAttribute ea = (ExtendedAttribute)el;
                list.add(ea.getVValue());
                continue;
            }
            log.warn((Object)("Znalezion nieznany element: " + String.valueOf(el)));
        }
        return list;
    }

    private Activity getActivity(Package pack, String processDefId, String activityDefId) {
        WorkflowProcess wp = this.getWorkflowProcess(pack, processDefId);
        if (wp == null) {
            throw new IllegalArgumentException("Nie znaleziono procesu z pakietu: " + pack.getId() + " o processDefId: " + processDefId);
        }
        return wp.getActivity(activityDefId);
    }

    private WorkflowProcess getWorkflowProcess(Package pack, String processDefId) {
        return pack.getWorkflowProcess(processDefId);
    }

    @Override
    @SharkTransactional
    public List<FormVariable> getFormVariables(String packageId, String processDefId) {
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId);
        WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
        DataFields dataFields = wp.getDataFields();
        List<FormVariable> vars = this.buildVars(dataFields);
        return vars;
    }

    @Override
    @SharkTransactional
    public List<FormVariable> getFormVariables(String processId) {
        try {
            Package pack = this.getPackage(this.stm.getSharkTransaction(), processId);
            String processDefId = this.getProcessDefId(this.stm.getSharkTransaction(), processId);
            WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
            DataFields dataFields = wp.getDataFields();
            List<FormVariable> vars = this.buildVars(dataFields);
            return vars;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<FormVariable> buildVars(DataFields dataFields) {
        ArrayList<FormVariable> vars = new ArrayList<FormVariable>();
        for (int i = 0; i < dataFields.size(); ++i) {
            DataField df = (DataField)dataFields.get(i);
            FormVariable fv = this.buildFormVariable(df);
            vars.add(fv);
        }
        return vars;
    }

    private FormVariable buildFormVariable(DataField df) {
        String id = df.getId();
        String name = df.getName();
        String javaType = df.getDataType().getJavaType();
        VariableType vt = this.convertType(javaType, id);
        FormVariable fv = new FormVariable(id, name, vt);
        return fv;
    }

    private VariableType convertType(String javaType, String id) {
        if (javaType.contains("String")) {
            return new StringType();
        }
        if (javaType.contains("Double")) {
            return new FloatType();
        }
        if (javaType.contains("Date")) {
            return new DateType();
        }
        if (javaType.contains("Long")) {
            return new LongType();
        }
        if (javaType.contains("Integer")) {
            return new IntegerType();
        }
        throw new UnsupportedVariableType(javaType, id);
    }
}

