/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.scheduledTask;

import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.scheduledTask.TaskService;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.ScheduledTaskCategory;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.info.PlanMode;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.util.SpringContext;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class TaskServiceImpl
implements TaskService {
    private SimpleDateFormat sdf = new SimpleDateFormat(DBManagement.CONST_DATEFORMAT);
    private static Logger log = Logger.getLogger(TaskServiceImpl.class);
    private TomcatService tomcatService = (TomcatService)SpringContext.getBean(TomcatService.class);

    @Override
    public void addTask(String taskName, String description, String className, String methodName, Date firstRunDate, String categoryName, boolean active, boolean saveHistory, long interval, List<ScheduledTasksParametersTable> params) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return;
        }
        ScheduledTaskCategory taskCategory = ScheduledTaskCategoryDAO.getByName((String)categoryName);
        if (taskCategory == null) {
            taskCategory = new ScheduledTaskCategory(categoryName);
            ScheduledTaskCategoryDAO.save((ScheduledTaskCategory)taskCategory);
        }
        ScheduledTasksTable task = new ScheduledTasksTable(taskName, description, Boolean.valueOf(active), className, methodName, PlanMode.PERIODIC, firstRunDate, firstRunDate, null, Long.valueOf(interval), Boolean.valueOf(saveHistory), taskCategory);
        task.setScheduled_tasks_parameters(params);
        for (ScheduledTasksParametersTable param : params) {
            param.setScheduled_task(task);
        }
        ScheduledTaskService scheduledTaskService = (ScheduledTaskService)SpringContext.getBean(ScheduledTaskService.class);
        scheduledTaskService.addScheduledTask(task);
    }

    @Override
    public long calculateInterval(String unitName, int value) {
        long period = 0L;
        if (unitName.equals("minute") || unitName.equalsIgnoreCase("minuty") || unitName.equalsIgnoreCase("minuta")) {
            period = TimeUnit.MINUTES.toMillis(value);
        } else if (unitName.equals("hour") || unitName.equalsIgnoreCase("godziny") || unitName.equalsIgnoreCase("godzina")) {
            period = TimeUnit.HOURS.toMillis(value);
        } else if (unitName.equals("day") || unitName.equalsIgnoreCase("dni") || unitName.equalsIgnoreCase("dzie\u0144")) {
            period = TimeUnit.DAYS.toMillis(value);
        } else if (unitName.equals("month") || unitName.equalsIgnoreCase("miesi\u0105ce") || unitName.equalsIgnoreCase("miesi\u0105c")) {
            period = TimeUnit.DAYS.toMillis(value) * 30L;
        }
        return period;
    }

    @Override
    public void importTasksFromExcel(String path) throws Exception {
        ExcelReader er = new ExcelReader();
        List<Map<String, Object>> data = er.readExcel(path);
        HashSet processed = new HashSet();
        for (Map<String, Object> row : data) {
            String taskName = (String)row.get("Nazwa zadania");
            if (processed.contains("taskName")) continue;
            String className = (String)row.get("Nazwa klasy");
            String description = (String)row.get("Opis zadania");
            String methodName = (String)row.get("Nazwa metody");
            Date firstRunDate = this.readDate(row.get("Data pierwszego uruchomienia"));
            String categoryName = (String)row.get("Kategoria");
            boolean active = this.readBoolean(row.get("Zadanie aktywne"));
            boolean saveHistory = this.readBoolean(row.get("Zapisuj histori\u0119 wykonywania"));
            Integer interval = this.readInt(row.get("Okres powt\u00f3rze\u0144"));
            String unitName = (String)row.get("Jednostka powt\u00f3rze\u0144");
            List<ScheduledTasksParametersTable> params = this.readParams(taskName, className, methodName, data);
            long intervalMillis = this.calculateInterval(unitName, interval);
            this.addTask(taskName, description, className, methodName, firstRunDate, categoryName, active, saveHistory, intervalMillis, params);
        }
    }

    @Override
    public ScheduledTasksTable getByName(String name) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(ScheduledTasksTable.class);
            crit.add((Criterion)Restrictions.eq((String)"name", (Object)name));
            crit.setFetchMode("scheduled_tasks_parameters", FetchMode.JOIN);
            List list = crit.list();
            tx.commit();
            if (list.isEmpty()) {
                ScheduledTasksTable scheduledTasksTable = null;
                return scheduledTasksTable;
            }
            ScheduledTasksTable scheduledTasksTable = (ScheduledTasksTable)list.get(0);
            return scheduledTasksTable;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private Integer readInt(Object object) {
        if (object == null) {
            return null;
        }
        Double d = (Double)object;
        Integer i = d.intValue();
        return i;
    }

    private boolean readBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String val = (String)object;
        return val.equalsIgnoreCase("tak") || val.equalsIgnoreCase("t") || val.equalsIgnoreCase("true");
    }

    private Date readDate(Object object) throws ParseException {
        if (object == null) {
            return null;
        }
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else {
            String val = (String)object;
            if (StringUtils.isBlank((String)val)) {
                return null;
            }
            date = this.sdf.parse(val);
        }
        return date;
    }

    private List<ScheduledTasksParametersTable> readParams(String name, String className, String methodName, List<Map<String, Object>> data) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        ArrayList<ScheduledTasksParametersTable> params = new ArrayList<ScheduledTasksParametersTable>();
        HashMap<String, Integer> paramNameIdx = new HashMap<String, Integer>();
        for (Map<String, Object> row : data) {
            String taskName = (String)row.get("Nazwa zadania");
            if (!name.equals(taskName)) continue;
            String paramName = (String)row.get("Nazwa parametru");
            String paramValue = (String)row.get("Warto\u015b\u0107 parametru");
            String paramType = this.readParamType(row.get("Typ parametru"));
            ScheduledTasksParametersTable p = new ScheduledTasksParametersTable();
            p.setParameter_value(paramValue);
            p.setParameter_type(paramType);
            params.add(p);
            paramNameIdx.put(paramName, params.size() - 1);
        }
        this.setParamsPosition(paramNameIdx, params, className, methodName);
        return params;
    }

    private void setParamsPosition(Map<String, Integer> paramNameIdx, List<ScheduledTasksParametersTable> params, String className, String methodName) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        Class<?>[] types = this.getTypes(params);
        Map<String, Integer> namePositionMap = this.getTaskNamePositionMap(className, methodName, types);
        for (String pn : paramNameIdx.keySet()) {
            Integer idx = paramNameIdx.get(pn);
            ScheduledTasksParametersTable pt = params.get(idx);
            pt.setParameter_position(namePositionMap.get(pn));
        }
    }

    private Class<?>[] getTypes(List<ScheduledTasksParametersTable> params) throws ClassNotFoundException {
        Class[] types = new Class[params.size()];
        int idx = 0;
        for (ScheduledTasksParametersTable p : params) {
            Class<?> taskClass;
            types[idx] = taskClass = Class.forName(p.getParameter_type());
            ++idx;
        }
        return types;
    }

    private Map<String, Integer> getTaskNamePositionMap(String className, String methodName, Class<?>[] types) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        ScheduledTaskMethodHelper methodHelper = (ScheduledTaskMethodHelper)SpringContext.getBean(ScheduledTaskMethodHelper.class);
        HashMap<String, Integer> namePos = new HashMap<String, Integer>();
        Class<?> taskClass = Class.forName(className);
        Method method = taskClass.getDeclaredMethod(methodName, types);
        ScheduledTaskMethodDto methodInfo = methodHelper.getMethodInfo(method);
        List params = methodInfo.getParameters();
        for (ScheduledTaskMethodDto.Parameter param : params) {
            String paramName = param.getAnnotationName();
            Integer paramPos = param.getPosition();
            namePos.put(paramName, paramPos);
        }
        return namePos;
    }

    private String readParamType(Object object) {
        if (object == null) {
            return String.class.getName();
        }
        String val = (String)object;
        if (val.equalsIgnoreCase("string") || val.equalsIgnoreCase("tekst") || val.equalsIgnoreCase("text")) {
            return String.class.getName();
        }
        return val;
    }
}

