/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.msproject;

import com.plusmpm.CUF.util.extension.msproject.MSPTask;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class MSPProject {
    private ProjectFile projectFile = new ProjectFile();
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    private ProjectCalendar pc;

    public ProjectFile getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(ProjectFile projectFile) {
        this.projectFile = projectFile;
    }

    public void addTask(MSPTask mspTask) throws ParseException {
        this.pc = new ProjectCalendar(this.projectFile);
        Task task = this.projectFile.addTask();
        this.createTask(task, mspTask);
    }

    private void createTask(Task task, MSPTask mspTask) {
        task.setName(mspTask.getName());
        double days = 0.0;
        double daysComplete = 0.0;
        Duration dur = null;
        if (mspTask.getStartDate() != null && mspTask.getEndDate() != null) {
            task.setStart(mspTask.getStartDate());
            dur = this.pc.getWork(mspTask.getStartDate(), mspTask.getEndDate(), TimeUnit.DAYS);
            task.setDuration(dur);
            task.setActualStart(mspTask.getStartDate());
            days = dur.getDuration();
            if (mspTask.getPercentageComplete() != null) {
                daysComplete = mspTask.getPercentageComplete() * days;
                task.setActualWork(Duration.getInstance((double)daysComplete, (TimeUnit)TimeUnit.DAYS));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)mspTask.getResourceName())) {
            Resource r = null;
            if (this.resources.containsKey(mspTask.getResourceName())) {
                r = this.resources.get(mspTask.getResourceName());
            } else {
                r = this.projectFile.addResource();
                r.setName(mspTask.getResourceName());
                this.resources.put(mspTask.getResourceName(), r);
            }
            ResourceAssignment ra = task.addResourceAssignment(r);
            ra.setStart(mspTask.getStartDate());
            ra.setRemainingWork(dur);
            ra.setWork(dur);
            ra.setStartVariance(Duration.getInstance((int)0, (TimeUnit)TimeUnit.DAYS));
            ra.setActualWork(Duration.getInstance((double)daysComplete, (TimeUnit)TimeUnit.DAYS));
        }
        for (MSPTask child : mspTask.getChildren()) {
            Task ch = task.addTask();
            this.createTask(ch, child);
        }
    }

    private void prepareCalendar() throws ParseException {
        this.pc = this.projectFile.addBaseCalendar();
        this.projectFile.setCalendar(this.pc);
        this.pc.setName("calendar");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        DateRange range = new DateRange(format.parse("2000-01-01 08:00"), format.parse("2000-01-01 16:00"));
        this.pc.setWorkingDay(Day.SUNDAY, true);
        this.pc.setWorkingDay(Day.MONDAY, true);
        this.pc.setWorkingDay(Day.TUESDAY, true);
        this.pc.setWorkingDay(Day.WEDNESDAY, true);
        this.pc.setWorkingDay(Day.THURSDAY, true);
        this.pc.setWorkingDay(Day.FRIDAY, true);
        this.pc.setWorkingDay(Day.SATURDAY, true);
        ProjectCalendarHours hours = this.pc.addCalendarHours(Day.SUNDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.MONDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.TUESDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.WEDNESDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.THURSDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.FRIDAY);
        hours.addRange(range);
        hours = this.pc.addCalendarHours(Day.SATURDAY);
        hours.addRange(range);
    }
}

