/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper.internal;

import com.suncode.cuf.plannedtask.administration.structure.helper.ExportStructureBuilder;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportStructureBuilderImpl
implements ExportStructureBuilder {
    private final String SEPARATOR = ";";
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private PositionFinder posFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;
    @Autowired
    private UserGroupFinder groupFinder;

    @Override
    public List<Map<String, Object>> buildUsersMap() {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        List<User> users = this.getAllUsers();
        for (User user : users) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("userName", user.getUserName());
            userMap.put("firstName", user.getFirstName());
            userMap.put("lastName", user.getLastName());
            userMap.put("password", "");
            userMap.put("email", user.getEmail());
            userMap.put("number", user.getNumber());
            userMap.put("groups", this.joinGroupNames(user.getGroups()));
            userMap.put("positions", this.joinPositionSymbols(user.getPositions()));
            userList.add(userMap);
        }
        return userList;
    }

    @Override
    public List<Map<String, Object>> buildPositionsMap() {
        ArrayList<Map<String, Object>> positionList = new ArrayList<Map<String, Object>>();
        List<Position> positions = this.getAllPositions();
        for (Position position : positions) {
            HashMap<String, String> positionMap = new HashMap<String, String>();
            positionMap.put("name", position.getName());
            positionMap.put("symbol", position.getSymbol());
            positionMap.put("higherPosition", this.getHigherPositionSymbol(position));
            positionMap.put("orgUnit", this.getOrganizationalUnitSymbol(position));
            positionMap.put("roles", this.joinRoleIds(position.getRoles()));
            positionList.add(positionMap);
        }
        return positionList;
    }

    @Override
    public List<Map<String, Object>> buildOrgUnitsMap() {
        ArrayList<Map<String, Object>> orgUnitList = new ArrayList<Map<String, Object>>();
        List<OrganizationalUnit> orgUnits = this.getAllOrgUnits();
        for (OrganizationalUnit orgUnit : orgUnits) {
            HashMap<String, String> orgUnitMap = new HashMap<String, String>();
            orgUnitMap.put("name", orgUnit.getName());
            orgUnitMap.put("symbol", orgUnit.getSymbol());
            orgUnitMap.put("higherOrgUnit", this.getHigherOrganizationalUnitSymbol(orgUnit));
            orgUnitMap.put("directorPosition", this.getDirectorPositionSymbol(orgUnit));
            orgUnitList.add(orgUnitMap);
        }
        return orgUnitList;
    }

    @Override
    public List<Map<String, Object>> buildGroupsMap() {
        ArrayList<Map<String, Object>> groupList = new ArrayList<Map<String, Object>>();
        List<UserGroup> groups = this.getAllGroups();
        for (UserGroup group : groups) {
            HashMap<String, String> groupMap = new HashMap<String, String>();
            groupMap.put("name", group.getName());
            groupMap.put("description", group.getDescription());
            groupList.add(groupMap);
        }
        return groupList;
    }

    private List<User> getAllUsers() {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.addOrder(Order.asc((String)"lastName"));
        dc.setFetchMode("groups", FetchMode.JOIN);
        dc.setFetchMode("positions", FetchMode.JOIN);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List users = this.userFinder.findByCriteria(dc);
        return users;
    }

    private List<Position> getAllPositions() {
        DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
        dc.addOrder(Order.asc((String)"name"));
        dc.setFetchMode("roles", FetchMode.JOIN);
        dc.setFetchMode("higherPosition", FetchMode.JOIN);
        dc.setFetchMode("organizationalUnit", FetchMode.JOIN);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List positions = this.posFinder.findByCriteria(dc);
        return positions;
    }

    private List<OrganizationalUnit> getAllOrgUnits() {
        DetachedCriteria dc = DetachedCriteria.forClass(OrganizationalUnit.class);
        dc.addOrder(Order.asc((String)"name"));
        dc.setFetchMode("directorPosition", FetchMode.JOIN);
        dc.setFetchMode("higherOrganizationalUnit", FetchMode.JOIN);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List orgUnits = this.ouFinder.findByCriteria(dc);
        return orgUnits;
    }

    private List<UserGroup> getAllGroups() {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        dc.addOrder(Order.asc((String)"name"));
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List groups = this.groupFinder.findByCriteria(dc);
        return groups;
    }

    private String getOrganizationalUnitSymbol(Position p) {
        if (p.getOrganizationalUnit() == null) {
            return "";
        }
        return p.getOrganizationalUnit().getSymbol();
    }

    private String getHigherPositionSymbol(Position p) {
        if (p.getHigherPosition() == null) {
            return "";
        }
        return p.getHigherPosition().getSymbol();
    }

    private String getDirectorPositionSymbol(OrganizationalUnit ou) {
        if (ou.getDirectorPosition() == null) {
            return "";
        }
        return ou.getDirectorPosition().getSymbol();
    }

    private String getHigherOrganizationalUnitSymbol(OrganizationalUnit ou) {
        if (ou.getHigherOrganizationalUnit() == null) {
            return "";
        }
        return ou.getHigherOrganizationalUnit().getSymbol();
    }

    private String joinRoleIds(Set<Role> roles) {
        StringBuilder sb = new StringBuilder();
        for (Role role : roles) {
            sb.append(role.getPackageId());
            sb.append(":");
            sb.append(role.getProcessDefId());
            sb.append(":");
            sb.append(role.getRoleId());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - ";".length());
        }
        return sb.toString();
    }

    private String joinGroupNames(Set<UserGroup> groups) {
        StringBuilder sb = new StringBuilder();
        for (UserGroup group : groups) {
            sb.append(group.getName());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - ";".length());
        }
        return sb.toString();
    }

    private String joinPositionSymbols(Set<Position> positions) {
        StringBuilder sb = new StringBuilder();
        for (Position position : positions) {
            sb.append(position.getSymbol());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - ";".length());
        }
        return sb.toString();
    }
}

