/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.pdf;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtils {
    private static final Logger log = LoggerFactory.getLogger(PdfUtils.class);

    public static void removeBlankPages(String sFilePathPdf) {
        File input = new File(sFilePathPdf);
        try {
            PDDocument doc = PDDocument.load((File)input);
            PDPageTree list = doc.getDocumentCatalog().getPages();
            PDPage firstPdPage = list.get(0);
            Iterable pageImages = Optional.ofNullable(firstPdPage.getResources()).map(PDResources::getXObjectNames).orElse(null);
            for (int i = list.getCount(); i > 0; --i) {
                String pageText;
                PDFTextStripper reader = new PDFTextStripper();
                reader.setStartPage(i);
                reader.setEndPage(i);
                PDPage pdPage = list.get(i - 1);
                PDFStreamParser parser = new PDFStreamParser((PDContentStream)pdPage);
                parser.parse();
                List tokens = parser.getTokens();
                Boolean isImageOnPage = false;
                if (pageImages != null) {
                    for (COSName key : pageImages) {
                        if (!tokens.contains(key)) continue;
                        isImageOnPage = true;
                        break;
                    }
                }
                if ((pageText = reader.getText(doc).replaceAll("\\s+", "")).length() != 0 || isImageOnPage.booleanValue()) break;
                doc.removePage(list.get(i - 1));
            }
            doc.save(sFilePathPdf);
            log.info("Deleting blank pages completed");
        }
        catch (Exception e) {
            log.info("ERROR - problem while deleting blank pages from a PDF file");
        }
    }
}

