/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.externalDBConf;

import com.plusmpm.CUF.database.externalDBConf.ExternalDBConf;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ExternalDBConfManager {
    public static void save(ExternalDBConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.save((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void update(ExternalDBConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void delete(ExternalDBConf oneConf) throws HibernateException, Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)oneConf);
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public void deleteAll() throws HibernateException, Exception {
        List<ExternalDBConf> AllConfList = ExternalDBConfManager.getAll();
        try {
            for (ExternalDBConf oneConf : AllConfList) {
                ExternalDBConfManager.delete(oneConf);
            }
        }
        catch (HibernateException he) {
            throw he;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static List<ExternalDBConf> getAll() throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createCriteria(ExternalDBConf.class).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static long checkExistence(String sName, String sUrl, String sDriver, String sLogin, String sPassword) throws HibernateException, Exception {
        ExternalDBConf conf = null;
        Session session = null;
        Transaction transaction = null;
        long result = -1L;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            conf = (ExternalDBConf)session.createQuery("from ExternalDBConf where externalDBConfName=:sName and url=:sUrl and driver=:sDriver and login=:sLogin and password=:sPassword").setParameter("sName", (Object)sName).setParameter("sUrl", (Object)sUrl).setParameter("sDriver", (Object)sDriver).setParameter("sLogin", (Object)sLogin).setParameter("sPassword", (Object)sPassword).uniqueResult();
            transaction.commit();
            if (conf == null) {
                long l = result;
                return l;
            }
            long l = conf.getId();
            return l;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<ExternalDBConf> getExternalDBConfForName(String name) throws HibernateException, Exception {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from ExternalDBConf where externaldbconfname=:ident order by url").setParameter("ident", (Object)name).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }
}

