/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportRights
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportRights.class);
    private static String[] rightLevelsTable = new String[]{RightTreeBuilder.builder().system().build(), RightTreeBuilder.builder().system().admin().build(), RightTreeBuilder.builder().system().archive().build(), RightTreeBuilder.builder().system().archive().docClasses().build(), RightTreeBuilder.builder().system().archive().links().build(), RightTreeBuilder.builder().system().workflow().build(), RightTreeBuilder.builder().system().workflow().processes().create().build(), RightTreeBuilder.builder().system().workflow().tasks().build(), RightTreeBuilder.builder().system().workflow().processes().view().build(), RightTreeBuilder.builder().system().workflow().processes().stats().build(), RightTreeBuilder.builder().system().workflow().calendar().build(), RightTreeBuilder.builder().system().reports().build(), RightTreeBuilder.builder().system().userAccount().build()};
    private static int currentRowPos;

    @AdvancedTask(name="ExportRightsToXLS", description="ExportRightsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportRightsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportRightsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook w = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        HashMap<String, List<String>> rightsList = null;
        int colPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            w = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet rightsSheet = w.createSheet("Uprawnienia", 0);
            log.info((Object)"Utworzono arkusz do eksportu uprawnien");
            currentRowPos = 0;
            String[] colIDs = new String[]{"Nazwa grupy", "Nazwa u\u017cytkownika", "System", "Administracja", "Archiwum", "Klasy dokument\u00f3w", "Zestawy dokument\u00f3w", "Obieg dokument\u00f3w", "Tworzenie proces\u00f3w", "Skrzynka zada\u0144", "Wyszukiwanie proces\u00f3w", "Statystyki", "Kalendarz", "Raporty", "Konto u\u017cytkownika"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(rightsSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            ++currentRowPos;
            log.info((Object)"Utworzono naglowki w arkuszu");
            boolean bForGroup = true;
            rightsList = ExportRights.getRightsList(bForGroup);
            ExportRights.sendToXLS(rightsSheet, cellView, rightsList, bForGroup);
            bForGroup = false;
            rightsList = ExportRights.getRightsList(bForGroup);
            ExportRights.sendToXLS(rightsSheet, cellView, rightsList, bForGroup);
            w.write();
            w.close();
            log.info((Object)("Eksport uprawnien do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania uprawnien. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    w.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportRightsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static HashMap<String, List<String>> getRightsList(boolean bForGroup) throws Exception {
        log.trace((Object)("************ getRightsList(bForGroup=" + String.valueOf(bForGroup) + ") ************"));
        HashMap<String, List<String>> rightsList = new HashMap<String, List<String>>();
        Set resourceIdsForRight = null;
        String sWhoLog = "";
        String sRightFroundLog = "";
        String sNoRightFoundLog = "";
        if (bForGroup) {
            sWhoLog = "grup";
            sRightFroundLog = "Sa grupy, ktore";
            sNoRightFoundLog = "Zadna grupa";
        } else {
            sWhoLog = "uzytkownikow";
            sRightFroundLog = "Sa uzytkownicy, ktorzy";
            sNoRightFoundLog = "Zaden uzytkownik";
        }
        log.info((Object)("Pobieranie z systemu praw dla " + sWhoLog));
        for (String rightLevelName : rightLevelsTable) {
            log.info((Object)("Pobieranie nazw " + sWhoLog + " posiadajacych prawo " + rightLevelName));
            resourceIdsForRight = Authorization.listRights((String)rightLevelName, (boolean)bForGroup);
            if (resourceIdsForRight != null && resourceIdsForRight.size() > 0) {
                log.info((Object)(sRightFroundLog + " posiadaja prawo " + rightLevelName));
                for (String sResourceId : resourceIdsForRight) {
                    List<Object> rightsForResourceList;
                    if (Tools.isNullOrEmpty((String)sResourceId) || sResourceId.equals("admin") || sResourceId.equals("SharkGroup") || sResourceId.equals("Administrators")) continue;
                    if (rightsList.containsKey(sResourceId)) {
                        rightsForResourceList = rightsList.get(sResourceId);
                        rightsForResourceList.add(rightLevelName);
                        rightsList.put(sResourceId, rightsForResourceList);
                        continue;
                    }
                    rightsForResourceList = new ArrayList();
                    rightsForResourceList.add(rightLevelName);
                    rightsList.put(sResourceId, rightsForResourceList);
                }
                continue;
            }
            log.info((Object)(sNoRightFoundLog + " nie posiada prawa " + rightLevelName));
        }
        return rightsList;
    }

    private static void sendToXLS(WritableSheet rightsSheet, CellView cellView, HashMap<String, List<String>> rightsList, boolean bForGroup) throws Exception {
        log.trace((Object)("************ sendToXLS(WritableSheet, CellView, HashMap<String, List<String>>, bForGroup=" + String.valueOf(bForGroup) + ") ************"));
        if (rightsList != null && rightsList.size() > 0) {
            for (String sResourceId : rightsList.keySet()) {
                int colPos = bForGroup ? 0 : 1;
                CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, sResourceId, null, cellView);
                ++colPos;
                List<String> rightsForResourceList = rightsList.get(sResourceId);
                colPos = 2;
                for (String rightLevelName : rightLevelsTable) {
                    if (rightsForResourceList.contains(rightLevelName)) {
                        CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, "T", null, cellView);
                    } else {
                        CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, "N", null, cellView);
                    }
                    ++colPos;
                }
                ++currentRowPos;
            }
        }
    }
}

