/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.DataChoosers.defs;

import com.plusmpm.CUF.util.DataChoosers.defs.DefReader;
import com.plusmpm.util.Tools;
import com.plusmpm.util.form.datachooser.CustomKeys;
import com.plusmpm.util.form.datachooser.Definition;
import com.plusmpm.util.form.datachooser.FormCriteria;
import com.plusmpm.util.form.datachooser.Mappings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefReaderImpl
implements DefReader {
    public static Logger log = Logger.getLogger(DefReaderImpl.class);
    private static final String defFileExtension = "xml";
    private static final String definitionElName = "Definition";
    private static final String classpathElName = "Classpath";
    private static final String nameElName = "Name";
    private static final String descrElName = "Description";
    private static final String formCriterionElName = "FormCriterion";
    private static final String mappingElName = "Mapping";
    private static final String customKeyElName = "CustomKey";
    private static final String valueAttributeName = "value";
    private static final String idAttributeName = "id";
    private static final String varIdAttributeName = "varId";
    private static final String descrAttributeName = "description";
    private static final String displayAttributeName = "display";
    private static final String availableValuesAttributeName = "availableValues";
    private static final String availableValuesSplitSign = ";";

    @Override
    public Definition getDefinition(String id, String lang) {
        Definition definition = null;
        Document doc = null;
        Element defEl = null;
        String classpath = null;
        try {
            doc = this.getResource(id, lang);
            defEl = (Element)doc.getElementsByTagName(definitionElName).item(0);
            classpath = this.getElementsElementAttribute(defEl, classpathElName, valueAttributeName);
            try {
                Class.forName(classpath);
            }
            catch (ClassNotFoundException e) {
                return new Definition();
            }
            definition = new Definition();
            definition.setClasspath(classpath);
            definition.setName(this.getElementsElementAttribute(defEl, nameElName, valueAttributeName));
            definition.setDescr(this.getElementsElementAttribute(defEl, descrElName, valueAttributeName));
            return definition;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new Definition();
        }
    }

    @Override
    public List<FormCriteria> getFormCriteria(String id, String lang) {
        ArrayList<FormCriteria> formCriteria = null;
        Document doc = null;
        NodeList fcList = null;
        try {
            doc = this.getResource(id, lang);
            fcList = doc.getElementsByTagName(formCriterionElName);
            if (fcList == null || fcList.getLength() == 0) {
                return new ArrayList<FormCriteria>();
            }
            formCriteria = new ArrayList<FormCriteria>();
            for (int i = 0; i < fcList.getLength(); ++i) {
                Element fcEl = (Element)fcList.item(i);
                FormCriteria fc = new FormCriteria();
                fc.setVarId(fcEl.getAttribute(varIdAttributeName));
                fc.setDescr(fcEl.getAttribute(descrAttributeName));
                formCriteria.add(fc);
            }
            return formCriteria;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<FormCriteria>();
        }
    }

    @Override
    public List<Mappings> getMappings(String id, String lang) {
        ArrayList<Mappings> mappings = null;
        Document doc = null;
        NodeList mList = null;
        try {
            doc = this.getResource(id, lang);
            mList = doc.getElementsByTagName(mappingElName);
            if (mList == null || mList.getLength() == 0) {
                return new ArrayList<Mappings>();
            }
            mappings = new ArrayList<Mappings>();
            for (int i = 0; i < mList.getLength(); ++i) {
                Element mEl = (Element)mList.item(i);
                Mappings m = new Mappings();
                m.setId(mEl.getAttribute(idAttributeName));
                m.setDescr(mEl.getAttribute(descrAttributeName));
                m.setDisplay(mEl.getAttribute(displayAttributeName));
                mappings.add(m);
            }
            return mappings;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<Mappings>();
        }
    }

    @Override
    public List<CustomKeys> getCustomKeys(String id, String lang) {
        ArrayList<CustomKeys> customKeys = null;
        Document doc = null;
        NodeList ckList = null;
        try {
            doc = this.getResource(id, lang);
            ckList = doc.getElementsByTagName(customKeyElName);
            if (ckList == null || ckList.getLength() == 0) {
                return new ArrayList<CustomKeys>();
            }
            customKeys = new ArrayList<CustomKeys>();
            for (int i = 0; i < ckList.getLength(); ++i) {
                Element ckEl = (Element)ckList.item(i);
                CustomKeys ck = new CustomKeys();
                ck.setId(ckEl.getAttribute(idAttributeName));
                ck.setDescr(ckEl.getAttribute(descrAttributeName));
                ck.setValue(ckEl.getAttribute(valueAttributeName));
                String availableValues = ckEl.getAttribute(availableValuesAttributeName);
                if (!Tools.isNullOrEmpty((String)availableValues)) {
                    ck.setAvailableValues(availableValues.split(availableValuesSplitSign));
                }
                customKeys.add(ck);
            }
            return customKeys;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<CustomKeys>();
        }
    }

    private String getElementsElementAttribute(Element el, String elName, String attrName) {
        return ((Element)el.getElementsByTagName(elName).item(0)).getAttribute(attrName);
    }

    private Document getResource(String id, String lang) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(id + "_" + lang + ".xml");
        Document doc = this.getXMLFromInputStream(is);
        doc.normalize();
        return doc;
    }

    private Document getXMLFromInputStream(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = null;
        InputSource inputSource = null;
        try (InputStreamReader reader = null;){
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            reader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(reader);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            return document;
        }
    }
}

