/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.plannedtask.administration.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.helper.internal.ExcelMappings;
import com.suncode.cuf.plannedtask.administration.structure.ImportStructureUtils;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.SpringContext;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

@ScheduledTask
@ScheduledTaskScript(value="scripts/import-structure-form.js")
public class ImportStructureTask {
    private Logger log;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("import-structure-task")).name("importStructure")).description("importStructure")).parameter().id("path_to_excel_file").name("path_to_excel_file").description("path_to_excel_file").type((Type)Types.STRING).create()).parameter().id("read_mode").name("read_mode").description("read_mode_desc").type((Type)Types.STRING).create()).parameter().id("unused_users").name("unused_users").description("unused_users_desc").type((Type)Types.STRING).create()).parameter().id("assign_users_tasks").name("assign_users_tasks").description("assign_users_tasks_desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="path_to_excel_file") String path, @Param(value="read_mode") String mode, @Param(value="unused_users") String unusedUsersHandleType, @Param(value="assign_users_tasks") String assignmentUsers, Logger taskLog) throws Exception {
        this.log = taskLog;
        ImportStructureUtils.checkFileExist(path);
        Workbook workBook = this.getWorkBook(path);
        ImportSheetDefinition sheetDefinition = ImportStructureUtils.getSheetDefinitionForStructure(workBook.getSheetAt(0).getSheetName(), ExcelMappings.getInstance());
        workBook.close();
        ArrayList<ImportSheetDefinition> importSheetDefinitions = new ArrayList<ImportSheetDefinition>();
        importSheetDefinitions.add(sheetDefinition);
        StructureData data = ImportStructureUtils.importDataFromXls(importSheetDefinitions, path);
        StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
        validator.validateStructure(data, mode);
        ImportStructureUtils.exportDataToDatabase(data, mode, unusedUsersHandleType, assignmentUsers);
    }

    private Workbook getWorkBook(String path) {
        Workbook workbook;
        FileInputStream inputStream = new FileInputStream(path);
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.log.error((Object)("B\u0142\u0105d odczytu pliku: " + e));
                return null;
            }
        }
        inputStream.close();
        return workbook;
    }
}

