/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserDelegationsTable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.xpdl.elements.Package;

@Deprecated(since="4.2", forRemoval=true)
public class ImportDelegations
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDelegations.class);

    @AdvancedTask(name="ImportDelegationsFromXLS", description="ImportDelegationsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDelegationsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportDelegationsFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Zast\u0119pstwa");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Zast\u0119pstwa w pliku xls w lokalizacji " + sXLSPath);
            }
            for (int i = 0; i < 6; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z zastepstwami");
            List packages = SharkFunctions.getPackageManager().getPackages();
            if (packages != null && packages.size() > 0) {
                for (Package pack : packages) {
                    String packageId;
                    if (pack == null || Tools.isNullOrEmpty((String)(packageId = pack.getId()))) continue;
                    Date dCurrentDate = new Date(startTime);
                    for (int i = 1; i < sheet.getRows(); ++i) {
                        try {
                            String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                            String procDefId = "";
                            String participantName = sheet.getCell(((Integer)header.get("Uczestnik procesu")).intValue(), i).getContents();
                            String participantId = "";
                            String user = sheet.getCell(((Integer)header.get("U\u017cytkownik")).intValue(), i).getContents();
                            String delegatedUser = sheet.getCell(((Integer)header.get("Zast\u0119pca")).intValue(), i).getContents();
                            String startDate = sheet.getCell(((Integer)header.get("Od")).intValue(), i).getContents();
                            Date dStartDate = null;
                            String finishDate = sheet.getCell(((Integer)header.get("Do")).intValue(), i).getContents();
                            Date dFinishDate = null;
                            procDefId = processName.equalsIgnoreCase("Wszystkie") ? "*" : CUFTools.getProcDefIdForProcessName(processName);
                            if (Tools.isNullOrEmpty((String)procDefId)) {
                                throw new CUFException("W systemie nie istnieje proces o nazwie " + processName);
                            }
                            if (participantName.equalsIgnoreCase("Wszyscy")) {
                                participantId = "*";
                            }
                            if (Tools.isNullOrEmpty((String)participantId)) {
                                throw new CUFException("W procesie o nazwie " + processName + " nie istnieje uczestnik o nazwie " + participantName);
                            }
                            if (!uga.doesUserExist(user)) {
                                throw new CUFException("Zastepowany uzytkownik " + user + " nie istnieje w systemie");
                            }
                            if (!uga.doesUserExist(delegatedUser)) {
                                throw new CUFException("Delegowany do zastepstwa uzytkownik " + delegatedUser + " nie istnieje w systemie");
                            }
                            try {
                                dStartDate = sdf.parse(startDate);
                            }
                            catch (ParseException e) {
                                taskLog.error((Object)e.getMessage());
                                throw new CUFException("Niepoprawny format daty rozpoczecia zastepstwa w pliku w linii " + (i + 1));
                            }
                            if (dCurrentDate.after(dStartDate)) {
                                throw new CUFException("Obecna data jest pozniejsza niz data rozpoczecia zastepstwa w pliku w linii " + (i + 1));
                            }
                            try {
                                dFinishDate = sdf.parse(finishDate);
                            }
                            catch (ParseException e) {
                                taskLog.error((Object)e.getMessage());
                                throw new CUFException("Niepoprawny format daty zakonczenia zastepstwa w pliku w linii " + (i + 1));
                            }
                            if (dCurrentDate.after(dFinishDate)) {
                                throw new CUFException("Obecna data jest pozniejsza niz data zakonczenia zastepstwa w pliku w linii " + (i + 1));
                            }
                            if (dStartDate.after(dFinishDate)) {
                                throw new CUFException("Data zakonczenia zastepstwa jest wczesniejsza od daty rozpoczecia zastepstwa w pliku w linii " + (i + 1));
                            }
                            UserDelegationsTable userDelegationsTable = new UserDelegationsTable(new Long(0L), procDefId, participantId, user, delegatedUser, Long.valueOf(dStartDate.getTime()), Long.valueOf(dFinishDate.getTime()), "TRUE");
                            long id = dbm.addUsersDelegation(userDelegationsTable);
                            if (id == -1L) {
                                throw new CUFException("Blad podczas dodawania do systemu zastepstwa w procesie o nazwie " + processName + " dla uzytkownika " + user);
                            }
                            log.info((Object)("Poprawnie dodano zastepstwo w procesie o nazwie " + processName + " dla uzytkownika " + user));
                            continue;
                        }
                        catch (CUFException e) {
                            taskLog.error((Object)e.getMessage());
                            log.warn((Object)e.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            taskLog.error((Object)e.getMessage());
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            } else {
                log.warn((Object)"Brak pakietow w systemie");
            }
            log.info((Object)"Zakonczono import zastepstw");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDelegationsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

