/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model.writer;

import com.suncode.cuf.io.office.model.writer.ResolvableValueWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Workbook;

public class NumericValueWriter
implements ResolvableValueWriter {
    @Override
    public void setCellType(Cell cell, Workbook workbook, CreationHelper helper) {
        cell.setCellType(CellType.NUMERIC);
    }

    @Override
    public void setCellValue(Cell cell, Object value) {
        if (!StringUtils.isEmpty((String)value.toString())) {
            double d = Double.valueOf(value.toString());
            cell.setCellValue(d);
        }
    }

    private boolean isNumeric(Class<?> cl) {
        return cl.equals(Integer.class) || cl.equals(Double.class) || cl.equals(Float.class) || cl.equals(BigDecimal.class) || cl.equals(BigInteger.class);
    }

    @Override
    public boolean isValidValue(Object value) {
        return this.isNumeric(value.getClass());
    }

    @Override
    public boolean canResolveValue(Class<?> type) {
        return this.isNumeric(type);
    }

    @Override
    public int getPriority() {
        return 9;
    }
}

