/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table;

import java.beans.ConstructorProperties;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.RPr;

public class TableStyle {
    private RPr firstColumnRPr = null;
    private boolean firstColumnMarked;
    private RPr lastColumnRPr = null;
    private boolean lastColumnMarked;
    private RPr firstRowRPr = null;
    private boolean firstRowMarked;
    private RPr lastRowRPr = null;
    private boolean lastRowMarked;

    public String toString() {
        return String.format("TableStyle( firstColumnMarked = %b, lastColumnMarked = %b, firstRowMarked = %b, lastRowMarked = %b )", this.firstColumnMarked, this.lastColumnMarked, this.firstRowMarked, this.lastRowMarked);
    }

    public void applyRPrStyleByType(CTTblStylePr tblStylePr) {
        switch (tblStylePr.getType()) {
            case FIRST_COL: {
                this.firstColumnRPr = tblStylePr.getRPr();
                break;
            }
            case LAST_COL: {
                this.lastColumnRPr = tblStylePr.getRPr();
                break;
            }
            case FIRST_ROW: {
                this.firstRowRPr = tblStylePr.getRPr();
                break;
            }
            case LAST_ROW: {
                this.lastRowRPr = tblStylePr.getRPr();
                break;
            }
        }
    }

    public boolean isAnyStyleMarked() {
        return this.firstColumnMarked | this.lastColumnMarked | this.firstRowMarked | this.lastRowMarked;
    }

    public RPr getFirstColumnRPr() {
        return this.firstColumnRPr;
    }

    public boolean isFirstColumnMarked() {
        return this.firstColumnMarked;
    }

    public RPr getLastColumnRPr() {
        return this.lastColumnRPr;
    }

    public boolean isLastColumnMarked() {
        return this.lastColumnMarked;
    }

    public RPr getFirstRowRPr() {
        return this.firstRowRPr;
    }

    public boolean isFirstRowMarked() {
        return this.firstRowMarked;
    }

    public RPr getLastRowRPr() {
        return this.lastRowRPr;
    }

    public boolean isLastRowMarked() {
        return this.lastRowMarked;
    }

    public void setFirstColumnRPr(RPr firstColumnRPr) {
        this.firstColumnRPr = firstColumnRPr;
    }

    public void setFirstColumnMarked(boolean firstColumnMarked) {
        this.firstColumnMarked = firstColumnMarked;
    }

    public void setLastColumnRPr(RPr lastColumnRPr) {
        this.lastColumnRPr = lastColumnRPr;
    }

    public void setLastColumnMarked(boolean lastColumnMarked) {
        this.lastColumnMarked = lastColumnMarked;
    }

    public void setFirstRowRPr(RPr firstRowRPr) {
        this.firstRowRPr = firstRowRPr;
    }

    public void setFirstRowMarked(boolean firstRowMarked) {
        this.firstRowMarked = firstRowMarked;
    }

    public void setLastRowRPr(RPr lastRowRPr) {
        this.lastRowRPr = lastRowRPr;
    }

    public void setLastRowMarked(boolean lastRowMarked) {
        this.lastRowMarked = lastRowMarked;
    }

    public TableStyle() {
    }

    @ConstructorProperties(value={"firstColumnRPr", "firstColumnMarked", "lastColumnRPr", "lastColumnMarked", "firstRowRPr", "firstRowMarked", "lastRowRPr", "lastRowMarked"})
    public TableStyle(RPr firstColumnRPr, boolean firstColumnMarked, RPr lastColumnRPr, boolean lastColumnMarked, RPr firstRowRPr, boolean firstRowMarked, RPr lastRowRPr, boolean lastRowMarked) {
        this.firstColumnRPr = firstColumnRPr;
        this.firstColumnMarked = firstColumnMarked;
        this.lastColumnRPr = lastColumnRPr;
        this.lastColumnMarked = lastColumnMarked;
        this.firstRowRPr = firstRowRPr;
        this.firstRowMarked = firstRowMarked;
        this.lastRowRPr = lastRowRPr;
        this.lastRowMarked = lastRowMarked;
    }
}

