/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.notifications.NotificationDefTable;
import com.plusmpm.database.notifications.NotificationProcActTable;
import com.plusmpm.database.notifications.NotificationRecipientTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportNotifications
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportNotifications.class);

    @AdvancedTask(name="ImportNotificationsFromXLS", description="ImportNotificationsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportNotificationsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportNotificationsFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        PositionFinder ps = FinderFactory.getPositionFinder();
        boolean bContinue = true;
        String procDefId = "";
        String helpNotificationName = "";
        String helpProcessName = "";
        long notificationId = -1L;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Powiadomienia");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Powiadomienia w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 12; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z powiadomieniami");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                    String notificationName = sheet.getCell(((Integer)header.get("Nazwa powiadomienia")).intValue(), i).getContents();
                    String notificationSubject = sheet.getCell(((Integer)header.get("Temat")).intValue(), i).getContents();
                    String notificationTemplatePath = sheet.getCell(((Integer)header.get("\u015acie\u017cka szablonu")).intValue(), i).getContents();
                    String notificationCondType = sheet.getCell(((Integer)header.get("Typ warunku wys\u0142ania")).intValue(), i).getContents();
                    String notificationCondVal = sheet.getCell(((Integer)header.get("Warto\u015b\u0107 warunku wys\u0142ania")).intValue(), i).getContents();
                    String notificationCondVar = sheet.getCell(((Integer)header.get("Zmienna")).intValue(), i).getContents();
                    String recipientPerformer = sheet.getCell(((Integer)header.get("Tylko w\u0142asne zadania")).intValue(), i).getContents();
                    String dontSendOnWeekendsImportValue = sheet.getCell(((Integer)header.get("Nie wysy\u0142aj w weekendy")).intValue(), i).getContents();
                    String dontSendOnHolidaysAndDaysOffImportValue = sheet.getCell(((Integer)header.get("Nie wysy\u0142aj w \u015bwi\u0119ta i dni wolne")).intValue(), i).getContents();
                    String recipientType = sheet.getCell(((Integer)header.get("Typ odbiorcy")).intValue(), i).getContents();
                    String recipientValue = sheet.getCell(((Integer)header.get("Odbiorca")).intValue(), i).getContents();
                    String recipientExcluded = sheet.getCell(((Integer)header.get("Wykluczony")).intValue(), i).getContents();
                    String activityName = sheet.getCell(((Integer)header.get("Nazwa zadania")).intValue(), i).getContents();
                    String activityDefId = "";
                    if (!Tools.isNullOrEmpty((String)processName)) {
                        notificationId = -1L;
                        if (Tools.isNullOrEmpty((String)notificationName)) {
                            bContinue = false;
                            throw new CUFException("Brak nazwy powiadomienia");
                        }
                        helpNotificationName = notificationName;
                        if (Tools.isNullOrEmpty((String)notificationSubject)) {
                            bContinue = false;
                            throw new CUFException("Brak tematu powiadomienia o nazwie " + notificationName);
                        }
                        if (Tools.isNullOrEmpty((String)notificationTemplatePath)) {
                            bContinue = false;
                            throw new CUFException("Brak sciezki do szablonu powiadomienia o nazwie " + notificationName);
                        }
                        if (Tools.isNullOrEmpty((String)notificationCondType)) {
                            bContinue = false;
                            throw new CUFException("Brak typu warunku wys\u0142ania dla powiadomienia o nazwie " + notificationName);
                        }
                        if (notificationCondType.equalsIgnoreCase("Utworzenie")) {
                            notificationCondType = "create";
                        } else if (notificationCondType.equalsIgnoreCase("Zako\u0144czenie")) {
                            notificationCondType = "end";
                        } else if (notificationCondType.equalsIgnoreCase("Przekroczenie terminu")) {
                            notificationCondType = "deadline";
                        } else if (notificationCondType.equalsIgnoreCase("create") || notificationCondType.equalsIgnoreCase("end") || notificationCondType.equalsIgnoreCase("deadline")) {
                            notificationCondType.toLowerCase();
                        } else {
                            throw new CUFException("Nieznany typ warunku wyslania dla powiadomienia o nazwie " + notificationName);
                        }
                        procDefId = CUFTools.getProcDefIdForProcessName(processName);
                        if (Tools.isNullOrEmpty((String)procDefId)) {
                            bContinue = false;
                            throw new CUFException("W systemie nie istnieje proces o nazwie " + processName);
                        }
                        helpProcessName = processName;
                        if (CUFTools.doesNotificationDefExist(procDefId, notificationName)) {
                            bContinue = false;
                            throw new CUFException("Powiadomienie o nazwie " + notificationName + " istnieje juz dla procesu " + processName);
                        }
                        if (notificationCondVar.equalsIgnoreCase("")) {
                            notificationCondVar = null;
                        }
                        NotificationDefTable notificationDefTable = new NotificationDefTable();
                        notificationDefTable.setName(notificationName);
                        notificationDefTable.setSubject(notificationSubject);
                        notificationDefTable.setTemplatePath(notificationTemplatePath);
                        notificationDefTable.setConditionType(notificationCondType);
                        notificationDefTable.setConditionVarName(notificationCondVar);
                        notificationDefTable.setConditionVal(notificationCondVal);
                        notificationDefTable.setRecipientPerformer(Boolean.valueOf(this.getCheckBoxValueFromImport(recipientPerformer)));
                        notificationDefTable.setDontSendOnWeekends(Boolean.valueOf(this.getCheckBoxValueFromImport(dontSendOnWeekendsImportValue)));
                        notificationDefTable.setDontSendOnHolidaysAndDaysOff(Boolean.valueOf(this.getCheckBoxValueFromImport(dontSendOnHolidaysAndDaysOffImportValue)));
                        notificationId = dbm.addNotificationDef(notificationDefTable);
                        if (notificationId == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania do systemu powiadomienia o nazwie " + notificationName + " dla procesu o nazwie " + processName);
                        }
                        bContinue = true;
                        log.info((Object)("Poprawnie dodano do systemu powiadomienie o nazwie " + notificationName + " dla procesu o nazwie " + processName));
                    }
                    if (!bContinue) continue;
                    try {
                        long id;
                        if (!Tools.isNullOrEmpty((String)recipientType)) {
                            if (recipientType.equalsIgnoreCase("U\u017cytkownik")) {
                                recipientType = "user";
                            } else if (recipientType.equalsIgnoreCase("Grupa")) {
                                recipientType = "group";
                            } else if (recipientType.equalsIgnoreCase("Stanowisko")) {
                                recipientType = "position";
                            } else if (recipientType.equalsIgnoreCase("Prze\u0142o\u017cony")) {
                                recipientType = "participanthigherposition";
                            } else if (recipientType.equalsIgnoreCase("Wykonawca")) {
                                recipientType = "participant";
                            } else if (recipientType.equalsIgnoreCase("user") || recipientType.equalsIgnoreCase("group") || recipientType.equalsIgnoreCase("position") || recipientType.equalsIgnoreCase("participanthigherposition") || recipientType.equalsIgnoreCase("participant")) {
                                recipientType.toLowerCase();
                            } else {
                                throw new CUFException("Nieznany typ odbiorcy powiadomienia o nazwie " + helpNotificationName);
                            }
                            if (recipientType.equalsIgnoreCase("participant")) {
                                recipientValue = "";
                            } else if (Tools.isNullOrEmpty((String)recipientValue)) {
                                throw new CUFException("Brak odbiorcy powiadomienia o nazwie " + helpNotificationName);
                            }
                            if (recipientType.equalsIgnoreCase("user")) {
                                if (!uga.doesUserExist(recipientValue)) {
                                    throw new CUFException("Odbiorca " + recipientValue + " typu U\u017cytkownik powiadomienia o nazwie " + helpNotificationName + " nie istnieje w systemie");
                                }
                            } else if (recipientType.equalsIgnoreCase("group")) {
                                if (!uga.doesGroupExist(recipientValue)) {
                                    throw new CUFException("Odbiorca " + recipientValue + " typu Grupa powiadomienia o nazwie " + helpNotificationName + " nie istnieje w systemie");
                                }
                            } else if (recipientType.equalsIgnoreCase("position")) {
                                List allPositions = ps.getAll(new String[0]);
                                boolean bFound = false;
                                for (Position position : allPositions) {
                                    if (position == null) continue;
                                    String thisPositionName = position.getName();
                                    String thisPositionSymbol = position.getSymbol();
                                    if ((thisPositionName == null || !thisPositionName.equals(recipientValue)) && (thisPositionSymbol == null || !thisPositionSymbol.equals(recipientValue))) continue;
                                    bFound = true;
                                    break;
                                }
                                if (!bFound) {
                                    throw new CUFException("Odbiorca " + recipientValue + " typu Stanowisko powiadomienia o nazwie " + helpNotificationName + " nie istnieje w systemie");
                                }
                            }
                            if (CUFTools.doesNotificationRecipientExist(String.valueOf(notificationId), recipientType, recipientValue)) {
                                throw new CUFException("Odbiorca powiadomienia o nazwie " + helpNotificationName + " istnieje juz dla tego powiadomienia");
                            }
                            recipientExcluded = recipientExcluded != null && (recipientExcluded.equalsIgnoreCase("tak") || recipientExcluded.equalsIgnoreCase("true")) ? "true" : "false";
                            NotificationRecipientTable notificationRecipientTable = new NotificationRecipientTable(String.valueOf(notificationId), recipientType, recipientValue, recipientExcluded);
                            id = dbm.addNotificationRecipient(notificationRecipientTable);
                            if (id == -1L) {
                                throw new CUFException("Blad podczas dodawania do systemu odbiorcy " + recipientValue + " dla powiadomienia o nazwie " + helpNotificationName);
                            }
                            log.info((Object)("Poprawnie dodano do systemu odbiorce " + recipientValue + " dla powiadomienia o nazwie " + helpNotificationName));
                        }
                        if (Tools.isNullOrEmpty((String)activityName)) continue;
                        if (Tools.isNullOrEmpty((String)(activityDefId = activityDefId != null && activityDefId.equalsIgnoreCase("brak") ? "" : CUFTools.getActDefIdForActivityName(procDefId, activityName)))) {
                            throw new CUFException("Zadanie o nazwie " + activityName + " nie istnieje w procesie o nazwie " + helpProcessName);
                        }
                        if (CUFTools.doesNotificationActivityExist(String.valueOf(notificationId), activityDefId)) {
                            throw new CUFException("Zadanie o nazwie " + activityName + " istnieje juz dla powiadomienia " + helpNotificationName);
                        }
                        NotificationProcActTable notificationProcActTable = new NotificationProcActTable();
                        notificationProcActTable.setActivityDefId(activityDefId);
                        notificationProcActTable.setProcessDefId(procDefId);
                        notificationProcActTable.setNotificationDefId(String.valueOf(notificationId));
                        id = dbm.addNotificationProcAct(notificationProcActTable);
                        if (id == -1L) {
                            throw new CUFException("Blad podczas dodawania do systemu zadania " + activityName + " dla powiadomienia " + helpNotificationName);
                        }
                        log.info((Object)("Poprawnie dodano do systemu zadanie " + activityName + " dla powiadomienia " + helpNotificationName));
                    }
                    catch (CUFException e) {
                        log.warn((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import powiadomien");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportNotificationsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private boolean getCheckBoxValueFromImport(String importValue) {
        return importValue != null && (importValue.equalsIgnoreCase("tak") || importValue.equalsIgnoreCase("true"));
    }
}

