/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.suncode.pwfl.administration.configuration.CustomHolidaysHelper;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HolidaysFunctions {
    public static Logger log = Logger.getLogger(HolidaysFunctions.class);
    private static final long ONE_HOUR = 3600000L;

    public static Calendar getDateWithoutHolidays(Calendar d1, int daysCount) {
        log.trace((Object)("************************* getDateWithoutHolidays(Calendar, daysCount=" + String.valueOf(daysCount) + ") ********************"));
        Calendar date = d1;
        int licznik = 0;
        String sFreedays = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HOLIDAY_FUNCTIONS_ADDITIONAL_FREEDAYS);
        String[] freedays = null;
        if (sFreedays != null && sFreedays.compareTo("") != 0) {
            freedays = sFreedays.split(";");
        }
        while (licznik < daysCount) {
            if (HolidaysFunctions.checkHoliday(date, freedays) < 0) {
                ++licznik;
            }
            if (licznik == daysCount) continue;
            date.add(5, 1);
        }
        return date;
    }

    public static long daysBetween(Date d1, Date d2) {
        log.trace((Object)"************************* daysBetween(Date, Date) ********************");
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        long count = 0L;
        if (t2 >= t1) {
            count = (t2 - t1 + 3600000L) / 86400000L + 1L;
        }
        return count;
    }

    public static long daysBetweenWithoutHolidaysWithWorkdays(Calendar d1, Calendar d2) {
        String sWorkDays = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HOLIDAY_FUNCTIONS_WORKDAYS);
        String[] workDays = null;
        workDays = StringUtils.isNotBlank((String)sWorkDays) ? sWorkDays.split(";") : new String[]{};
        return HolidaysFunctions.daysBetweenWithoutHolidays(d1, d2, workDays);
    }

    public static long daysBetweenWithoutHolidays(Calendar d1, Calendar d2) {
        return HolidaysFunctions.daysBetweenWithoutHolidays(d1, d2, new String[0]);
    }

    private static long daysBetweenWithoutHolidays(Calendar d1, Calendar d2, String[] workDays) {
        log.trace((Object)"************************* daysBetweenWithoutHolidays(Calendar, Calendar) ********************");
        long lDaysWithoutHolidays = 0L;
        try {
            long lAllDaysCount = HolidaysFunctions.daysBetween(d1.getTime(), d2.getTime());
            String sFreedays = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HOLIDAY_FUNCTIONS_ADDITIONAL_FREEDAYS);
            String[] freedays = null;
            if (sFreedays != null && sFreedays.compareTo("") != 0) {
                freedays = sFreedays.split(";");
            }
            int i = 0;
            while ((long)i < lAllDaysCount) {
                int status = HolidaysFunctions.checkHoliday(d1, freedays, workDays);
                if (status < 0) {
                    ++lDaysWithoutHolidays;
                }
                d1.add(5, 1);
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lDaysWithoutHolidays;
    }

    private static int checkHoliday(Calendar d1, String[] extraFreeDays, String[] workDays) {
        log.trace((Object)"************************* checkHoliday(Calendar, String[]) ********************");
        try {
            if (HolidaysFunctions.isWorkDay(d1, workDays)) {
                return -1;
            }
            int weekDay = d1.get(7);
            if (weekDay == 7) {
                return 0;
            }
            if (weekDay == 1) {
                return 1;
            }
            int year = d1.get(1);
            HashMap<String, Calendar> swieta = HolidaysFunctions.getHoliday(year);
            if (swieta != null) {
                if (HolidaysFunctions.isSameDay(d1, swieta.get("Wielkanoc"))) {
                    return 2;
                }
                if (HolidaysFunctions.isSameDay(d1, swieta.get("Lany Poniedzia\u0142ek"))) {
                    return 3;
                }
                if (HolidaysFunctions.isSameDay(d1, swieta.get("Zes\u0142anie Ducha \u015awi\u0119tego"))) {
                    return 4;
                }
                if (HolidaysFunctions.isSameDay(d1, swieta.get("Bo\u017ce Cia\u0142o"))) {
                    return 5;
                }
                int m = d1.get(2);
                int d = d1.get(5);
                if (m == 0 && d == 1) {
                    return 6;
                }
                if (m == 0 && d == 6) {
                    return 14;
                }
                if (m == 4 && d == 1) {
                    return 7;
                }
                if (m == 4 && d == 3) {
                    return 8;
                }
                if (m == 7 && d == 15) {
                    return 9;
                }
                if (m == 10 && d == 1) {
                    return 10;
                }
                if (m == 10 && d == 11) {
                    return 11;
                }
                if (m == 11 && d == 25) {
                    return 12;
                }
                if (m == 11 && d == 26) {
                    return 13;
                }
                try {
                    if (extraFreeDays != null && extraFreeDays.length != 0) {
                        for (int i = 0; i < extraFreeDays.length; ++i) {
                            int mt = 0;
                            int dt = 0;
                            String[] m_d = extraFreeDays[i].split("-");
                            if (m_d.length == 2) {
                                mt = Integer.valueOf(m_d[0]) - 1;
                                dt = Integer.valueOf(m_d[1]);
                            }
                            if (m != mt || d != dt) continue;
                            return 15;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d podczas analizy dodatkowych dni wolnych", (Throwable)e);
                }
                return -1;
            }
            return -1;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private static boolean isWorkDay(Calendar d1, String[] workDays) {
        int date = d1.get(5);
        int month = d1.get(2) + 1;
        for (String workDay : workDays) {
            String[] split = workDay.split("-");
            if (split.length != 2) continue;
            int m = Integer.valueOf(split[0]);
            int d = Integer.valueOf(split[1]);
            if (date != d || month != m) continue;
            return true;
        }
        return false;
    }

    public static int checkHoliday(Calendar d1, String[] extraFreeDays) {
        return HolidaysFunctions.checkHoliday(d1, extraFreeDays, new String[0]);
    }

    public static HashMap<String, Calendar> getHoliday(int year) {
        log.trace((Object)("************************* getHoliday(year=" + String.valueOf(year) + ") ********************"));
        if (!CustomHolidaysHelper.areEasterBasedHolidaysSetStatic()) {
            return new HashMap<String, Calendar>();
        }
        try {
            HashMap<String, Calendar> swieta = new HashMap<String, Calendar>();
            double yearFloor = Math.floor(year);
            int czy = 0;
            if (yearFloor % 4.0 == 0.0) {
                czy = 1;
            }
            if (yearFloor % 100.0 == 0.0) {
                czy = 0;
            }
            if (yearFloor % 400.0 == 0.0) {
                czy = 1;
            }
            double a = (double)year - 19.0 * Math.floor(year / 19);
            double b = Math.floor(year / 100);
            double c = (double)year - 100.0 * b;
            double d = Math.floor(b / 4.0);
            double e = b - 4.0 * d;
            double f = Math.floor((b + 8.0) / 25.0);
            double g = Math.floor((b - f + 1.0) / 3.0);
            double h = 19.0 * a + b - d - g + 15.0 - 30.0 * Math.floor((19.0 * a + b - d - g + 15.0) / 30.0);
            double j = Math.floor(c / 4.0);
            double k = c - 4.0 * j;
            double s = 32.0 + 2.0 * e + 2.0 * j - h - k - 7.0 * Math.floor((32.0 + 2.0 * e + 2.0 * j - h - k) / 7.0);
            double u = Math.floor((a + 11.0 * h + 22.0 * s) / 451.0);
            double xx = Math.floor((h + s - 7.0 * u + 114.0) / 31.0);
            double yy = h + s - 7.0 * u + 114.0 - 31.0 * xx;
            double nrd = -34.0 + 31.0 * xx + yy + 1.0 + (double)czy;
            swieta.put("T\u0142usty czwartek", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 52, year));
            swieta.put("Ostatnia sobota karnawa\u0142u", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 50, year));
            swieta.put("Ostatki", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 47, year));
            swieta.put("Popielec", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 46, year));
            swieta.put("Niedziela Palmowa", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 7, year));
            swieta.put("Wielki Czwartek", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 3, year));
            swieta.put("Wielki Pi\u0105tek", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 2, year));
            swieta.put("Wielka Sobota", HolidaysFunctions.getHolidayDate(czy, (int)nrd - 1, year));
            swieta.put("Wielkanoc", HolidaysFunctions.getHolidayDate(czy, (int)nrd, year));
            swieta.put("Lany Poniedzia\u0142ek", HolidaysFunctions.getHolidayDate(czy, (int)nrd + 1, year));
            swieta.put("Wniebowst\u0105pienie", HolidaysFunctions.getHolidayDate(czy, (int)nrd + 39, year));
            swieta.put("Zes\u0142anie Ducha \u015awi\u0119tego", HolidaysFunctions.getHolidayDate(czy, (int)nrd + 49, year));
            swieta.put("Bo\u017ce Cia\u0142o", HolidaysFunctions.getHolidayDate(czy, (int)nrd + 60, year));
            return swieta;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Calendar getHolidayDate(int pr, int kt, int year) {
        log.trace((Object)("************************* getHolidayDate(pr=" + String.valueOf(pr) + ", kt=" + String.valueOf(kt) + ", year=" + String.valueOf(year) + ") ********************"));
        try {
            int month = 0;
            int date = kt;
            if (kt > 31) {
                date = kt - 31;
                month = 1;
            }
            if (kt > 59 + pr) {
                date = kt - 59 - pr;
                month = 2;
            }
            if (kt > 90 + pr) {
                date = kt - 90 - pr;
                month = 3;
            }
            if (kt > 120 + pr) {
                date = kt - 120 - pr;
                month = 4;
            }
            if (kt > 151 + pr) {
                date = kt - 151 - pr;
                month = 5;
            }
            GregorianCalendar cal = new GregorianCalendar(year, month, date);
            year = cal.get(1);
            month = cal.get(2);
            date = cal.get(5);
            return cal;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        log.trace((Object)"************************* isSameDay(Calendar, Calendar) ********************");
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        int e1 = cal1.get(0);
        int y1 = cal1.get(1);
        int d1 = cal1.get(6);
        int e2 = cal2.get(0);
        int y2 = cal2.get(1);
        int d2 = cal2.get(6);
        return e1 == e2 && y1 == y2 && d1 == d2;
    }
}

