/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.template;

import com.plusmpm.util.form.tool.StandardTool;
import com.plusmpm.util.form.tool.StandardToolParameter;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.cuf.util.CufServiceFactory;
import com.suncode.cuf.util.TemporaryFile;
import com.suncode.cuf.util.template.WordTemplateUtil;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.enhydra.shark.api.internal.toolagent.AppParameter;

@StandardTool(id="word_template_task", name="Generowanie metryczki z szablonu", category="Dokumenty", description="Zadanie s\u0142u\u017cy do generowania metryczki z szablonu .docx", icon="img/tool.png", type=StandardTool.Type.JAVA_APPLICATION)
public class WordTemplateTask {
    private static WordTemplateService wordTemplateService = CufServiceFactory.getWordTemplateService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(@StandardToolParameter(id="processId", description="Identyfikator procesu", mode=StandardToolParameter.Mode.IN) AppParameter processId, @StandardToolParameter(id="activityId", description="Identyfikator zadania", mode=StandardToolParameter.Mode.IN) AppParameter activityId, @StandardToolParameter(id="documentClass", description="Nazwa klasy dokument\u00f3w, do ktorej ma zostac dodany dokument", mode=StandardToolParameter.Mode.IN) AppParameter docClassName, @StandardToolParameter(id="template", description="Nazwa szablonu dla generowanej metryczki", mode=StandardToolParameter.Mode.IN) AppParameter templateName, @StandardToolParameter(id="pdf", description="Okre\u015bla czy dokumkent ma zosta\u0107 zapisany z rozszerzeniem .PDF", mode=StandardToolParameter.Mode.IN) AppParameter pdf, @StandardToolParameter(id="addToProces", description="Okre\u015bla czy dodawa\u0107 dokument do procesu", mode=StandardToolParameter.Mode.IN) AppParameter addToProcess, @StandardToolParameter(id="saveAsNewVersion", description="Okre\u015bla czy nadpisa\u0107 plik jako nowa wersja", mode=StandardToolParameter.Mode.IN) AppParameter newVersion) throws Exception {
        String template = (String)templateName.the_value;
        String process = (String)processId.the_value;
        String activity = (String)activityId.the_value;
        String docClass = (String)docClassName.the_value;
        boolean saveAsPDF = WordTemplateTask.asBoolean(pdf);
        boolean attachToProces = WordTemplateTask.asBoolean(addToProcess);
        boolean saveAsNewVersion = WordTemplateTask.asBoolean(newVersion);
        WordTemplateService.OutputFormat format = saveAsPDF ? WordTemplateService.OutputFormat.PDF : WordTemplateService.OutputFormat.DOCX;
        File output = TemporaryFile.create(template + "_" + process + "_", "." + format.toString().toLowerCase());
        try {
            wordTemplateService.generateForActivity(output, template, process, activity, format);
            WordTemplateUtil.archiveAndAttachToProcess(output, process, activity, docClass, template, format, attachToProces, saveAsNewVersion);
        }
        finally {
            FileUtils.deleteQuietly((File)output);
        }
    }

    private static boolean asBoolean(AppParameter param) {
        return Boolean.valueOf((String)param.the_value);
    }
}

