/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.hibernate;

import com.suncode.cuf.hibernate.exception.SessionFactoryAlreadyExist;
import com.suncode.cuf.hibernate.exception.SessionFactoryNotFound;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;

public class SessionFactoryHolder {
    private Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();
    private static SessionFactoryHolder sessionFactoryHolder;

    private SessionFactoryHolder() {
    }

    public static SessionFactoryHolder getInstance() {
        if (sessionFactoryHolder == null) {
            sessionFactoryHolder = new SessionFactoryHolder();
        }
        return sessionFactoryHolder;
    }

    public void add(String name, SessionFactory sf) {
        if (this.sessionFactories.containsKey(name)) {
            throw new SessionFactoryAlreadyExist(name);
        }
        this.sessionFactories.put(name, sf);
    }

    public SessionFactory get(String name) {
        return this.sessionFactories.get(name);
    }

    public void remove(String name) {
        if (!this.sessionFactories.containsKey(name)) {
            throw new SessionFactoryNotFound(name);
        }
        SessionFactory sf = this.sessionFactories.get(name);
        sf.close();
        this.sessionFactories.remove(name);
    }

    public void removeAll() {
        for (SessionFactory sf : this.sessionFactories.values()) {
            sf.close();
        }
        this.sessionFactories.clear();
    }

    public boolean contains(String name) {
        return this.sessionFactories.containsKey(name);
    }
}

