/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.form.datachooser.internal;

import com.google.common.collect.Sets;
import com.suncode.cuf.form.datachooser.internal.filter.CriteriaFilter;
import com.suncode.cuf.form.datachooser.internal.filter.CriteriaFilterHolder;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitNotFoundException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.exception.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCriteria {
    private static final Logger log = LoggerFactory.getLogger(UserCriteria.class);
    Set<String> groups = new HashSet<String>();
    Set<String> excludedGroups = new HashSet<String>();
    Set<String> excludedUsers = new HashSet<String>();
    Set<Long> roles = new HashSet<Long>();
    Set<String> ouSymbols = new HashSet<String>();
    boolean subOrgUnits = false;
    Set<String> filterBy = new HashSet<String>();
    List<String> sortBy = new ArrayList<String>();
    boolean joinOrgUnits = false;
    boolean joinSuperiors = false;
    boolean filterWords = false;
    final String suffix = "Var";
    private final String separator = ";";
    String query;
    private String[] availableSortFields = new String[]{"userName", "firstName", "lastName", "fullName", "reverseName", "firstLastNameAllWords"};
    private String[] availableFilterFields = this.availableSortFields;

    UserCriteria() {
    }

    public UserCriteria(Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        Map<String, String> props = this.convertProps(mCriteria, mCustomKeys);
        this.query = mCriteria.get("GetDataChooserContentServlet_parameter_query");
        this.setFieldValues(props);
    }

    void setFieldValues(Map<String, String> props) {
        this.readSet(this.groups, props, "groups");
        this.readSet(this.excludedGroups, props, "excludedGroups");
        this.readSet(this.excludedUsers, props, "excludedUsers");
        this.readSet(this.ouSymbols, props, "ouSymbols");
        this.readSet(this.filterBy, props, "filterBy", "fullName");
        this.readSet(this.sortBy, props, "sortBy", "");
        this.readRoleSet(this.roles, props);
        this.subOrgUnits = this.readBoolean(props.get("subOrgUnits"));
        this.joinSuperiors = this.readBoolean(props.get("joinSuperiors"));
        this.joinOrgUnits = this.readBoolean(props.get("joinOrgUnits"));
        this.filterWords = this.readBoolean(props.get("filterWords"));
        this.addSubOus();
        this.validateFilters();
    }

    void validateFilters() {
        for (String field : this.filterBy) {
            if (Arrays.asList(this.availableFilterFields).contains(field)) continue;
            throw new IllegalArgumentException("Nieprawid\u0142owe pole filtrowania: " + field);
        }
    }

    void addSubOus() {
        if (this.subOrgUnits) {
            HashSet ouAndSubOus = Sets.newHashSet();
            for (String ouSym : this.ouSymbols) {
                OrganizationalUnit ou = FinderFactory.getOrganizationalUnitFinder().findBySymbol(ouSym, new String[0]);
                if (ou == null) {
                    throw new IllegalArgumentException("Nie znaleziono jednostki o symbolu: " + ouSym);
                }
                try {
                    List list = FinderFactory.getOrganizationalUnitFinder().getSubOrganizationalUnits(ou.getId());
                    log.info("Znaleziono " + list.size() + " jednostki podrz\u0119dne dla jednostki: " + ouSym);
                    for (OrganizationalUnit organizationalUnit : list) {
                        log.info("Dodaje jednostk\u0119: " + organizationalUnit.getSymbol());
                        ouAndSubOus.add(organizationalUnit.getSymbol());
                    }
                }
                catch (OrganizationalUnitNotFoundException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            this.ouSymbols.addAll(ouAndSubOus);
        }
    }

    boolean readBoolean(String val) {
        return StringUtils.isNotBlank((String)val) && val.equals("true");
    }

    void readRoleSet(Set<Long> set, Map<String, String> props) {
        String[] split;
        String val = props.get("roles");
        if (StringUtils.isBlank((String)val)) {
            return;
        }
        for (String roleId : split = val.split(";")) {
            String[] rid = roleId.split(":");
            this.validateRoleId(rid, roleId);
            Role r = ServiceFactory.getRoleService().getRole(rid[0], rid[1], rid[2]);
            if (r == null) {
                throw new IllegalArgumentException("Nie znaleziono roli o id: " + roleId);
            }
            set.add(r.getId());
        }
    }

    void validateRoleId(String[] rid, String roleId) {
        if (rid.length != 3) {
            throw new IllegalArgumentException("Nieprawid\u0142owy format id roli: " + roleId);
        }
    }

    void readSet(Collection<String> set, Map<String, String> props, String key) {
        this.readSet(set, props, key, null);
    }

    void readSet(Collection<String> set, Map<String, String> props, String key, String defaultValue) {
        String val;
        if (!props.containsKey(key) && StringUtils.isNotBlank((String)defaultValue)) {
            set.add(defaultValue);
        }
        if (StringUtils.isBlank((String)(val = props.get(key)))) {
            return;
        }
        String[] split = val.split(";");
        set.addAll(Arrays.asList(split));
    }

    Map<String, String> convertProps(Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : mCustomKeys.keySet()) {
            if (key.endsWith("Var")) {
                String varId = mCustomKeys.get(key);
                map.put(this.removeSuffix(key), this.getVarValue(mCriteria, varId));
                continue;
            }
            String value = mCustomKeys.get(key);
            map.put(key, value);
        }
        return map;
    }

    String getVarValue(Map<String, String> mCriteria, String varId) {
        this.validateCriteria(mCriteria, varId);
        return mCriteria.get(varId);
    }

    void validateCriteria(Map<String, String> mCriteria, String varId) {
        if (!mCriteria.containsKey(varId)) {
            throw new IllegalArgumentException("Brak zmiennej " + varId + " w formCriteria. DataChooser nie mo\u017ce odczyta\u0107 warto\u015bci zmiennej.");
        }
    }

    String removeSuffix(String key) {
        return key.substring(0, key.length() - "Var".length());
    }

    public DetachedCriteria buildCriteria(Sorter sorter) {
        ArrayList<Sorter> sorters = new ArrayList<Sorter>();
        if (sorter != null) {
            sorters.add(sorter);
        }
        return this.buildCriteria(sorters);
    }

    public DetachedCriteria buildCriteria(List<Sorter> sorters) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        this.buildCriteria(dc);
        this.buildOrder(dc, sorters);
        return dc;
    }

    public DetachedCriteria buildCriteria() {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        this.buildCriteria(dc);
        return dc;
    }

    public void buildCriteria(DetachedCriteria dc) {
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.buildGroupCriteria(dc);
        this.buildPositionCriteria(dc);
        this.buildUserCriteria(dc);
        this.buildFilters(dc);
    }

    private void buildUserCriteria(DetachedCriteria dc) {
        if (!CollectionUtils.isEmpty(this.excludedUsers)) {
            dc.add(Restrictions.not((Criterion)Restrictions.in((String)"userName", this.excludedUsers)));
        }
    }

    private void buildPositionCriteria(DetachedCriteria dc) {
        if (!CollectionUtils.isEmpty(this.roles) || !CollectionUtils.isEmpty(this.ouSymbols)) {
            dc.createAlias("positions", "positions", JoinType.LEFT_OUTER_JOIN);
        }
        if (!CollectionUtils.isEmpty(this.ouSymbols)) {
            dc.createAlias("positions.organizationalUnit", "orgUnits", JoinType.LEFT_OUTER_JOIN);
        }
        if (!CollectionUtils.isEmpty(this.roles)) {
            dc.createAlias("positions.roles", "roles", JoinType.LEFT_OUTER_JOIN);
        }
        if (!CollectionUtils.isEmpty(this.roles)) {
            dc.add(Restrictions.in((String)"roles.id", this.roles));
        }
        if (!CollectionUtils.isEmpty(this.ouSymbols)) {
            dc.add(Restrictions.in((String)"orgUnits.symbol", this.ouSymbols));
        }
    }

    private void buildGroupCriteria(DetachedCriteria dc) {
        if (!CollectionUtils.isEmpty(this.excludedGroups) || !CollectionUtils.isEmpty(this.groups)) {
            dc.createAlias("groups", "groups", JoinType.LEFT_OUTER_JOIN);
        }
        if (!CollectionUtils.isEmpty(this.excludedGroups)) {
            dc.add(Restrictions.not((Criterion)Restrictions.in((String)"groups.name", this.excludedGroups)));
        }
        if (!CollectionUtils.isEmpty(this.groups)) {
            dc.add(Restrictions.in((String)"groups.name", this.groups));
        }
    }

    void buildOrder(DetachedCriteria dc, Sorter dcSorter) {
        ArrayList<Sorter> sorters = new ArrayList<Sorter>();
        if (dcSorter != null) {
            sorters.add(dcSorter);
        }
        this.buildOrder(dc, sorters);
    }

    void buildOrder(DetachedCriteria dc, List<Sorter> dcSorters) {
        List<Sorter> sorters = this.buildSorters();
        if (sorters.isEmpty() && CollectionUtils.isNotEmpty(dcSorters)) {
            sorters.addAll(dcSorters);
        }
        for (Sorter sorter : sorters) {
            if (sorter.getDirection() == SortDirection.ASC) {
                dc.addOrder(Order.asc((String)sorter.getProperty()));
                continue;
            }
            dc.addOrder(Order.desc((String)sorter.getProperty()));
        }
    }

    List<Sorter> buildSorters() {
        ArrayList<Sorter> sorters = new ArrayList<Sorter>();
        for (String sort : this.sortBy) {
            String[] split = sort.split(":");
            this.validateSort(split, sort);
            sorters.add(new Sorter(split[0], SortDirection.valueOf((String)split[1].toUpperCase())));
        }
        return sorters;
    }

    void validateSort(String[] split, String sort) {
        if (split.length != 2) {
            throw new IllegalArgumentException("Nieprawid\u0142owy format sortowania: " + sort);
        }
        if (!Arrays.asList(this.availableSortFields).contains(split[0])) {
            throw new IllegalArgumentException("Nieprawid\u0142owe pole sortowania: " + split[0]);
        }
        if (!split[1].equalsIgnoreCase("asc") && !split[1].equalsIgnoreCase("desc")) {
            throw new IllegalArgumentException("Nieprawid\u0142owe kierunek sortowania: " + split[1]);
        }
    }

    void buildFilters(DetachedCriteria dc) {
        if (StringUtils.isBlank((String)this.query) || this.filterBy.isEmpty()) {
            return;
        }
        Disjunction or = Restrictions.disjunction();
        for (String field : this.filterBy) {
            CriteriaFilter cf = CriteriaFilterHolder.getFilter("user." + field);
            if (this.filterWords) {
                for (String value : this.query.split(" ")) {
                    cf.addFilter((Junction)or, value, field);
                }
                continue;
            }
            cf.addFilter((Junction)or, this.query, field);
        }
        dc.add((Criterion)or);
    }

    public boolean isJoinOrgUnits() {
        return this.joinOrgUnits;
    }

    public boolean isJoinSuperiors() {
        return this.joinSuperiors;
    }
}

