/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.files.FileVersionsAccess;
import com.plusmpm.database.files.Files;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class GetDocumentsAttachedToProcess
extends HttpServlet {
    public static Logger log = Logger.getLogger(GetDocumentsAttachedToProcess.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* GetDocumentsAttachedToProcess Servlet ****************************");
        PrintWriter printWriter = null;
        JSONObject JSONDocIds = null;
        boolean bSuccess = false;
        String answerMessage = "";
        String docIds = "";
        String newDocIds = "";
        FileVersionsAccess fva = null;
        HibernateTemplate ht = null;
        Map activityContextMap = null;
        try {
            Object o;
            String sProcessId = request.getParameter("sProcessId");
            String sActivityId = request.getParameter("sActivityId");
            if (Tools.isNullOrEmpty((String)sProcessId) || Tools.isNullOrEmpty((String)sActivityId)) {
                throw new CUFException("Brak informacji o identyfikatrze procesu lub zadania.");
            }
            activityContextMap = SharkClientFunctions.getActivityContextMap(sProcessId, sActivityId);
            if (activityContextMap != null && activityContextMap.size() > 0 && (o = activityContextMap.get("DocIds")) != null) {
                String[] docIdsSplit;
                ht = new HibernateTemplate();
                fva = new FileVersionsAccess();
                docIds = o.toString();
                for (String fileId : docIdsSplit = docIds.split(",")) {
                    if (Tools.isNullOrEmpty((String)fileId)) continue;
                    Files temp = fva.getNewestFile(Long.valueOf(fileId));
                    ht.initialize((Object)temp);
                    if (temp != null) {
                        log.info((Object)("Plik o identyfikatorze " + fileId + " nie jest najnowsza wersja dokumentu, pobieranie najnowszej"));
                        newDocIds = newDocIds + temp.getId().toString() + ",";
                        continue;
                    }
                    if (ServiceFactory.getFileService().getFile(new Long(fileId), new String[0]) == null) continue;
                    newDocIds = newDocIds + fileId + ",";
                }
                if (newDocIds.endsWith(",")) {
                    newDocIds = newDocIds.substring(0, newDocIds.length() - 1);
                }
            }
            log.info((Object)("Identyfikatory dokumentow podlaczonych do procesu: " + newDocIds));
            bSuccess = true;
            answerMessage = newDocIds;
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d odczytu dokument\u00f3w pod\u0142\u0105czonych do procesu.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                JSONDocIds = new JSONObject();
                JSONDocIds.put("success", bSuccess);
                JSONDocIds.put("message", (Object)answerMessage);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(JSONDocIds);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

