/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.msproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mpx.MPXWriter;
import net.sf.mpxj.reader.ProjectReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class MSPReader {
    private ProjectReader reader;
    private static Logger log = Logger.getLogger(MSPReader.class);

    public void read(InputStream is) throws MPXJException {
        try {
            ProjectFile project = this.reader.read(is);
            for (Resource resource : project.getAllResources()) {
                System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ")");
            }
            for (Task task : project.getAllTasks()) {
                task.setName("qqq");
                System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID());
            }
            MPXWriter pw = new MPXWriter();
            pw.write(project, "C:/temp/test/mpx");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void read(File file) throws FileNotFoundException, MPXJException {
        String fileName = file.getName();
        String ext = FilenameUtils.getExtension((String)fileName);
        this.setReader(ext);
        this.read(new FileInputStream(file));
    }

    private void setReader(String ext) {
        if (ext.equalsIgnoreCase("MPX")) {
            this.setReader((ProjectReader)new MPXReader());
        } else {
            this.setReader((ProjectReader)new MPPReader());
        }
    }

    public void read(String path) throws MPXJException, FileNotFoundException {
        this.read(new File(path));
    }

    public ProjectReader getReader() {
        if (this.reader == null) {
            this.reader = new MPPReader();
        }
        return this.reader;
    }

    public void setReader(ProjectReader reader) {
        this.reader = reader;
    }
}

