/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.GroupService;
import com.plusmpm.CUF.util.extension.QueryUtils;
import com.plusmpm.CUF.util.extension.UserManager;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.Tools;
import com.suncode.cuf.administartion.structure.OrganizationalUnitHelper;
import com.suncode.cuf.administartion.structure.PositionHelper;
import com.suncode.cuf.administartion.structure.internal.PositionHelperImpl;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtStructureService {
    private static Logger log = Logger.getLogger(ExtStructureService.class);
    private DBManagement dbm = new DBManagement();
    private String[] allGroups;
    private UserGroupAdministration uga;
    private int mode;
    private Map<String, String> headerMapping;
    private PositionHelperImpl positionService = new PositionHelperImpl();
    private RoleService roleService = ServiceFactory.getRoleService();
    public static final int APPEND = 0;
    public static final int STANDARD = 1;
    public static final int OVERRIDE = 2;
    private Set<String> userIds;
    private Set<String> posSymbols;
    private Set<String> groups;
    private Set<String> ouSymbols;
    private GroupService groupService = new GroupService();
    private UserManager userManager = new UserManager();
    @Autowired
    private OrganizationalUnitFinder ous;
    @Autowired
    private PositionFinder ps;
    @Autowired
    private OrganizationalUnitHelper eous;
    @Autowired
    private StructureService ss;
    @Autowired
    private PositionHelper eps;
    @Autowired
    private RoleService rs = ServiceFactory.getRoleService();
    private Comparator<Map<String, Object>> mapComparator = new Comparator<Map<String, Object>>(){

        @Override
        public int compare(Map<String, Object> m1, Map<String, Object> m2) {
            return m1.get(ExtStructureService.this.getHeaderMapping().get("userid")).toString().compareTo(m2.get(ExtStructureService.this.getHeaderMapping().get("userid")).toString());
        }
    };

    public void readStructure(List<Map<String, Object>> structure) throws Exception {
        this.uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        Collections.sort(structure, this.mapComparator);
        this.allGroups = this.uga.getAllGroupnames();
        log.info((Object)"*********************Wczytywanie struktury organizazycjnej**********************");
        try {
            Object lastUser = "";
            ArrayList<String> positions = new ArrayList<String>();
            int rowIdx = 0;
            for (Map<String, Object> user : structure) {
                int i;
                boolean userExist;
                String slog = "";
                for (String key : user.keySet()) {
                    slog = slog + key + ": " + user.get(key) + " || ";
                }
                log.info((Object)slog);
                String sUser = this.readString(user.get(this.getHeaderMapping().get("userid"))).toLowerCase();
                String sGroups = this.readString(user.get(this.getHeaderMapping().get("groups")));
                String pass = this.readString(user.get(this.getHeaderMapping().get("pass")));
                String firstName = this.readString(user.get(this.getHeaderMapping().get("firstname")));
                String lastName = this.readString(user.get(this.getHeaderMapping().get("lastname")));
                String email = this.readString(user.get(this.getHeaderMapping().get("email")));
                String sPositionSymbol = this.readString(user.get(this.getHeaderMapping().get("possym")));
                String sOrganizationalUnitSymbol = this.readString(user.get(this.getHeaderMapping().get("ousym")));
                String sOrganizationalUnitName = this.readString(user.get(this.getHeaderMapping().get("ou")));
                String sHigherOrganizationalUnitSymbol = this.readString(user.get(this.getHeaderMapping().get("higherousym")));
                String sDirectorPositionSymbol = this.readString(user.get(this.getHeaderMapping().get("dirpossym")));
                String sHigherPositionsSymbol = this.readString(user.get(this.getHeaderMapping().get("higherpossym")));
                String sUserNumber = this.readString(user.get(this.getHeaderMapping().get("usernumber")));
                String[] asGroups = null;
                asGroups = StringUtils.isBlank((String)sGroups) ? new String[]{} : sGroups.split(";");
                this.createNotExistingGroups(asGroups);
                this.rememberUser(sUser);
                this.rememberGroups(asGroups);
                this.rememberPositionSymbol(sPositionSymbol);
                this.rememberPositionSymbol(sDirectorPositionSymbol);
                this.rememberPositionSymbol(sHigherPositionsSymbol);
                this.rememberOu(sOrganizationalUnitSymbol);
                this.rememberOu(sHigherOrganizationalUnitSymbol);
                if (!sUser.equals(lastUser)) {
                    if (!((String)lastUser).equals("") && this.mode > 0) {
                        this.removeOtherPositions((String)lastUser, positions);
                    }
                    lastUser = sUser;
                }
                if (!(userExist = this.uga.doesUserExist(sUser))) {
                    if (asGroups.length == 0 || StringUtils.isBlank((String)asGroups[0])) {
                        throw new IllegalArgumentException("Nie podano grupy");
                    }
                    this.uga.createUser(asGroups[0], sUser, pass, firstName, lastName, email);
                    for (i = 1; i < asGroups.length; ++i) {
                        this.uga.addUserToGroup(asGroups[i], sUser);
                    }
                    log.info((Object)("Dodano u\u017cytkownika: " + (String)sUser));
                } else {
                    this.uga.updateUser(sUser, firstName, lastName, email);
                    if (!StringUtils.isEmpty((String)pass)) {
                        this.uga.setPassword(sUser, pass);
                    }
                    for (i = 0; i < asGroups.length; ++i) {
                        if (this.uga.doesUserBelongToGroup(asGroups[i], sUser)) continue;
                        this.uga.addUserToGroup(asGroups[i], sUser);
                    }
                    if (this.mode > 0) {
                        this.removeUserFromOtherGroups(asGroups, sUser);
                    }
                    log.info((Object)("U\u017cytkownik " + (String)sUser + " ju\u017c istnieje - dane zaktualizowane"));
                }
                OrganizationalUnit oOrganizationalUnit = null;
                boolean bOrganizationalUnitExist = true;
                if (!StringUtils.isEmpty((String)sOrganizationalUnitSymbol)) {
                    oOrganizationalUnit = this.ous.findBySymbol(sOrganizationalUnitSymbol, new String[0]);
                    if (oOrganizationalUnit == null) {
                        bOrganizationalUnitExist = false;
                        oOrganizationalUnit = new OrganizationalUnit(sOrganizationalUnitName, sOrganizationalUnitSymbol);
                        log.info((Object)("Dodawanie nowej jednostki organizacyjnej: " + sOrganizationalUnitSymbol));
                    }
                    oOrganizationalUnit.setName(sOrganizationalUnitName);
                    if (!StringUtils.isEmpty((String)sHigherOrganizationalUnitSymbol)) {
                        OrganizationalUnit oHigherOrganizationalUnit = this.ous.findBySymbol(sHigherOrganizationalUnitSymbol, new String[0]);
                        if (oHigherOrganizationalUnit == null) {
                            oHigherOrganizationalUnit = new OrganizationalUnit("", sHigherOrganizationalUnitSymbol);
                            oHigherOrganizationalUnit.setSymbol(sHigherOrganizationalUnitSymbol);
                            this.ss.createOrganizationalUnit(oHigherOrganizationalUnit);
                            log.info((Object)("Brak jednostki nadrzednej. Dodano: " + sHigherOrganizationalUnitSymbol));
                        }
                        Long nId = oHigherOrganizationalUnit.getId();
                        oOrganizationalUnit.setHigherOrganizationalUnit(oHigherOrganizationalUnit);
                    } else if (bOrganizationalUnitExist && this.mode > 0) {
                        oOrganizationalUnit.setHigherOrganizationalUnit(null);
                    }
                    if (!StringUtils.isEmpty((String)sDirectorPositionSymbol)) {
                        Position oPositionTable = this.ps.findBySymbol(sDirectorPositionSymbol, new String[0]);
                        if (oPositionTable == null) {
                            oPositionTable = new Position("", sDirectorPositionSymbol);
                            this.ss.createPosition(oPositionTable);
                            log.info((Object)("Brak podanego stanowiska kierowniczego. Dodano stanowisko: " + sDirectorPositionSymbol));
                        }
                        oOrganizationalUnit.setDirectorPosition(oPositionTable);
                    } else if (bOrganizationalUnitExist && this.mode > 0) {
                        oOrganizationalUnit.setDirectorPosition(null);
                    }
                    if (bOrganizationalUnitExist) {
                        this.ss.updateOrganizationalUnit(oOrganizationalUnit);
                        log.info((Object)("Zmieniono dane jednostki organizacyjnej: " + sOrganizationalUnitSymbol));
                    } else {
                        this.ss.createOrganizationalUnit(oOrganizationalUnit);
                        log.info((Object)("Dodano nowa jednostke organizacyjna: " + sOrganizationalUnitSymbol));
                    }
                }
                Position oPositionsTable = null;
                boolean bPositionExist = true;
                if (!StringUtils.isEmpty((String)sPositionSymbol)) {
                    oPositionsTable = this.ps.findBySymbol(sPositionSymbol, new String[0]);
                    String sPositionsName = this.readString(user.get("Nazwa stanowiska"));
                    if (oPositionsTable == null) {
                        bPositionExist = false;
                        oPositionsTable = new Position(sPositionsName, sPositionSymbol);
                        log.info((Object)("Dodawanie nowego stanowiska: " + sPositionSymbol));
                    }
                    oPositionsTable.setName(sPositionsName);
                    if (oOrganizationalUnit != null) {
                        oPositionsTable.setOrganizationalUnit(oOrganizationalUnit);
                        log.info((Object)("Powiazano jednostke : " + sOrganizationalUnitSymbol + " ze stanowiskiem: " + sPositionSymbol));
                    } else if (bPositionExist && this.mode > 0) {
                        oPositionsTable.setOrganizationalUnit(null);
                    }
                    if (!Tools.isNullOrEmpty((String)sHigherPositionsSymbol)) {
                        Position oHigherPositions = this.ps.findBySymbol(sHigherPositionsSymbol, new String[0]);
                        if (oHigherPositions == null) {
                            oHigherPositions = new Position("", sHigherPositionsSymbol);
                            this.ss.createPosition(oHigherPositions);
                            log.info((Object)("Brak podanego stanowiska nadrzednego. Dodanie stanowiska: " + sHigherPositionsSymbol));
                        }
                        oPositionsTable.setHigherPosition(oHigherPositions);
                    }
                    if (bPositionExist) {
                        this.ss.updatePosition(oPositionsTable);
                        log.info((Object)("Zmieniono dane stanowiska: " + sPositionSymbol));
                    } else {
                        this.ss.createPosition(oPositionsTable);
                        log.info((Object)("Dodano nowe stanowisko: " + sPositionSymbol));
                    }
                    positions.add(oPositionsTable.getId().toString());
                    String sRoles = this.readString(user.get(this.getHeaderMapping().get("roles")));
                    Long pId = oPositionsTable.getId();
                    if (!StringUtils.isEmpty((String)sRoles)) {
                        List<String> roleIds = Arrays.asList(sRoles.split(";"));
                        this.rs.detachAllRoles(pId);
                        this.addRoles(pId, roleIds);
                    } else if (bPositionExist && this.mode > 0) {
                        this.rs.detachAllRoles(pId);
                    }
                }
                if (oPositionsTable != null) {
                    this.ss.addPositionToUser(sUser, oPositionsTable.getId());
                    log.info((Object)("Powiazano uzytkownika: " + (String)sUser + " ze stanowiskiem: " + sPositionSymbol));
                }
                ++rowIdx;
            }
            if (this.mode == 2) {
                ExtStructureService extStructureService = this;
                List allUsers = extStructureService.dbm.getAllUsers();
                allUsers.removeAll(this.getUserIds());
                allUsers.remove("admin");
                this.userManager.deleteUsers(allUsers);
                List<String> allGroups = this.groupService.getAllGroups();
                allGroups.removeAll(this.getGroups());
                allGroups.remove("SharkGroup");
                allGroups.remove("Administrators");
                this.groupService.deleteGroups(allGroups);
                List<String> allOus = this.eous.getAllOuSymbols();
                allOus.removeAll(this.getOuSymbols());
                for (String ouSym : allOus) {
                    this.ss.deleteOrganizationalUnit(ouSym);
                }
                List<String> allPos = this.positionService.getAllPositionSymbols();
                allPos.removeAll(this.getPosSymbols());
                for (String posSym : allPos) {
                    this.ss.deletePosition(posSym);
                }
            }
            log.info((Object)"zakonczono");
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void addRoles(Long pId, List<String> roleIds) {
        for (String roleId : roleIds) {
            log.info((Object)("Pe\u0142ne id roli: " + roleId));
            Role role = this.getRole(roleId);
            this.rs.addRole(pId, role.getId());
        }
    }

    private void rememberOu(String sOrganizationalUnitSymbol) {
        if (this.mode == 2) {
            this.getOuSymbols().add(sOrganizationalUnitSymbol);
        }
    }

    private void rememberPositionSymbol(String sPositionSymbol) {
        if (this.mode == 2) {
            this.getPosSymbols().add(sPositionSymbol);
        }
    }

    private void rememberGroups(String[] asGroups) {
        if (this.mode == 2) {
            this.getGroups().addAll(Arrays.asList(asGroups));
        }
    }

    private void rememberUser(String sUser) {
        if (this.mode == 2) {
            this.getUserIds().add(sUser);
        }
    }

    public List<Map<String, Object>> getStructure() throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = this.generateQuery();
            SQLQuery sql = hs.createSQLQuery(query);
            sql.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List result = sql.list();
            tx.commit();
            this.attachGroupInfo(result);
            this.attachRoleInfo(result);
            this.clearNull(result);
            List list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private void clearNull(List<Map<String, Object>> struct) {
        for (Map<String, Object> map : struct) {
            for (String key : map.keySet()) {
                if (map.get(key) != null && !map.get(key).equals("null")) continue;
                map.put(key, "");
            }
        }
    }

    private void attachRoleInfo(List<Map<String, Object>> struct) throws Exception {
        for (Map<String, Object> map : struct) {
            if (map.get("posid") == null) continue;
            Long positionId = Long.valueOf(map.get("posid").toString());
            List roles = FinderFactory.getRoleFinder().findByPosition(positionId);
            List<String> roleIds = this.buildRoleIds(roles);
            String sRoles = QueryUtils.listToString(roleIds, ";");
            log.info((Object)("Roles: " + sRoles));
            map.put("roles", sRoles);
        }
    }

    private List<String> buildRoleIds(List<Role> roles) {
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Role role : roles) {
            String roleId = StringUtils.join((Object[])new String[]{role.getPackageId(), ":", role.getProcessDefId(), ":", role.getRoleId()});
            roleIds.add(roleId);
        }
        return roleIds;
    }

    private void attachGroupInfo(List<Map<String, Object>> struct) throws Exception {
        String lastUserId = "";
        String sGroups = "";
        for (Map<String, Object> map : struct) {
            String userId = map.get("userid").toString();
            map.put("pass", "");
            if (!userId.equals(lastUserId)) {
                List<String> groups = UserManager.getGroupsForUser(userId);
                sGroups = QueryUtils.listToString(groups, ";");
                log.info((Object)("Groupus: " + sGroups));
                map.put("groups", sGroups);
                lastUserId = userId;
                continue;
            }
            map.put("groups", sGroups);
        }
    }

    private String generateQuery() {
        String query = "select distinct ut.userid as userid,ut.firstname as firstname,ut.lastname as lastname,ut.email as email,";
        query = query + "un.usernumber as usernumber,p.id as posid,p.positionname as posname,p.positionsymbol as possym,hp.positionsymbol as higherpossym,";
        query = query + "ou.organizationalunitname as ou,ou.organizationalunitsymbol as ousym,hou.organizationalunitsymbol as higherousym,";
        query = query + "dp.positionsymbol as dirpossym ";
        query = query + "from usertable ut ";
        query = query + "left join pm_usernumber un on un.userid=ut.userid ";
        query = query + "left join pm_userposition up on up.userid=ut.userid ";
        query = query + "left join pm_positions p on p.id=cast(up.positionid as bigint) ";
        query = query + "left join pm_positions hp on cast(hp.id as varchar )=p.higherpositionid  ";
        query = query + "left join pm_positionrole pr on cast(p.id as varchar )=pr.positionid ";
        query = query + "left join pm_organizationalunits ou on p.organizationalunitid=cast(ou.id as varchar ) ";
        query = query + "left join pm_organizationalunits hou on ou.higherorganizationalunitid=cast(hou.id as varchar ) ";
        query = query + "left join pm_positions dp on cast(dp.id as varchar )=ou.directorpositionid order by ut.userid";
        return query;
    }

    public void validateData(List<Map<String, Object>> struct) throws CUFException, BaseException {
        int i = 1;
        try {
            for (Map<String, Object> map : struct) {
                this.checkRole(map);
                this.checkPositions(map);
                this.checkUserId(map);
                ++i;
            }
        }
        catch (CUFException e) {
            throw new CUFException("Wiersz: " + i + " " + e.getMessage());
        }
    }

    private void checkPositions(Map<String, Object> map) throws CUFException {
        String possym = (String)map.get(this.getHeaderMapping().get("possym"));
        if (!StringUtils.isEmpty((String)possym) && possym.contains(";")) {
            throw new CUFException("Stanowisko nie mo\u017ce zawiera\u0107 znaku ';'.");
        }
    }

    private void checkUserId(Map<String, Object> map) throws CUFException {
        String userId = (String)map.get(this.getHeaderMapping().get("userid"));
        if (StringUtils.isEmpty((String)userId)) {
            throw new CUFException("Nazwa u\u017cytkownika nie mo\u017ce by\u0107 pusta.");
        }
    }

    private void checkRole(Map<String, Object> map) throws CUFException {
        String sRoles = this.readString(map.get(this.getHeaderMapping().get("roles")));
        if (!StringUtils.isEmpty((String)sRoles)) {
            String[] roles;
            for (String role : roles = sRoles.split(";")) {
                Role r = this.getRole(role);
                if (r != null) continue;
                throw new CUFException("Rola o id: " + role + " nie istnieje w systemie.");
            }
        }
    }

    private Role getRole(String roleId) {
        return CUFFactory.getRoleHelper().getRole(roleId);
    }

    private void removeOtherPositions(String userId, List<String> positionIds) {
        StructureService ss = ServiceFactory.getStructureService();
        PositionFinder pf = FinderFactory.getPositionFinder();
        List positions = pf.findByUserName(userId, new String[0]);
        for (Position upt : positions) {
            if (positionIds.contains(upt.getId().toString())) continue;
            ss.detachPositionFromUser(upt.getId());
        }
    }

    private void removeUserFromOtherGroups(String[] asGroups, String sUser) throws BaseException {
        List<String> groups = Arrays.asList(asGroups);
        for (String groupName : this.allGroups) {
            if (groups.contains(groupName) || !this.uga.doesUserBelongToGroup(groupName, sUser)) continue;
            this.uga.removeUserFromGroup(groupName, sUser);
        }
    }

    private String readString(Object object) {
        String s = object == null ? "" : object.toString();
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s.trim();
    }

    private void createNotExistingGroups(String[] asGroups) throws BaseException {
        boolean changed = false;
        for (int i = 0; i < asGroups.length; ++i) {
            if (StringUtils.isEmpty((String)asGroups[i]) || this.uga.doesGroupExist(asGroups[i])) continue;
            this.uga.createGroup(asGroups[i], asGroups[i]);
            changed = true;
            log.info((Object)("Grupa " + asGroups[i] + " zosta\u0142a utworzona"));
        }
        if (changed) {
            this.allGroups = this.uga.getAllGroupnames();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode.equalsIgnoreCase("APPEND") ? 0 : (mode.equalsIgnoreCase("OVERRIDE") ? 2 : 1);
    }

    private Set<String> getUserIds() {
        if (this.userIds == null) {
            this.userIds = new HashSet<String>();
        }
        return this.userIds;
    }

    private Set<String> getPosSymbols() {
        if (this.posSymbols == null) {
            this.posSymbols = new HashSet<String>();
        }
        return this.posSymbols;
    }

    private Set<String> getOuSymbols() {
        if (this.ouSymbols == null) {
            this.ouSymbols = new HashSet<String>();
        }
        return this.ouSymbols;
    }

    private Set<String> getGroups() {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        return this.groups;
    }

    public void setHeaderMapping(Map<String, String> headerMapping) {
        this.headerMapping = headerMapping;
    }

    public Map<String, String> getHeaderMapping() {
        if (this.headerMapping == null) {
            this.headerMapping = this.createHeadersMapping();
        }
        return this.headerMapping;
    }

    private Map<String, String> createHeadersMapping() {
        HashMap<String, String> headersMapping = new HashMap<String, String>();
        headersMapping.put("userid", "Login");
        headersMapping.put("firstname", "Imi\u0119");
        headersMapping.put("lastname", "Nazwisko");
        headersMapping.put("pass", "Has\u0142o");
        headersMapping.put("email", "Email");
        headersMapping.put("usernumber", "Nr");
        headersMapping.put("groups", "Grupy");
        headersMapping.put("posname", "Nazwa stanowiska");
        headersMapping.put("possym", "Symbol stanowiska");
        headersMapping.put("higherpossym", "Symbol stanowiska nadrz\u0119dnego");
        headersMapping.put("roles", "Role");
        headersMapping.put("ou", "Nazwa jednostki organizacyjnej");
        headersMapping.put("ousym", "Symbol jednostki organizacyjnej");
        headersMapping.put("higherousym", "Symbol jednostki nadrz\u0119dnej");
        headersMapping.put("dirpossym", "Symbol stanowiska kierowniczego");
        return headersMapping;
    }
}

