/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportRights
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportRights.class);

    @AdvancedTask(name="ImportRightsFromXLS", description="ImportRightsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportRightsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************************ ImportRightsFromXLS(sXLSPath=" + sXLSPath + ") *************************"));
        long startTime = new Date().getTime();
        List<HashMap<String, String>> rights = null;
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            rights = ImportRights.readRights(sXLSPath);
            if (rights == null || rights.size() == 0) {
                throw new CUFException("Brak uprawnien w pliku " + sXLSPath);
            }
            for (int x = 0; x < rights.size(); ++x) {
                try {
                    int i;
                    String[] tab;
                    String sGroup = rights.get(x).get("Nazwa grupy");
                    String sUser = rights.get(x).get("Nazwa u\u017cytkownika");
                    if (!Tools.isNullOrEmpty((String)sGroup) && sGroup.compareToIgnoreCase("*") == 0 && Tools.isNullOrEmpty((String)sUser)) {
                        tab = uga.getAllGroupnames();
                        for (i = 0; i < tab.length; ++i) {
                            if (tab[i].compareToIgnoreCase("SharkGroup") == 0 && tab[i].compareToIgnoreCase("Administrators") == 0) continue;
                            this.checkAndAddRight(rights.get(x), tab[i], true);
                        }
                    } else if (!Tools.isNullOrEmpty((String)sGroup) && Tools.isNullOrEmpty((String)sUser) && uga.doesGroupExist(sGroup)) {
                        this.checkAndAddRight(rights.get(x), sGroup, true);
                    }
                    if (!Tools.isNullOrEmpty((String)sUser) && sUser.compareToIgnoreCase("*") == 0 && Tools.isNullOrEmpty((String)sGroup)) {
                        tab = uga.getAllUsers();
                        for (i = 0; i < tab.length; ++i) {
                            if (tab[i].compareToIgnoreCase("admin") == 0) continue;
                            this.checkAndAddRight(rights.get(x), tab[i], false);
                        }
                        continue;
                    }
                    if (Tools.isNullOrEmpty((String)sUser) || !Tools.isNullOrEmpty((String)sGroup) || !uga.doesUserExist(sUser)) continue;
                    this.checkAndAddRight(rights.get(x), sUser, false);
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportRightsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static List<HashMap<String, String>> readRights(String sXLSPath) throws CUFException, Exception {
        int i;
        log.trace((Object)("********************* readRights(sXLSPath=" + sXLSPath + ") ***************"));
        File xls = null;
        WorkbookSettings wbs = new WorkbookSettings();
        ArrayList<HashMap<String, String>> rights = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> oneRow = null;
        sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
        if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
            throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
        }
        xls = new File(sXLSPath);
        if (xls == null || !xls.exists()) {
            throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
        }
        wbs.setEncoding("ISO-8859-2");
        Workbook w = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
        Sheet sheet = w.getSheet(0);
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        for (i = 0; i < 15; ++i) {
            String cell = sheet.getCell(i, 0).getContents();
            header.put(cell, i);
        }
        for (i = 1; i < sheet.getRows(); ++i) {
            if (sheet.getCell(((Integer)header.get("Nazwa grupy")).intValue(), i).getContents().isEmpty() && sheet.getCell(((Integer)header.get("Nazwa u\u017cytkownika")).intValue(), i).getContents().isEmpty()) continue;
            oneRow = new HashMap<String, String>();
            oneRow.put("Nazwa grupy", sheet.getCell(((Integer)header.get("Nazwa grupy")).intValue(), i).getContents());
            oneRow.put("Nazwa u\u017cytkownika", sheet.getCell(((Integer)header.get("Nazwa u\u017cytkownika")).intValue(), i).getContents());
            oneRow.put("System", sheet.getCell(((Integer)header.get("System")).intValue(), i).getContents());
            oneRow.put("Administracja", sheet.getCell(((Integer)header.get("Administracja")).intValue(), i).getContents());
            oneRow.put("Archiwum", sheet.getCell(((Integer)header.get("Archiwum")).intValue(), i).getContents());
            oneRow.put("Klasy dokument\u00f3w", sheet.getCell(((Integer)header.get("Klasy dokument\u00f3w")).intValue(), i).getContents());
            oneRow.put("Zestawy dokument\u00f3w", sheet.getCell(((Integer)header.get("Zestawy dokument\u00f3w")).intValue(), i).getContents());
            oneRow.put("Obieg dokument\u00f3w", sheet.getCell(((Integer)header.get("Obieg dokument\u00f3w")).intValue(), i).getContents());
            oneRow.put("Tworzenie proces\u00f3w", sheet.getCell(((Integer)header.get("Tworzenie proces\u00f3w")).intValue(), i).getContents());
            oneRow.put("Skrzynka zada\u0144", sheet.getCell(((Integer)header.get("Skrzynka zada\u0144")).intValue(), i).getContents());
            oneRow.put("Wyszukiwanie proces\u00f3w", sheet.getCell(((Integer)header.get("Wyszukiwanie proces\u00f3w")).intValue(), i).getContents());
            oneRow.put("Statystyki", sheet.getCell(((Integer)header.get("Statystyki")).intValue(), i).getContents());
            oneRow.put("Kalendarz", sheet.getCell(((Integer)header.get("Kalendarz")).intValue(), i).getContents());
            oneRow.put("Raporty", sheet.getCell(((Integer)header.get("Raporty")).intValue(), i).getContents());
            oneRow.put("Konto u\u017cytkownika", sheet.getCell(((Integer)header.get("Konto u\u017cytkownika")).intValue(), i).getContents());
            rights.add(oneRow);
            continue;
        }
        return rights;
    }

    private void checkAndAddRight(HashMap<String, String> rights, String sWho, boolean IsGroup) {
        log.trace((Object)("********************* checkAndAddRight(HashMap<String, String>, sWho=" + sWho + ", IsGroup=" + String.valueOf(IsGroup) + ") ***************"));
        try {
            if (IsGroup) {
                log.info((Object)("Przyznawanie/odbieranie praw dla grupy " + sWho));
            } else {
                log.info((Object)("Przyznawanie/odbieranie praw dla uzytkownika " + sWho));
            }
            String sSystemRight = rights.get("System");
            if (!Tools.isNullOrEmpty((String)sSystemRight) && sSystemRight.compareToIgnoreCase("T") == 0) {
                Authorization.addRight((String)"System", (String)sWho, (boolean)IsGroup);
            } else {
                String sAdminRight;
                if (!Tools.isNullOrEmpty((String)sSystemRight) && sSystemRight.compareToIgnoreCase("N") == 0) {
                    Authorization.deleteRight((String)"System", (String)sWho, (boolean)IsGroup);
                }
                if (!Tools.isNullOrEmpty((String)(sAdminRight = rights.get("Administracja"))) && sAdminRight.compareToIgnoreCase("T") == 0) {
                    Authorization.addRight((String)RightTreeBuilder.builder().system().admin().build(), (String)sWho, (boolean)IsGroup);
                } else if (!Tools.isNullOrEmpty((String)sAdminRight) && sAdminRight.compareToIgnoreCase("N") == 0) {
                    Authorization.deleteRight((String)RightTreeBuilder.builder().system().admin().build(), (String)sWho, (boolean)IsGroup);
                }
                String sArchiveRight = rights.get("Archiwum");
                if (!Tools.isNullOrEmpty((String)sArchiveRight) && sArchiveRight.compareToIgnoreCase("T") == 0) {
                    Authorization.addRight((String)RightTreeBuilder.builder().system().archive().build(), (String)sWho, (boolean)IsGroup);
                } else {
                    String sDocClassesRight;
                    if (!Tools.isNullOrEmpty((String)sArchiveRight) && sArchiveRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().archive().build(), (String)sWho, (boolean)IsGroup);
                    }
                    if (!Tools.isNullOrEmpty((String)(sDocClassesRight = rights.get("Klasy dokument\u00f3w"))) && sDocClassesRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sDocClassesRight) && sDocClassesRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().archive().docClasses().build(), (String)sWho, (boolean)IsGroup);
                    }
                    String sLinksRight = rights.get("Zestawy dokument\u00f3w");
                    if (!Tools.isNullOrEmpty((String)sLinksRight) && sLinksRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().archive().links().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sLinksRight) && sLinksRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().archive().links().build(), (String)sWho, (boolean)IsGroup);
                    }
                }
                String sWorkflowRight = rights.get("Obieg dokument\u00f3w");
                if (!Tools.isNullOrEmpty((String)sWorkflowRight) && sWorkflowRight.compareToIgnoreCase("T") == 0) {
                    Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().build(), (String)sWho, (boolean)IsGroup);
                } else {
                    String sProcessesCreateRight;
                    if (!Tools.isNullOrEmpty((String)sWorkflowRight) && sWorkflowRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().workflow().build(), (String)sWho, (boolean)IsGroup);
                    }
                    if (!Tools.isNullOrEmpty((String)(sProcessesCreateRight = rights.get("Tworzenie proces\u00f3w"))) && sProcessesCreateRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().create().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sProcessesCreateRight) && sProcessesCreateRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().workflow().processes().create().build(), (String)sWho, (boolean)IsGroup);
                    }
                    String sProcessesViewRight = rights.get("Wyszukiwanie proces\u00f3w");
                    if (!Tools.isNullOrEmpty((String)sProcessesViewRight) && sProcessesViewRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().view().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sProcessesViewRight) && sProcessesViewRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().workflow().processes().view().build(), (String)sWho, (boolean)IsGroup);
                    }
                    String sProcessesStatsRight = rights.get("Statystyki");
                    if (!Tools.isNullOrEmpty((String)sProcessesStatsRight) && sProcessesStatsRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().processes().stats().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sProcessesStatsRight) && sProcessesStatsRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().workflow().processes().stats().build(), (String)sWho, (boolean)IsGroup);
                    }
                    String sCalendarRight = rights.get("Kalendarz");
                    if (!Tools.isNullOrEmpty((String)sCalendarRight) && sCalendarRight.compareToIgnoreCase("T") == 0) {
                        Authorization.addRight((String)RightTreeBuilder.builder().system().workflow().calendar().build(), (String)sWho, (boolean)IsGroup);
                    } else if (!Tools.isNullOrEmpty((String)sCalendarRight) && sCalendarRight.compareToIgnoreCase("N") == 0) {
                        Authorization.deleteRight((String)RightTreeBuilder.builder().system().workflow().calendar().build(), (String)sWho, (boolean)IsGroup);
                    }
                }
                String sReportsRight = rights.get("Raporty");
                if (!Tools.isNullOrEmpty((String)sReportsRight) && sReportsRight.compareToIgnoreCase("T") == 0) {
                    Authorization.addRight((String)RightTreeBuilder.builder().system().reports().build(), (String)sWho, (boolean)IsGroup);
                } else if (!Tools.isNullOrEmpty((String)sReportsRight) && sReportsRight.compareToIgnoreCase("N") == 0) {
                    Authorization.deleteRight((String)RightTreeBuilder.builder().system().reports().build(), (String)sWho, (boolean)IsGroup);
                }
                String sUserAccountRight = rights.get("Konto u\u017cytkownika");
                if (!Tools.isNullOrEmpty((String)sUserAccountRight) && sUserAccountRight.compareToIgnoreCase("T") == 0) {
                    Authorization.addRight((String)RightTreeBuilder.builder().system().userAccount().build(), (String)sWho, (boolean)IsGroup);
                } else if (!Tools.isNullOrEmpty((String)sUserAccountRight) && sUserAccountRight.compareToIgnoreCase("N") == 0) {
                    Authorization.deleteRight((String)RightTreeBuilder.builder().system().userAccount().build(), (String)sWho, (boolean)IsGroup);
                }
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

