/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.documentViews.DocumentViewDisplayLocation;
import com.plusmpm.database.documentViews.DocumentViewsMethods;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.HibernateException;

public class ImportDocumentViews
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDocumentViews.class);

    @AdvancedTask(name="ImportDocumentViewsFromXLS", description="ImportDocumentViewsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDocumentViewsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportDocumentViews(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Widoki dokument\u00f3w");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Widoki dokument\u00f3w w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 10; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z widokami dokumentow");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String viewName = sheet.getCell(((Integer)header.get("Nazwa widoku")).intValue(), i).getContents();
                    String viewDescr = sheet.getCell(((Integer)header.get("Opis")).intValue(), i).getContents();
                    String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                    String procDefId = "";
                    String activityName = sheet.getCell(((Integer)header.get("Nazwa zadania")).intValue(), i).getContents();
                    String actDefId = "";
                    String userId = sheet.getCell(((Integer)header.get("U\u017cytkownik")).intValue(), i).getContents();
                    String docClassName = sheet.getCell(((Integer)header.get("Klasa dokument\u00f3w")).intValue(), i).getContents();
                    Long docClassId = null;
                    String newest = sheet.getCell(((Integer)header.get("Najnowsze")).intValue(), i).getContents();
                    boolean bNewest = false;
                    String showOnText = sheet.getCell(((Integer)header.get("Wy\u015bwietl na")).intValue(), i).getContents();
                    DocumentViewDisplayLocation showOn = DocumentViewDisplayLocation.valueOf((String)showOnText);
                    String amount = sheet.getCell(((Integer)header.get("Ilo\u015b\u0107")).intValue(), i).getContents();
                    Integer iAmount = null;
                    String regex = sheet.getCell(((Integer)header.get("Wyra\u017cenie regularne")).intValue(), i).getContents();
                    String displayByOffice365 = sheet.getCell(((Integer)header.get("Office 365")).intValue(), i).getContents();
                    boolean bDisplayByOffice365 = false;
                    if (Tools.isNullOrEmpty((String)viewName)) {
                        throw new CUFException("Brak nazwy widoku w pliku xls w linii o numerze " + i);
                    }
                    procDefId = CUFTools.getProcDefIdForProcessName(processName);
                    if (Tools.isNullOrEmpty((String)procDefId)) {
                        throw new CUFException("Proces o nazwie " + processName + "nie istnieje w systemie");
                    }
                    if (ArchiveServices.DoesDocumentViewExist(viewName, procDefId)) {
                        throw new CUFException("Widok dokumentow o nazwie " + viewName + " istnieje juz dla procesu o nazwie " + processName);
                    }
                    if (!activityName.equalsIgnoreCase("Ka\u017cde") && Tools.isNullOrEmpty((String)(actDefId = CUFTools.getActDefIdForActivityName(procDefId, activityName)))) {
                        throw new CUFException("Zadanie o nazwie " + activityName + "nie istnieje w procesie o nazwie " + processName);
                    }
                    if (!Tools.isNullOrEmpty((String)userId)) {
                        if (userId.equalsIgnoreCase("Ka\u017cdy")) {
                            userId = "";
                        } else if (!uga.doesUserExist(userId)) {
                            throw new CUFException("Uzytkownik " + userId + " w widoku dokumentow o nazwie " + viewName + " nie istnieje w systemie");
                        }
                    } else {
                        userId = "";
                    }
                    if (!docClassName.equalsIgnoreCase("Ka\u017cda")) {
                        if (!ArchiveServices.DoesDocClassExist(docClassName)) {
                            throw new CUFException("Klasa dokumentow o nazwie " + docClassName + "nie istnieje w systemie");
                        }
                        DocClassTable docClassTable = dbm.getDocClassByName(docClassName);
                        docClassId = docClassTable.getId();
                    }
                    if (newest.equalsIgnoreCase("tak")) {
                        bNewest = true;
                    }
                    if (displayByOffice365.equalsIgnoreCase("tak")) {
                        bDisplayByOffice365 = true;
                    }
                    try {
                        iAmount = Integer.parseInt(amount);
                    }
                    catch (NumberFormatException e) {
                        throw new CUFException("Ilosc dla widoku dokumentow o nazwie " + viewName + " nie przyjmuje wartosci liczbowej");
                    }
                    if (iAmount <= 0) {
                        throw new CUFException("Ilosc dla widoku dokumentow o nazwie " + viewName + " nie przyjmuje wartosci dodatniej");
                    }
                    try {
                        Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CUFException("Wyra\u017cenie regularne dla widoku dokumentow o nazwie " + viewName + " jest niepoprawne");
                    }
                    try {
                        DocumentViewsMethods.addDocumentView((String)viewName, (String)viewDescr, (String)procDefId, (String)actDefId, (String)userId, (Long)docClassId, (Boolean)bNewest, (Integer)iAmount, (String)regex, (DocumentViewDisplayLocation)showOn, (Boolean)bDisplayByOffice365);
                    }
                    catch (HibernateException he) {
                        throw new CUFException("Blad podczas dodawania widoku dokumentow o nazwie " + viewName + " dla procesu o nazwie " + processName);
                    }
                    log.info((Object)("Poprawnie dodano widok dokumentow o nazwie " + viewName + " dla procesu o nazwie " + processName));
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import widokow dokumentow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDocumentViewsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

