/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.formTemplate;

import com.plusmpm.CUF.database.formTemplate.FormTemplate;
import com.plusmpm.CUF.database.formTemplate.FormTemplateDao;
import com.plusmpm.CUF.database.formTemplate.FormTemplateException;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import com.suncode.cuf.database.HibernateHelper;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class FormTemplateDaoImpl
implements FormTemplateDao {
    private static Logger log = Logger.getLogger(FormTemplateDaoImpl.class);
    private static final String CATEGORY_CONST = "::";

    private void checkOldCol() throws Exception {
        log.info((Object)"CheckOldCol");
        Session hs = null;
        Transaction tx = null;
        try {
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add(Restrictions.isNull((String)"blobData"));
            List list = crit.list();
            for (FormTemplate ft : list) {
                Blob blob;
                if (ft.getBinData() != null && ft.getBinData().length > 0) {
                    byte[] bytes = ft.getBinData();
                    if (bytes == null) continue;
                    blob = HibernateHelper.createBlob(bytes);
                    ft.setBlobData(blob);
                    hs.update((Object)ft);
                }
                if (ft.getData() == null || ft.getData().isEmpty()) continue;
                String s = ft.getData();
                blob = HibernateHelper.createBlob(s.getBytes("UTF-8"));
                ft.setBlobData(blob);
                hs.update((Object)ft);
            }
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public void delete(FormTemplate template) throws Exception {
        if (template == null) {
            log.info((Object)"FormTempalte jest null");
            throw new NullPointerException();
        }
        log.trace((Object)"****delete*****");
        log.info((Object)("templateName: " + template.getTemplateName()));
        log.info((Object)("activityDefId: " + template.getActivityDefId()));
        log.info((Object)("processDefId: " + template.getProcessDefId()));
        log.info((Object)("userId: " + template.getUserId()));
        if (StringUtils.isBlank((String)template.getActivityDefId())) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)template.getProcessDefId())) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        if (StringUtils.isBlank((String)template.getUserId())) {
            throw new NullPointerException("UserId jest null");
        }
        if (StringUtils.isBlank((String)template.getTemplateName())) {
            throw new NullPointerException("TemplateName jest null");
        }
        Session hs = null;
        Transaction tx = null;
        try {
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            this.categorizeTemplate(template);
            hs.delete((Object)template);
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public FormTemplate get(String activityDefId, String processDefId, String userId, String category, String templateName) throws Exception {
        log.trace((Object)"*******get********* ");
        log.info((Object)("activityId: " + activityDefId));
        log.info((Object)("porcessId: " + processDefId));
        log.info((Object)("userId: " + userId));
        if (StringUtils.isBlank((String)activityDefId)) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)processDefId)) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        if (StringUtils.isBlank((String)userId)) {
            throw new NullPointerException("userId jest null");
        }
        Session hs = null;
        Transaction tx = null;
        FormTemplate template = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityDefId));
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            crit.add((Criterion)Restrictions.eq((String)"templateName", (Object)this.categorizeTemplateName(templateName, category)));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            template = (FormTemplate)crit.uniqueResult();
            if (template != null) {
                template.convertToJson();
                hs.evict((Object)template);
                this.uncategorizeTemplate(template);
            }
            tx.commit();
            FormTemplate formTemplate = template;
            return formTemplate;
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public List<FormTemplate> getAll(String activityDefId, String processDefId) throws Exception {
        log.trace((Object)"*******getAll********* ");
        log.info((Object)("activityDefId: " + activityDefId));
        log.info((Object)("porcessDefId: " + processDefId));
        if (StringUtils.isBlank((String)activityDefId)) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)processDefId)) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        Session hs = null;
        Transaction tx = null;
        List templates = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityDefId));
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            templates = crit.list();
            for (FormTemplate ft : templates) {
                if (ft == null) continue;
                ft.convertToJson();
                hs.evict((Object)ft);
                this.uncategorizeTemplate(ft);
            }
            tx.commit();
            List list = templates;
            return list;
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public List<FormTemplate> getAll(String activityDefId, String processDefId, String userId) throws Exception {
        log.trace((Object)"*******getAll********* ");
        log.info((Object)("activityDefId: " + activityDefId));
        log.info((Object)("porcessDefId: " + processDefId));
        if (StringUtils.isBlank((String)activityDefId)) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)processDefId)) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        Session hs = null;
        Transaction tx = null;
        List templates = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityDefId));
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            templates = crit.list();
            for (FormTemplate ft : templates) {
                if (ft == null) continue;
                ft.convertToJson();
                hs.evict((Object)ft);
                this.uncategorizeTemplate(ft);
            }
            tx.commit();
            List list = templates;
            return list;
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public void save(FormTemplate template) throws Exception {
        if (template == null) {
            log.info((Object)"SortInfo jest null");
            throw new NullPointerException();
        }
        log.trace((Object)"****saveOrUpdate*****");
        log.info((Object)("templateName: " + template.getTemplateName()));
        log.info((Object)("activityDefId: " + template.getActivityDefId()));
        log.info((Object)("processDefId: " + template.getProcessDefId()));
        log.info((Object)("data: " + template.getData()));
        log.info((Object)("sortData: " + template.getDefault()));
        log.info((Object)("userId: " + template.getUserId()));
        if (StringUtils.isBlank((String)template.getActivityDefId())) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)template.getProcessDefId())) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        if (StringUtils.isBlank((String)template.getTemplateName())) {
            throw new NullPointerException("templateName jest null");
        }
        if (template.getTemplateName().contains(CATEGORY_CONST)) {
            throw new IllegalArgumentException("reserved character used");
        }
        if (StringUtils.isBlank((String)template.getUserId())) {
            throw new NullPointerException("UserId jest null");
        }
        if (template.getData() == null) {
            throw new NullPointerException("Data jest null");
        }
        if (template != null) {
            template.convertFromJson();
        }
        Session hs = null;
        Transaction tx = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            this.categorizeTemplate(template);
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)template.getActivityDefId()));
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)template.getProcessDefId()));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)template.getUserId()));
            crit.add((Criterion)Restrictions.eq((String)"templateName", (Object)template.getTemplateName()));
            FormTemplate ft = (FormTemplate)crit.uniqueResult();
            if (ft != null) {
                throw new FormTemplateException("Szablon o podanej nazwie ju\u017c istnieje.");
            }
            if (template.getDefault().booleanValue()) {
                crit = hs.createCriteria(FormTemplate.class);
                crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)template.getActivityDefId()));
                crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)template.getProcessDefId()));
                crit.add((Criterion)Restrictions.eq((String)"default", (Object)true));
                crit.add((Criterion)Restrictions.eq((String)"userId", (Object)template.getUserId()));
                List candidates = crit.list();
                for (FormTemplate candidate : candidates) {
                    if (!this.matchesCategory(candidate.getTemplateName(), template.getCategory())) continue;
                    ft = candidate;
                    break;
                }
                if (ft != null) {
                    ft.setDefault(false);
                    hs.update((Object)ft);
                }
            }
            template.setData(null);
            template.setBinData(null);
            hs.save((Object)template);
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public FormTemplate getDefault(String processDefId, String userId, String category) throws Exception {
        log.trace((Object)"*******get********* ");
        log.info((Object)("porcessId: " + processDefId));
        log.info((Object)("userId: " + userId));
        if (StringUtils.isBlank((String)processDefId)) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        if (StringUtils.isBlank((String)userId)) {
            throw new NullPointerException("userId jest null");
        }
        Session hs = null;
        Transaction tx = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            crit.add((Criterion)Restrictions.eq((String)"default", (Object)true));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            FormTemplate template = null;
            List templates = crit.list();
            for (FormTemplate templateCandidate : templates) {
                if (!this.matchesCategory(templateCandidate.getTemplateName(), category)) continue;
                template = templateCandidate;
                break;
            }
            if (template != null) {
                template.convertToJson();
                hs.evict((Object)template);
                this.uncategorizeTemplate(template);
            }
            tx.commit();
            FormTemplate formTemplate = template;
            return formTemplate;
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public void setDefault(String activityDefId, String processDefId, String userId, String category, String templateName) throws Exception {
        log.trace((Object)"****setDefault*****");
        log.info((Object)("templateName: " + templateName));
        log.info((Object)("activityDefId: " + activityDefId));
        log.info((Object)("processDefId: " + processDefId));
        log.info((Object)("userId: " + userId));
        if (StringUtils.isBlank((String)activityDefId)) {
            throw new NullPointerException("ActivityDefId jest null");
        }
        if (StringUtils.isBlank((String)processDefId)) {
            throw new NullPointerException("ProcessDefId jest null");
        }
        if (StringUtils.isBlank((String)templateName)) {
            throw new NullPointerException("templateName jest null");
        }
        if (StringUtils.isBlank((String)userId)) {
            throw new NullPointerException("UserId jest null");
        }
        Session hs = null;
        Transaction tx = null;
        try {
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            crit.add((Criterion)Restrictions.eq((String)"default", (Object)true));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            List candidates = crit.list();
            for (FormTemplate candidate : candidates) {
                if (!this.matchesCategory(candidate.getTemplateName(), category)) continue;
                candidate.setDefault(false);
                hs.update((Object)candidate);
            }
            crit = hs.createCriteria(FormTemplate.class);
            crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityDefId));
            crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            crit.add((Criterion)Restrictions.eq((String)"templateName", (Object)this.categorizeTemplateName(templateName, category)));
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            FormTemplate ftDef = (FormTemplate)crit.uniqueResult();
            ftDef.setDefault(true);
            hs.save((Object)ftDef);
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Override
    public List<FormTemplate> findByAny(String processType, String activityType, String user, String category) throws Exception {
        Session hs = null;
        Transaction tx = null;
        List templates = null;
        try {
            this.checkOldCol();
            hs = CUFHibernateUtil.getSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(FormTemplate.class);
            if (StringUtils.isNotBlank((String)processType)) {
                crit.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processType));
            }
            if (StringUtils.isNotBlank((String)activityType)) {
                crit.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityType));
            }
            if (StringUtils.isNotBlank((String)user)) {
                crit.add((Criterion)Restrictions.eq((String)"userId", (Object)user));
            }
            if (StringUtils.isNotBlank((String)category)) {
                crit.add((Criterion)Restrictions.eq((String)"category", (Object)category));
            }
            templates = crit.list();
            ArrayList<FormTemplate> matching = new ArrayList<FormTemplate>();
            for (FormTemplate ft : templates) {
                if (ft == null || !this.matchesCategory(ft.getTemplateName(), category)) continue;
                ft.convertToJson();
                hs.evict((Object)ft);
                this.uncategorizeTemplate(ft);
                matching.add(ft);
            }
            tx.commit();
            ArrayList<FormTemplate> arrayList = matching;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private void categorizeTemplate(FormTemplate template) {
        template.setTemplateName(this.categorizeTemplateName(template.getTemplateName(), template.getCategory()));
    }

    private String categorizeTemplateName(String name, String category) {
        if (StringUtils.isNotBlank((String)category)) {
            return category + CATEGORY_CONST + name;
        }
        return name;
    }

    private void uncategorizeTemplate(FormTemplate template) {
        template.setTemplateName(this.uncategorizeTemplateName(template.getTemplateName(), template.getCategory()));
    }

    private String uncategorizeTemplateName(String name, String category) {
        if (StringUtils.isNotBlank((String)category)) {
            return name.replace(category + CATEGORY_CONST, "");
        }
        return name;
    }

    private boolean matchesCategory(String name, String category) {
        if (!StringUtils.isNotBlank((String)category)) {
            return !name.contains(CATEGORY_CONST);
        }
        return name.contains(category + CATEGORY_CONST);
    }
}

