/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io;

import com.suncode.cuf.io.FileSyncHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileSyncHelperImpl
implements FileSyncHelper {
    private static final Logger log = Logger.getLogger(FileSyncHelperImpl.class);

    @Override
    public byte[] readFile(File file) {
        FileChannel fc = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            FileLock fl = fc.lock(0L, Long.MAX_VALUE, true);
            byte[] bytes = IOUtils.toByteArray((InputStream)fis);
            fl.release();
            byte[] byArray = bytes;
            this.closeChannel(fc);
            this.closeStream(fis);
            return byArray;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeChannel(fc);
                this.closeStream(fis);
                throw throwable;
            }
        }
    }

    @Override
    public void writeFile(File file, byte[] bytes) {
        this.writeFile(file, bytes, false);
    }

    @Override
    public void appendFile(File file, byte[] bytes) {
        this.writeFile(file, bytes, true);
    }

    private void writeFile(File file, byte[] bytes, boolean append) {
        FileChannel fc = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
            fc = fos.getChannel();
            FileLock fl = fc.lock();
            if (!append) {
                fc.truncate(0L);
            }
            fos.write(bytes);
            fl.release();
            this.closeChannel(fc);
            this.closeStream(fos);
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeChannel(fc);
                this.closeStream(fos);
                throw throwable;
            }
        }
    }

    private void closeStream(InputStream fis) {
        try {
            fis.close();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void closeChannel(FileChannel fc) {
        try {
            fc.close();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void closeStream(FileOutputStream fos) {
        try {
            fos.close();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

