/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.CUF.util.objects.DocumentVersions;
import com.plusmpm.CUF.util.objects.ExtendedFile;
import com.plusmpm.CUF.util.objects.PlusWorkflowDocument;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.documentViews.DocumentViewsMethods;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.files.DocumentSearch;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.database.files.FileVersionsManager;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.IndexData;
import com.plusmpm.util.SharkFunctions;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassActionFinder;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.QueryExecutor;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.exception.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

@Deprecated
public class ArchiveServices {
    public static Logger log = Logger.getLogger(ArchiveServices.class);
    private static final SecureRandom random = new SecureRandom();
    private static DBManagement dbm = new DBManagement();

    public static boolean DoesDeviceExist(String deviceName) throws Exception {
        log.trace((Object)("************ DoesDeviceExist(sDeviceName=" + deviceName + ") ************"));
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        Device d = as.getDevice(deviceName, new String[0]);
        return d == null;
    }

    public static boolean DoesDirectoryExist(String dirName, String deviceName) throws Exception {
        log.trace((Object)("************ DoesDirectoryExist(sDirName=" + dirName + ", sDeviceName=" + deviceName + ") ************"));
        DetachedCriteria dc = DetachedCriteria.forClass(Directory.class);
        dc.add((Criterion)Restrictions.eq((String)"name", (Object)dirName));
        dc.createAlias("device", "device");
        dc.add((Criterion)Restrictions.eq((String)"device.name", (Object)deviceName));
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List list = as.findDirectoriesByCriteria(dc);
        return !list.isEmpty();
    }

    public static boolean DoesDocClassExist(String sDocClassName) throws Exception {
        log.trace((Object)("************ DoesDocClassExist(sDocClassName=" + sDocClassName + ") ************"));
        boolean bExists = false;
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        DocumentClass dc = dcs.getDocumentClass(sDocClassName, new String[0]);
        if (dc != null) {
            bExists = true;
        }
        return bExists;
    }

    public static boolean DoesActionExist(String sDocClassId, String sActionName) throws Exception {
        log.trace((Object)("************ DoesActionExist(sDocClassId=" + sDocClassId + ", sActionName=" + sActionName + ") ************"));
        boolean bExists = false;
        DocumentClassActionFinder dcas = FinderFactory.getDocumentClassActionFinder();
        List actions = dcas.findByDocumentClass(new Long(sDocClassId));
        for (DocumentClassAction oneAction : actions) {
            String thisActionName;
            if (oneAction == null || (thisActionName = oneAction.getName()) == null || !thisActionName.equalsIgnoreCase(sActionName)) continue;
            bExists = true;
            break;
        }
        return bExists;
    }

    public static boolean DoesTemplateExistForProcess(String sProcDefId, String sDocTemplateName) throws Exception {
        log.trace((Object)("************ DoesTemplateExistForProcess(sProcDefId=" + sProcDefId + ", sDocTemplateName=" + sDocTemplateName + ") ************"));
        boolean bExists = false;
        DocumentTemplateService dts = ServiceFactory.getDocumentTemplateService();
        List docTemplatesList = dts.getAllDocumentTemplatesForProcess(sProcDefId);
        for (DocumentTemplateTable oneDocTemplate : docTemplatesList) {
            String thisDocTemplateName = oneDocTemplate.getTemplateName();
            if (thisDocTemplateName == null || !thisDocTemplateName.equals(sDocTemplateName)) continue;
            bExists = true;
            break;
        }
        return bExists;
    }

    public static boolean DoesLinkExist(String sLinkName) throws Exception {
        log.trace((Object)("************ DoesLinkExist(sLinkName=" + sLinkName + ") ************"));
        boolean bExists = false;
        LinkService ls = (LinkService)SpringContext.getBean(LinkService.class);
        Link linkTable = ls.getByName(sLinkName, new String[0]);
        if (linkTable != null) {
            bExists = true;
        }
        return bExists;
    }

    public static boolean DoesDocumentViewExist(String sViewName, String sProcDefId) throws Exception {
        log.trace((Object)("************ DoesDocumentViewExist(sViewName=" + sViewName + ", sProcDefId=" + sProcDefId + ") ************"));
        boolean bExists = false;
        List documentViews = DocumentViewsMethods.getAllDocumentViews();
        if (documentViews != null && documentViews.size() > 0) {
            for (DocumentViewsTable documentView : documentViews) {
                String thidProcDefId;
                String thisViewName;
                if (documentView == null || (thisViewName = documentView.getDocument_view_name()) == null || !thisViewName.equalsIgnoreCase(sViewName) || !(thidProcDefId = documentView.getProc_def_id()).equalsIgnoreCase(sProcDefId)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    public static long CreateIndexForDocClass(String docClassId, String sIndexName, String sIndexDesc, String sIndexType, String sIndexStartValue) {
        log.trace((Object)("************ CreateIndexForDocClass(docClassId=" + docClassId + ", sIndexName=" + sIndexName + ", sIndexDesc=" + sIndexDesc + ", sIndexType=" + sIndexType + ", sIndexStartValue=" + sIndexStartValue + ") ************"));
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        DocumentClassIndex index = new DocumentClassIndex();
        index.setName(sIndexName);
        index.setDescription(sIndexDesc);
        index.setType(IndexType.getType((String)sIndexType));
        index.setValues(sIndexStartValue);
        dcs.addIndexToDocumentClass(new Long(docClassId), index);
        return index.getId();
    }

    public static Long GetIndexIdForDocClass(String sClassName, String sIndex) {
        log.trace((Object)("************ GetIndexIdForDocClass(sClassName=" + sClassName + ", sIndex=" + sIndex + ") ************"));
        DocumentClassIndexFinder dcis = FinderFactory.getDocumentClassIndexFinder();
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        DocumentClass dc = dcs.getDocumentClass(sClassName, new String[0]);
        List indexes = dcis.findByDocumentClass(dc.getId());
        for (DocumentClassIndex indexTable : indexes) {
            String indexName;
            if (indexTable == null || (indexName = indexTable.getName()) == null || !sIndex.equals(indexName)) continue;
            return indexTable.getId();
        }
        return null;
    }

    public static ArrayList<DocumentData> FindDocumentsInDocClass(String sDocClassName, String sFrom, String sTo) {
        log.trace((Object)("************ FindDocumentsInDocClass(sDocClassName=" + sDocClassName + ", sFrom=" + sFrom + ", sTo=" + sTo + ") ************"));
        ArrayList listOfDocs = null;
        DocumentClassIndexFinder dcis = FinderFactory.getDocumentClassIndexFinder();
        try {
            HashMap hmIndecies;
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            DocumentClass dc = dcs.getDocumentClass(sDocClassName, new String[0]);
            if (dc == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + sDocClassName + " nie istnieje w systemie");
            }
            List indexesForDocClass = dcis.findByDocumentClass(dc.getId());
            if (indexesForDocClass != null && indexesForDocClass.size() > 0) {
                hmIndecies = new HashMap();
                for (int i = 0; i < indexesForDocClass.size(); ++i) {
                    hmIndecies.put(indexesForDocClass.get(i), "");
                }
            } else {
                throw new CUFException("Klasa dokumentow " + sDocClassName + " nie posiada indeksow");
            }
            listOfDocs = DBManagement.SearchDocClass(hmIndecies, (String)dc.getId().toString(), (String)"admin", (String)sFrom, (String)sTo, (int)0, (int)0, (int)0, (int)0, (long)0L);
            if (listOfDocs != null && listOfDocs.size() > 0) {
                log.info((Object)("Znaleziono " + listOfDocs.size() + " dokumentow w podanym przedziale czasowym w klasie dokumentow " + sDocClassName));
            } else {
                log.info((Object)("Nie znaleziono dokumentow w podanym przedziale czasowym w klasie dokumentow " + sDocClassName));
            }
            return listOfDocs;
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String GetDocClassNameForDocument(String sFileId) {
        log.trace((Object)("************ GetDocClassNameForDocument(sFileId=" + sFileId + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[]{"documentClass"});
        return file.getDocumentClass().getName();
    }

    public static String GetDocIdForDocument(String sFileId) {
        log.trace((Object)("************ GetDocIdForDocument(sFileId=" + sFileId + ") ************"));
        String sDocId = "";
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[]{"documentClass", "version"});
        WfFile newest = file.getVersion().getNewestFile();
        Map indexData = fs.getIndexData(newest.getId(), file.getDocumentClass().getId().longValue());
        Long idxId = (Long)indexData.get("id");
        return idxId.toString();
    }

    public static ArrayList<IndexData> GetAllIndexesForDocument(String sFileId) {
        log.trace((Object)("************ GetAllIndexesForDocument(sFileId=" + sFileId + ") ************"));
        ArrayList allIndecies = null;
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[0]);
        file.getVersion().getNewestFile();
        Long dcId = file.getDocumentClass().getId();
        Map indexData = fs.getIndexData(file.getId(), dcId.longValue());
        Long docId = (Long)indexData.get("id");
        DocumentData documentData = dbm.GetDocument(dcId.toString(), docId.toString());
        allIndecies = (ArrayList)documentData.getAlIndecies();
        return allIndecies;
    }

    public static String GetExpirationDateForDocument(String sFileId) {
        log.trace((Object)("************ GetExpirationDateForDocument(sFileId=" + sFileId + ") ************"));
        String sExpirationDate = "";
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[0]);
        Map index = fs.getIndexData(file.getId(), file.getDocumentClass().getId().longValue());
        DocumentData documentData = new DocumentData(index);
        return documentData.getSExpiretionDate();
    }

    public static String GetVersionForFile(String fileId) {
        log.trace((Object)("************ GetVersionForFile(fileId=" + fileId + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFileVersion v = fs.getVersionForFile(new Long(fileId));
        return String.valueOf(v.getVersion());
    }

    public static String GetCommentForFile(String sFileId) {
        log.trace((Object)("************ GetCommentForFile(sFileId=" + sFileId + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFileVersion v = fs.getVersionForFile(new Long(sFileId));
        return v.getComment();
    }

    public static String GetStateForFile(String sFileId) {
        log.trace((Object)("************ GetStateForFile(sFileId=" + sFileId + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFileVersion v = fs.getVersionForFile(new Long(sFileId));
        return v.getState();
    }

    public static List<WfFileVersion> GetAllVersionsOfFile(Long fileId) {
        log.trace((Object)("************ GetAllVersionsOfFile(fileId=" + String.valueOf(fileId) + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(fileId, new String[]{"version"});
        Long newestId = file.getVersion().getNewestFile().getId();
        QueryExecutor qe = (QueryExecutor)SpringContext.getBean(QueryExecutor.class);
        DetachedCriteria dc = DetachedCriteria.forClass(WfFileVersion.class);
        dc.add((Criterion)Restrictions.eq((String)"newestFile.id", (Object)fileId));
        List versions = qe.findByCriteria(dc);
        return versions;
    }

    public static DocumentVersions GetDocumentVersions(String sFileId) {
        DocumentVersions versions = null;
        PlusWorkflowDocument[] docTab = null;
        List<WfFileVersion> fileVersions = null;
        Object file = null;
        Long lFileId = null;
        ArrayList<PlusWorkflowDocument> tempList = null;
        int tabCounter = 0;
        fileVersions = ArchiveServices.GetAllVersionsOfFile(lFileId);
        tempList = new ArrayList<PlusWorkflowDocument>();
        for (int i = fileVersions.size() - 1; i >= 0; --i) {
            PlusWorkflowDocument doc;
            Long thisFileId;
            WfFileVersion fileVersion = fileVersions.get(i);
            if (fileVersion == null || (thisFileId = Long.valueOf(fileVersion.getFile().getId())) == null || (doc = ArchiveServices.GetDocument(thisFileId.toString())) == null) continue;
            tempList.add(doc);
        }
        docTab = new PlusWorkflowDocument[tempList.size()];
        Iterator iterator = tempList.iterator();
        while (iterator.hasNext()) {
            PlusWorkflowDocument doc;
            docTab[tabCounter] = doc = (PlusWorkflowDocument)iterator.next();
            ++tabCounter;
        }
        versions = new DocumentVersions();
        versions.setVersions(docTab);
        return versions;
    }

    public static String GetNewestVersionDocFileId(String docClassName, String docId) {
        log.trace((Object)("************ GetNewestVersionDocFileId(docClassName=" + docClassName + ", docId=" + docId + ") **********"));
        String sExpirationDate = "";
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(docId), new String[]{"version"});
        return String.valueOf(file.getVersion().getNewestFile().getId());
    }

    public static boolean ChangeDescriptionForFile(String sFileId, String sDescription) {
        log.trace((Object)("************ ChangeDescriptionForFile(sFileId=" + sFileId + ", sDescription=" + sDescription + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[0]);
        file.setDescription(sDescription);
        fs.updateFile(file);
        return true;
    }

    public static boolean SaveCommentForFile(String sFileId, String sComment) {
        log.trace((Object)("************ SaveCommentForFile(sFileId=" + sFileId + ", sComment=" + sComment + ") ************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        WfFile file = fs.getFile(new Long(sFileId), new String[]{"version"});
        WfFileVersion v = file.getVersion();
        v.setComment(sComment);
        QueryExecutor qe = (QueryExecutor)SpringContext.getBean(QueryExecutor.class);
        qe.update((Object)v);
        return true;
    }

    public static List<String> GetDocumentsAddedInActivity(String processId, String activityId) throws Exception {
        log.trace((Object)("************************* GetDocumentsAddedInActivity(processId=" + processId + ", activityId=" + activityId + ") ********************"));
        FileFinder ff = FinderFactory.getFileFinder();
        List acts = ff.getDocumentsFromActivity(processId, activityId, new String[0]);
        ArrayList<String> fileIds = new ArrayList<String>();
        for (WfFile wfFile : acts) {
            fileIds.add(String.valueOf(wfFile.getId()));
        }
        return fileIds;
    }

    public static List<String> GetDocumentsAddedInActivity(SharkTransaction st, String processId, String activityId) throws Exception {
        log.trace((Object)("************************* GetDocumentsAddedInActivity(SharkTransaction, processId=" + processId + ", activityId=" + activityId + ") ********************"));
        ArrayList<String> docIdsList = new ArrayList<String>();
        List<Object> previousDocIdsList = null;
        Object o = null;
        String DocIds = "";
        Map activityCtxMap = SharkClientFunctions.getActivityContextMap(st, processId, activityId);
        o = activityCtxMap.get("DocIds");
        if (o == null) {
            throw new CUFException("Brak mo\u017cliwo\u015bci zweryfikowania dokument\u00f3w pod\u0142\u0105czonych do procesu.");
        }
        DocIds = o.toString();
        docIdsList.addAll(Arrays.asList(DocIds.split(",")));
        WfActivity prevoiusActivity = SharkClientFunctions.getPreviousActivity(st, processId, activityId);
        String previousDocIds = "";
        if (prevoiusActivity != null) {
            String previousActivityId = prevoiusActivity.key(st);
            Map previousActivityCtxMap = SharkClientFunctions.getActivityContextMap(st, processId, previousActivityId);
            o = previousActivityCtxMap.get("DocIds");
            if (o != null) {
                previousDocIds = o.toString();
            }
            previousDocIdsList = Arrays.asList(previousDocIds.split(","));
        }
        if (previousDocIdsList == null) {
            previousDocIdsList = new ArrayList();
        }
        for (String previousFileId : previousDocIdsList) {
            docIdsList.remove(previousFileId);
        }
        return docIdsList;
    }

    public static String[] PrepareIndeciesValuesForKeys(String sDocClassId, String sFileId, String sKeys) {
        log.trace((Object)("************ PrepareIndeciesValuesForKeys(sDocClassId=" + sDocClassId + ", sFileId=" + sFileId + ", sKeys=" + sKeys + ") ************"));
        try {
            String[] splitKeys = sKeys.split(",");
            String[] checkForIndecies = new String[splitKeys.length];
            DocumentData docData = DBManagement.GetDocumentByFileId((String)sDocClassId, (String)sFileId);
            List indexes = docData.getAlIndecies();
            block2: for (int j = 0; j < splitKeys.length; ++j) {
                for (int k = 0; k < indexes.size(); ++k) {
                    if (indexes.get(k) == null || !splitKeys[j].equalsIgnoreCase(((IndexData)indexes.get(k)).getName())) continue;
                    checkForIndecies[j] = splitKeys[j] + "=" + ((IndexData)indexes.get(k)).getValue();
                    continue block2;
                }
            }
            return checkForIndecies;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object[] ConnectIndexesWithIDs(String[] indeciesIDs, String[] indeciesValuesForDocument) {
        log.trace((Object)"************ ConnectIndexesWithIDs(String[], String[]) ************");
        Object[] asIndecies = new Object[indeciesIDs.length];
        try {
            block2: for (int j = 0; j < indeciesIDs.length; ++j) {
                String[] secondWfSplit = indeciesIDs[j].split(";", -1);
                for (int k = 0; k < indeciesValuesForDocument.length; ++k) {
                    String[] firstWfSplit = indeciesValuesForDocument[k].split("=", -1);
                    if (!firstWfSplit[0].equalsIgnoreCase(secondWfSplit[1])) continue;
                    asIndecies[j] = secondWfSplit[0] + "=" + firstWfSplit[1];
                    continue block2;
                }
            }
            return asIndecies;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String CheckIfDocumentExists(String sClassName, String[] indexes) {
        String foundId;
        block10: {
            log.trace((Object)("************ CheckIfDocumentExists(sClassName=" + sClassName + ", String[]) ************"));
            foundId = "-1";
            DBManagement dbm = new DBManagement();
            try {
                DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
                if (docClassTable == null) {
                    throw new CUFException("Klasa dokumentow o nazwie " + sClassName + " nie istnieje w systemie");
                }
                if (indexes == null || indexes.length == 0) {
                    throw new CUFException("Nie podano indeksow do wyszukiwania dokumentu");
                }
                String docClassId = docClassTable.getId().toString();
                ArrayList indexesForDocClass = DBManagement.GetAllIndecies((String)docClassId);
                HashMap<IndexTable, String> hmIndecies = new HashMap<IndexTable, String>();
                block3: for (int i = 0; i < indexes.length; ++i) {
                    for (int j = 0; j < indexesForDocClass.size(); ++j) {
                        IndexTable indexTable = (IndexTable)indexesForDocClass.get(j);
                        if (indexTable == null) continue;
                        String[] nameAndValueTable = indexes[i].split("=");
                        Long id = indexTable.getId();
                        String indexName = null;
                        if (id != null) {
                            IndexTable help = DBManagement.getIndex((String)id.toString());
                            if (help != null) {
                                indexName = help.getIndexName();
                            }
                        }
                        if (indexName == null || !indexName.equalsIgnoreCase(nameAndValueTable[0])) continue;
                        hmIndecies.put(indexTable, nameAndValueTable[1]);
                        continue block3;
                    }
                }
                ArrayList listOfDocs = DBManagement.SearchDocClass(hmIndecies, (String)docClassId, (String)"admin", (String)"", (String)"", (int)0, (int)0, (int)0, (int)0, (long)0L);
                if (listOfDocs == null || listOfDocs.size() <= 0) break block10;
                for (int i = 0; i < listOfDocs.size(); ++i) {
                    Long fileId = ((DocumentData)listOfDocs.get(i)).getLFileId();
                    if (fileId == null) continue;
                    foundId = String.valueOf(fileId);
                    break;
                }
            }
            catch (CUFException e) {
                log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return foundId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlusWorkflowDocument GetDocument(String sFileId) {
        PlusWorkflowDocument doc;
        block21: {
            log.trace((Object)("************ GetDocument(sFileId=" + sFileId + ") ************"));
            doc = null;
            FilesManager filesManager = new FilesManager();
            DBManagement dbm = new DBManagement();
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            File oFife = null;
            InputStream inStream = null;
            byte[] buffer = null;
            try {
                ArrayList docClasses;
                WfFile file = fs.getFile(new Long(sFileId), new String[0]);
                if (file == null) {
                    throw new CUFException("Nie znaleziono dokumentu o identyfikatorze pliku " + sFileId);
                }
                log.info((Object)("Znaleziono dokument o identyfikatorze " + sFileId + ". Uzupelnianie informacji o dokumencie"));
                doc = new PlusWorkflowDocument();
                String fileName = file.getFileName();
                doc.setFileId(file.getId());
                doc.setDocName(file.getFileName());
                doc.setOrgDocName(file.getSystemFileName());
                int lastDotPos = fileName.lastIndexOf(".");
                if (lastDotPos != -1 && lastDotPos != fileName.length()) {
                    String ext = fileName.substring(lastDotPos + 1, fileName.length());
                    doc.setExt(ext);
                }
                doc.setDescr(file.getDescription());
                doc.setUploader(file.getUploader());
                doc.setIsCompressed(String.valueOf(file.isCompressed()));
                doc.setIsEncrypted(String.valueOf(file.isEncrypted()));
                doc.setCipherAlgorithm(file.getCipherAlgorithm());
                doc.setCipherKey(file.getCipherKey());
                Date uploadDate = file.getFileDate();
                if (uploadDate != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String sUploadDate = sdf.format(uploadDate);
                    doc.setUploadDate(sUploadDate);
                }
                doc.setSize(file.getSize());
                doc.setVersion(ArchiveServices.GetVersionForFile(sFileId));
                doc.setComment(ArchiveServices.GetCommentForFile(sFileId));
                doc.setState(ArchiveServices.GetStateForFile(sFileId));
                String path = file.getPath() + fileName;
                oFife = new File(path);
                if (oFife != null && oFife.exists() && (inStream = new FileInputStream(oFife)) != null && inStream.available() > 0) {
                    buffer = new byte[inStream.available()];
                    buffer = IOUtils.toByteArray((InputStream)inStream);
                    doc.setBytes(buffer);
                }
                if ((docClasses = dbm.GetAllDocClasses()) == null || docClasses.size() <= 0) break block21;
                for (DocClassTable docClass : docClasses) {
                    Long lDocClassId;
                    if (docClass == null || (lDocClassId = docClass.getId()) == null) continue;
                    DocumentData documentData = DBManagement.GetDocumentByFileId((String)lDocClassId.toString(), (String)sFileId);
                    if (documentData == null) continue;
                    doc.setDocClassName(docClass.getDocClassName());
                    doc.setDocClassId(lDocClassId);
                    doc.setDocId(documentData.getLDocumentId());
                    break;
                }
            }
            catch (CUFException e) {
                doc = null;
                log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                doc = null;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return doc;
    }

    public static int AddFileToArchive(String sClassName, String[] asIndicies, byte[] bytes, String sFileName, String sDescription, String sNewVersion, String sLogin) {
        log.trace((Object)("************ AddFileToArchive(sClassName=" + sClassName + ", String[], byte[], sFileName=" + sFileName + ", sDescription=" + sDescription + ", sNewVersion=" + sNewVersion + ", sLogin=" + sLogin + ") ************"));
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        return ArchiveServices.AddFileToArchive(sClassName, asIndicies, bis, sFileName, sDescription, sNewVersion, sLogin);
    }

    private static int AddFileToArchive(String sClassName, String[] asIndicies, InputStream is, String sFileName, String sDescription, String sNewVersion, String sLogin) {
        log.trace((Object)("************ AddFileToArchive(sClassName=" + sClassName + ", String[], byte[], sFileName=" + sFileName + ", sDescription=" + sDescription + ", sNewVersion=" + sNewVersion + ", sLogin=" + sLogin + ") ************"));
        boolean newVersion = false;
        if (StringUtils.isNotBlank((String)sNewVersion) && sNewVersion.equalsIgnoreCase("true")) {
            newVersion = true;
        }
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        FileSaver saver = fs.getFileSaver();
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        DocumentClass dc = dcs.getDocumentClass(sClassName, new String[0]);
        Map<Long, Object> indexes = ArchiveServices.convertIndexes(asIndicies);
        fs.convertIndexTypes(indexes, dc.getId().longValue());
        try {
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(dc.getId());
            fd.setFileName(sFileName);
            fd.setDescription(sDescription);
            fd.setUserName(sLogin);
            fd.setIndexes(indexes);
            fd.setInputStream(is);
            fd.setSaveAsNewVersion(newVersion);
            WfFile file = saver.addFile(fd);
            return (int)file.getId();
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    private static Map<Long, Object> convertIndexes(String[] asIndicies) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        for (String idx : asIndicies) {
            String[] split = idx.split("=");
            Long id = Long.valueOf(split[0]);
            String value = split.length > 1 ? split[1] : "";
            indexes.put(id, value);
        }
        return indexes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int AddFileToArchive(String sClassName, String[] asIndicies, File fFile, String sDescription, String sNewVersion, String sLogin) {
        log.trace((Object)("************ AddFileToArchive(sClassName=" + sClassName + ", String[], File, sDescription=" + sDescription + ", sNewVersion=" + sNewVersion + ", sLogin=" + sLogin + ") ************"));
        try (FileInputStream fis = new FileInputStream(fFile);){
            int n = ArchiveServices.AddFileToArchive(sClassName, asIndicies, fis, fFile.getName(), sDescription, sNewVersion, sLogin);
            return n;
        }
        catch (IOException e) {
            throw new CUFServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int TransferFileToArchive(String sURL, String sFileId, String sLogin, String sPassword, String sDomain, String sClassName, String sNewVersion, String[] asIndicies) {
        log.trace((Object)("************ TransferFileToArchive(sURL=" + sURL + ", sFileId=" + sFileId + ", sLogin, sPassword, sDomain=" + sDomain + ", sClassName=" + sClassName + ", sNewVersion=" + sNewVersion + ", asIndicies) ************"));
        int nFileId = -1;
        PlusWorkflowDocument document = null;
        File file = null;
        DBManagement dbm = new DBManagement();
        DocClassTable docClassTable = null;
        OutputStream out = null;
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        String uploader = "admin";
        try {
            docClassTable = dbm.getDocClassByName(sClassName);
            if (docClassTable == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + sClassName + " nie istnieje w systemie");
            }
            Long lDocClassId = docClassTable.getId();
            if (lDocClassId == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + sClassName + " nie posiada identyfikatora");
            }
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            String sDocClassDirPath = dcs.getFullPathForDocClass(lDocClassId);
            if (StringUtils.isBlank((String)sDocClassDirPath)) {
                throw new CUFException("Nie uzyskano sciezki do katalogu klasy dokumentow o nazwie " + sClassName);
            }
            if (!sDocClassDirPath.endsWith("/") && !sDocClassDirPath.endsWith("\\")) {
                sDocClassDirPath = sDocClassDirPath + "/";
            }
            if ((document = ArchiveServices.GetDocumentWS(sURL, sFileId, sLogin, sPassword, sDomain)) == null) {
                throw new CUFException("Nie znaleziono pliku o identyfikatorze " + sFileId + " w systemie o adresie " + sURL);
            }
            String fullFilePath = sDocClassDirPath + document.getOrgDocName();
            file = new File(fullFilePath);
            if (!file.createNewFile()) {
                throw new CUFException("Nie udalo sie utworzyc pobranego pliku w obecnym systemie");
            }
            out = new FileOutputStream(file);
            out.write(document.getBytes());
            out.flush();
            if (uga.doesUserExist(document.getUploader())) {
                uploader = document.getUploader();
            }
            nFileId = ArchiveServices.AddFileToArchive(sClassName, asIndicies, file, document.getDescr(), sNewVersion, uploader);
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return nFileId;
    }

    private static int AddFileToClass(String sClassId, String userName, String sDescription, File fFile) {
        log.trace((Object)("********** AddFileToClass(sClassId=" + sClassId + ", userName=" + userName + ", sDescription=" + sDescription + ", File) ******************"));
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        try {
            FileInputStream is = new FileInputStream(fFile);
            FileSaver saver = fs.getFileSaver();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(new Long(sClassId));
            fd.setFileName(fFile.getName());
            fd.setDescription(sDescription);
            fd.setUserName(userName);
            fd.setInputStream((InputStream)is);
            WfFile file = saver.addFile(fd);
            log.info((Object)"Dodano plik do archiwum");
            int id = (int)file.getId();
            return id;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static int SaveAsNewVersion(String sFileId, String sFileName, String sPageCount, String sDescription, String sOCRContent, String sLogin, byte[] bytes) {
        log.trace((Object)("************ SaveAsNewVersion(sFileId=" + sFileId + ", sFileName=" + sFileName + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent, sLogin=" + sLogin + ", byte[]) ************"));
        int iFileId = -1;
        Long lFileId = null;
        String sClassName = "";
        String[] asIndicies = null;
        ArrayList<String> forAsIndicies = null;
        WfFile file = null;
        ArrayList<IndexData> allIndecies = null;
        try {
            if (StringUtils.isBlank((String)sFileId)) {
                throw new CUFException("Nie podano identyfikatora pliku");
            }
            try {
                lFileId = Long.parseLong(sFileId);
                if (lFileId < 1L) {
                    throw new CUFException("Identyfikator pliku nie jest wartoscia dodatnia");
                }
            }
            catch (NumberFormatException e) {
                throw new CUFException("Identyfikator pliku nie jest wartoscia liczbowa");
            }
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            file = fs.getFile(lFileId, new String[0]);
            if (file == null) {
                throw new CUFException("Dokument o identyfikatorze pliku " + sFileId + " nie istnieje w systemie");
            }
            sClassName = ArchiveServices.GetDocClassNameForDocument(sFileId);
            if (StringUtils.isBlank((String)sClassName)) {
                throw new CUFException("Nie uzyskano klasy dokumentow");
            }
            allIndecies = ArchiveServices.GetAllIndexesForDocument(sFileId);
            if (allIndecies != null && allIndecies.size() > 0) {
                forAsIndicies = new ArrayList<String>();
                for (IndexData indexData : allIndecies) {
                    String indexId;
                    String indexValue = indexData.getValue();
                    if (StringUtils.isBlank((String)indexValue) || StringUtils.isBlank((String)(indexId = String.valueOf(indexData.getId())))) continue;
                    forAsIndicies.add(indexId + "=" + indexValue);
                }
                if (forAsIndicies != null && forAsIndicies.size() > 0) {
                    asIndicies = new String[forAsIndicies.size()];
                    int counter = 0;
                    Iterator iterator = forAsIndicies.iterator();
                    while (iterator.hasNext()) {
                        String indexMapping;
                        asIndicies[counter] = indexMapping = (String)iterator.next();
                        ++counter;
                    }
                }
            }
            if ((iFileId = ArchiveServices.AddFileToArchive(sClassName, asIndicies, bytes, sFileName, sDescription, "true", sLogin)) > 0) {
                log.info((Object)("Dodano nowa wersje dokumentu dla dokumentu o identyfikatorze pliku " + sFileId));
            } else {
                log.warn((Object)("Wystapil blad podczas dodawania nowej wersji dokumentu dla dokumentu o identyfikatorze pliku " + sFileId));
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return iFileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpdateDocumentContent(String sFileId, byte[] bytes) {
        boolean bResult = false;
        Long lFileId = null;
        WfFile file = null;
        String filePath = "";
        FileOutputStream fos = null;
        try {
            if (StringUtils.isBlank((String)sFileId)) {
                throw new CUFException("Nie podano identyfikatora pliku");
            }
            try {
                lFileId = Long.parseLong(sFileId);
                if (lFileId < 1L) {
                    throw new CUFException("Identyfikator pliku nie jest wartoscia dodatnia");
                }
            }
            catch (NumberFormatException e) {
                throw new CUFException("Identyfikator pliku nie jest wartoscia liczbowa");
            }
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            file = fs.getFile(lFileId, new String[0]);
            if (file == null) {
                throw new CUFException("Dokument o identyfikatorze pliku " + sFileId + " nie istnieje w systemie");
            }
            filePath = file.getFullPath();
            if (StringUtils.isBlank((String)filePath)) {
                throw new CUFException("Brak sciezki do dokumentu o identyfikatorze pliku " + sFileId);
            }
            if (bytes == null || bytes.length == 0) {
                throw new CUFException("Brak bajtow dokumentu");
            }
            fos = new FileOutputStream(filePath);
            fos.write(bytes, 0, bytes.length);
            log.info((Object)("Uaktualniono zawartosc dokumentu o identyfikatorze pliku " + sFileId));
            bResult = true;
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean MoveDocIdsBetweenDocClasses(String DocIds, String sourceDocClassName, String destDocClassName, boolean bCopyIndexes, boolean bExecuteAddActions) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(DocIds=" + DocIds + ", sourceDocClassName=" + sourceDocClassName + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ", bExecuteAddActions=" + String.valueOf(bExecuteAddActions) + ") ************"));
        boolean bSuccess = false;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            bSuccess = ArchiveServices.MoveDocIdsBetweenDocClasses(st, DocIds, sourceDocClassName, destDocClassName, bCopyIndexes, bExecuteAddActions);
            st.commit();
        }
        catch (Exception e) {
            try {
                if (st != null) {
                    Shark.getInstance().emptyCaches(st);
                }
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                if (st != null) {
                    st.rollback();
                }
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    SharkFunctions.ClearSharkTransaction((SharkTransaction)st);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return bSuccess;
    }

    public static boolean MoveDocIdsBetweenDocClasses(SharkTransaction st, String DocIds, String sourceDocClassName, String destDocClassName, boolean bCopyIndexes, boolean bExecuteAddActions) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(SharkTransaction, DocIds=" + DocIds + ", sourceDocClassName=" + sourceDocClassName + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ", bExecuteAddActions=" + String.valueOf(bExecuteAddActions) + ") ************"));
        boolean bSuccess = true;
        String[] DocIdsTab = null;
        DocClassTable sourceDocClassTable = null;
        Long lSourceDocClassId = null;
        String sSourceDocClassId = null;
        DocumentData documentData = null;
        DBManagement dbm = new DBManagement();
        try {
            if (StringUtils.isBlank((String)DocIds)) {
                throw new CUFException("Brak identyfikatorow dokumentow");
            }
            if (StringUtils.isBlank((String)sourceDocClassName)) {
                throw new CUFException("Nie podano nazwy zrodlowej klasy dokumentow");
            }
            if (StringUtils.isBlank((String)destDocClassName)) {
                throw new CUFException("Nie podano nazwy docelowej klasy dokumentow");
            }
            sourceDocClassTable = dbm.getDocClassByName(sourceDocClassName);
            if (sourceDocClassTable == null) {
                throw new CUFException("Zrodlowa klasa dokumentow o nazwie " + sourceDocClassName + " nie istnieje w systemie");
            }
            lSourceDocClassId = sourceDocClassTable.getId();
            if (lSourceDocClassId == null) {
                throw new CUFException("Zrodlowa klasa dokumentow o nazwie " + sourceDocClassName + " nie posiada identyfikatora");
            }
            sSourceDocClassId = lSourceDocClassId.toString();
            for (String fileId : DocIdsTab = DocIds.split(",")) {
                documentData = DBManagement.GetDocumentByFileId((String)sSourceDocClassId, (String)fileId);
                if (documentData == null) {
                    log.info((Object)("Dokument o identyfikatorze " + fileId + " nie nalezy do klasy dokumentow o nazwie " + sourceDocClassName + ". Nie bedzie przenoszony do klasy " + destDocClassName));
                    continue;
                }
                log.info((Object)("Dokument o identyfikatorze " + fileId + " nalezy do klasy dokumentow o nazwie " + sourceDocClassName + ". Bedzie przenoszony do klasy " + destDocClassName));
                bSuccess = ArchiveServices.MoveDocumentBetweenDocClasses(st, fileId, destDocClassName, bCopyIndexes, bExecuteAddActions);
                if (bSuccess) continue;
                throw new CUFException("Wystapil blad podczas przenoszenia jednego z dokumentow miedzy klasami " + sourceDocClassName + " a " + destDocClassName + ". Przerwanie procesu przenoszenia dokumentow");
            }
        }
        catch (CUFException e) {
            bSuccess = false;
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            bSuccess = false;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bSuccess;
    }

    public static boolean MoveDocumentBetweenDocClasses(String sFileId, String destDocClassName, boolean bCopyIndexes) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(SharkTransaction, sFileId=" + sFileId + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ") ************"));
        return ArchiveServices.MoveDocumentBetweenDocClasses(sFileId, destDocClassName, bCopyIndexes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean MoveDocumentBetweenDocClasses(String sFileId, String destDocClassName, boolean bCopyIndexes, boolean bExecuteAddActions) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(sFileId=" + sFileId + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ", bExecuteAddActions=" + String.valueOf(bExecuteAddActions) + ") ************"));
        boolean bSuccess = false;
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            bSuccess = ArchiveServices.MoveDocumentBetweenDocClasses(st, sFileId, destDocClassName, bCopyIndexes, bExecuteAddActions);
            st.commit();
        }
        catch (Exception e) {
            try {
                if (st != null) {
                    Shark.getInstance().emptyCaches(st);
                }
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                if (st != null) {
                    st.rollback();
                }
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    SharkFunctions.ClearSharkTransaction((SharkTransaction)st);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return bSuccess;
    }

    public static boolean MoveDocumentBetweenDocClasses(SharkTransaction st, String sFileId, String destDocClassName, boolean bCopyIndexes) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(SharkTransaction, sFileId=" + sFileId + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ") ************"));
        return ArchiveServices.MoveDocumentBetweenDocClasses(st, sFileId, destDocClassName, bCopyIndexes, true);
    }

    public static boolean MoveDocumentBetweenDocClasses(SharkTransaction st, String sFileId, String destDocClassName, boolean bCopyIndexes, boolean bExecuteAddActions) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(SharkTransaction, sFileId=" + sFileId + ", destDocClassName=" + destDocClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ", bExecuteAddActions=" + String.valueOf(bExecuteAddActions) + ") ************"));
        boolean res = false;
        DBManagement dbm = new DBManagement();
        DocumentClass destDocClassTable = null;
        Long lDestDocClassId = null;
        WfFile file = null;
        File newFile = null;
        Long lFileId = null;
        boolean bFileMoved = false;
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        try {
            if (StringUtils.isBlank((String)sFileId)) {
                throw new CUFException("Nie podano identyfikatora pliku");
            }
            try {
                lFileId = Long.parseLong(sFileId);
                if (lFileId < 1L) {
                    throw new CUFException("Identyfikator pliku nie jest wartoscia dodatnia");
                }
            }
            catch (NumberFormatException e) {
                throw new CUFException("Identyfikator pliku nie jest wartoscia liczbowa");
            }
            destDocClassTable = dcs.getDocumentClass(destDocClassName, new String[0]);
            if (destDocClassTable == null) {
                throw new CUFException("Docelowa klasa dokumentow o nazwie " + destDocClassName + " nie istnieje w systemie");
            }
            lDestDocClassId = destDocClassTable.getId();
            if (lDestDocClassId == null) {
                throw new CUFException("Docelowa klasa dokumentow o nazwie " + destDocClassName + " nie posiada identyfikatora");
            }
            DocumentData documentDataChecker = DBManagement.GetDocumentByFileId((String)lDestDocClassId.toString(), (String)sFileId);
            if (documentDataChecker != null) {
                throw new CUFException("Dokument o identyfikatorze " + sFileId + " znajduje sie juz w klasie dokumentow o nazwie " + destDocClassName);
            }
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            file = fs.getFile(lFileId, new String[0]);
            if (file == null) {
                throw new CUFException("Nie znaleziono dokumentu o identyfikatorze " + sFileId);
            }
            String sFileName = file.getFileName();
            String sFilePath = file.getPath();
            String sOldPath = sFilePath + sFileName;
            newFile = new File(sOldPath);
            if (newFile == null || !newFile.exists()) {
                throw new CUFException("Dokument nie istnieje w okreslonej dla niego lokalizacji " + sOldPath);
            }
            ArrayList allDocClasses = dbm.GetAllDocClasses();
            if (allDocClasses == null || allDocClasses.size() == 0) {
                throw new CUFException("Brak klas dokumentow w systemie");
            }
            for (DocClassTable docClassTable : allDocClasses) {
                boolean bSuccess;
                Long lDocClassId;
                if (docClassTable == null || (lDocClassId = docClassTable.getId()) == null || lDocClassId.longValue() == lDestDocClassId.longValue()) continue;
                String docClassName = docClassTable.getDocClassName();
                DocumentData documentData = DBManagement.GetDocumentByFileId((String)lDocClassId.toString(), (String)sFileId);
                if (documentData == null) continue;
                if (!bFileMoved) {
                    Long destDocClassId = destDocClassTable.getId();
                    ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
                    String sDocClassDirPath = as.resolveDirectoryPath(destDocClassTable.getDirectory(), file);
                    if (sDocClassDirPath != null && !sDocClassDirPath.equals(sFilePath)) {
                        File fileToMove = new File(sOldPath);
                        String sNewPath = sDocClassDirPath + sFileName;
                        boolean bSuccess2 = fileToMove.renameTo(new File(sNewPath));
                        if (!bSuccess2) {
                            throw new CUFException("Nie udalo sie przeniesc pliku do lokalizacji dla klasy dokumentow o nazwie " + destDocClassName);
                        }
                        file.setPath(sDocClassDirPath);
                        fs.updateFile(file);
                    }
                    HashMap<Long, String> hmMapping = new HashMap<Long, String>();
                    if (bCopyIndexes) {
                        log.info((Object)"Przepisywanie indeksow");
                        List allIndexes = documentData.getAlIndecies();
                        if (allIndexes != null && allIndexes.size() > 0) {
                            for (IndexData indexData : allIndexes) {
                                String destDocClassIndexType;
                                Long destDocClassIndexId;
                                if (indexData == null) continue;
                                Long id = indexData.getId();
                                String indexName = null;
                                String indexType = null;
                                if (id != null) {
                                    IndexTable help = DBManagement.getIndex((String)id.toString());
                                    if (help != null) {
                                        indexName = help.getIndexName();
                                        indexType = help.getIndexType();
                                    }
                                }
                                String indexValue = indexData.getValue();
                                if (indexName == null) {
                                    indexName = "";
                                }
                                if (indexValue == null) {
                                    indexValue = "";
                                }
                                if (indexType == null) {
                                    indexType = "";
                                }
                                if ((destDocClassIndexId = ArchiveServices.GetIndexIdForDocClass(destDocClassName, indexName)) != null) continue;
                                IndexTable help = DBManagement.getIndex((String)destDocClassIndexId.toString());
                                if (help == null || (destDocClassIndexType = help.getIndexType()) == null || !destDocClassIndexType.equalsIgnoreCase(indexType)) continue;
                                hmMapping.put(destDocClassIndexId, indexValue);
                                log.info((Object)(indexName + ": " + indexValue));
                            }
                        }
                    }
                    long iSuccess = -1L;
                    fs.changeFileIndexes(new Long(sFileId), hmMapping);
                    if (iSuccess == -1L) {
                        throw new CUFException("Nie udalo sie przeniesc pliku do klasy dokumentow o nazwie " + destDocClassName);
                    }
                    bFileMoved = true;
                }
                if (bSuccess = ArchiveServices.RemoveDocumentFromDocClass(docClassName, sFileId)) continue;
                throw new CUFException("Nie udalo sie poprawnie przeprowadzic procesu przenoszenia pliku do klasy dokumentow o nazwie " + destDocClassName + ". Wystapil blad podczas usuwania dokumentu z klasy " + docClassName);
            }
            res = true;
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean RemoveDocumentFromDocClass(String sDocClassName, String sFileId) {
        boolean res;
        block20: {
            Statement st;
            Connection con;
            block19: {
                log.trace((Object)("************ RemoveDocumentFromDocClass(sDocClassName=" + sDocClassName + ", sFileId=" + sFileId + ") ************"));
                con = null;
                st = null;
                res = false;
                DBManagement dbm = new DBManagement();
                DocClassTable docClassTable = dbm.getDocClassByName(sDocClassName);
                if (docClassTable == null) {
                    throw new CUFException("Klasa dokumentow o nazwie " + sDocClassName + " nie istnieje w systemie");
                }
                Long lDocClassId = docClassTable.getId();
                if (lDocClassId == null) {
                    throw new CUFException("Klasa dokumentow o nazwie " + sDocClassName + " nie posiada indentyfikatora");
                }
                String sIndexesTable = "pm_idx000" + lDocClassId.toString();
                String sQuery = "delete from " + sIndexesTable + " where fileid = '" + sFileId + "'";
                con = DBManagement.ConnectToDB();
                if (con != null && !con.isClosed()) {
                    st = con.createStatement();
                    log.info((Object)("Query: " + sQuery));
                    st.execute(sQuery);
                    res = true;
                }
                if (st == null) break block19;
                try {
                    st.close();
                }
                catch (SQLException sqle) {
                    log.error((Object)sqle.getMessage(), (Throwable)sqle);
                }
            }
            DBManagement.CloseConnection((Connection)con);
            break block20;
            catch (CUFException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                break block20;
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sqle) {
                        log.error((Object)sqle.getMessage(), (Throwable)sqle);
                    }
                }
                DBManagement.CloseConnection(con);
            }
        }
        return res;
    }

    public static boolean DeleteDocumentFromArchive(String sFileId) throws CUFException, Exception {
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        fs.deleteFile(Long.valueOf(sFileId));
        return true;
    }

    public static long AddFileToProcess(String processId, String activityId, String docClassName, String description, String hmMapping, boolean bNewVersion, String uploader, String tempFileLocation, String orgFileName) {
        log.trace((Object)("************ AddFileToProcess(processId=" + processId + ", activityId=" + activityId + ", docClassName=" + docClassName + ", description=" + description + ", hmMapping=" + hmMapping + ", bNewVersion=" + String.valueOf(bNewVersion) + ", uploader=" + uploader + ", tempFileLocation=" + tempFileLocation + ", orgFileName=" + orgFileName + ") ************"));
        return ArchiveServices.AddFileToProcess(processId, activityId, docClassName, description, hmMapping, bNewVersion, uploader, tempFileLocation, orgFileName, false);
    }

    public static long AddFileToProcess(String processId, String activityId, String docClassName, String description, String hmMapping, boolean bNewVersion, String uploader, String tempFileLocation, String orgFileName, boolean bOnlyDT) {
        log.trace((Object)("************ AddFileToProcess(processId=" + processId + ", activityId=" + activityId + ", docClassName=" + docClassName + ", description=" + description + ", hmMapping=" + hmMapping + ", bNewVersion=" + String.valueOf(bNewVersion) + ", uploader=" + uploader + ", tempFileLocation=" + tempFileLocation + ", orgFileName=" + orgFileName + ", bOnlyDT=" + String.valueOf(bOnlyDT) + ") ************"));
        return ArchiveServices.AddFileToProcess(processId, activityId, docClassName, description, hmMapping, bNewVersion, uploader, tempFileLocation, orgFileName, false, true);
    }

    public static long AddFileToProcess(String processId, String activityId, String docClassName, String description, String hmMapping, boolean bNewVersion, String uploader, String tempFileLocation, String orgFileName, boolean bOnlyDT, boolean bExecuteActions) {
        log.trace((Object)("************ AddFileToProcess(processId=" + processId + ", activityId=" + activityId + ", docClassName=" + docClassName + ", description=" + description + ", hmMapping=" + hmMapping + ", bNewVersion=" + String.valueOf(bNewVersion) + ", uploader=" + uploader + ", tempFileLocation=" + tempFileLocation + ", orgFileName=" + orgFileName + ", bOnlyDT=" + String.valueOf(bOnlyDT) + ", bExecuteActions=" + String.valueOf(bExecuteActions) + ") ************"));
        try {
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            DocumentClass dc = dcs.getDocumentClass("docClassName", new String[0]);
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            FileInputStream fis = new FileInputStream(new File(tempFileLocation));
            Map<Long, Object> hmDocClassIndecies = ArchiveServices.DecomposeHmMapping(hmMapping, docClassName, ";", "=");
            FileSaver saver = fs.getFileSaver();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(dc.getId());
            fd.setFileName(orgFileName);
            fd.setDescription(description);
            fd.setUserName(uploader);
            fd.setInputStream((InputStream)fis);
            fd.setProcessId(processId);
            fd.setActivityId(activityId);
            fd.setIndexes(hmDocClassIndecies);
            WfFile file = saver.addFile(fd);
            int id = (int)file.getId();
            return id;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private static Map<Long, Object> DecomposeHmMapping(String hmMapping, String docClassName, String firstSplit, String secondSplit) throws Exception {
        HashMap<Long, Object> hmDocClassIndecies = new HashMap<Long, Object>();
        DBManagement dbm = new DBManagement();
        if (!StringUtils.isBlank((String)hmMapping)) {
            String[] semicolonSplit;
            for (String oneSemicolonSplit : semicolonSplit = hmMapping.split(firstSplit)) {
                Long indexId;
                String[] firstSplitTab = oneSemicolonSplit.split(secondSplit);
                if (firstSplitTab.length == 1 || (indexId = ArchiveServices.GetIndexIdForDocClass(docClassName, firstSplitTab[0])) == null) continue;
                String indexValue = "";
                String[] testSecondSplit = oneSemicolonSplit.split(secondSplit, -1);
                for (int k = 1; k < testSecondSplit.length; ++k) {
                    indexValue = k < testSecondSplit.length - 1 ? indexValue + testSecondSplit[k] + secondSplit : indexValue + testSecondSplit[k];
                }
                IndexTable index = DBManagement.getIndex((String)indexId.toString());
                if (index == null) continue;
                if (index.getIndexType().compareToIgnoreCase("integer") == 0) {
                    Long LValue = new Long(indexValue);
                    hmDocClassIndecies.put(indexId, LValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("float") == 0) {
                    Float FValue = null;
                    String sVariableValue = indexValue.replaceAll("[\\\\]", "");
                    sVariableValue = sVariableValue.replaceAll("[,]", ".");
                    sVariableValue = sVariableValue.replaceAll("[ ]", "");
                    FValue = new Float(sVariableValue);
                    hmDocClassIndecies.put(indexId, FValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("date") == 0) {
                    Date DValue = null;
                    try {
                        String sDate = indexValue;
                        sDate = sDate.replaceAll("[\\\\]", "/");
                        sDate = sDate.replaceAll("[-]", "/");
                        sDate = sDate.replaceAll("[.]", "/");
                        long time = Date.parse(sDate);
                        DValue = new Date(time);
                    }
                    catch (Exception e) {
                        DValue = new Date(0L);
                    }
                    hmDocClassIndecies.put(indexId, DValue);
                    continue;
                }
                hmDocClassIndecies.put(indexId, indexValue);
            }
        }
        return hmDocClassIndecies;
    }

    private static FileVersionsManager.DocumentActionResult saveIndexesOrNewVersionWithoutExecuteClassActions(SharkTransaction sharkTransaction, String fileId, String userName, String docClassId, HashMap<String, Object> indexes, DocClassTable docClassTable, boolean asNewVersionIfPossible) throws Exception {
        DocumentSearch documentSearch;
        List l;
        long iDocID = 0L;
        long parentFileId = 0L;
        boolean replaced = false;
        DBManagement dbm = new DBManagement();
        HashMap indexesMap = (HashMap)indexes.clone();
        indexesMap.remove("fileID");
        if (asNewVersionIfPossible && (l = (documentSearch = DocumentSearch.buildFromIndexesMap((String)userName, (long)0L, (String)docClassId, (Map)indexesMap)).list()).size() == 1) {
            parentFileId = ((ExtendedDocumentData)l.get(0)).getLFileId();
            iDocID = ((ExtendedDocumentData)l.get(0)).getLDocumentId();
        }
        if (parentFileId > 0L && iDocID >= 0L) {
            try {
                FileVersionsManager manager = new FileVersionsManager();
                long lFileId = Long.parseLong(fileId);
                replaced = manager.setExistingFileAsNewVersion(Long.valueOf(parentFileId), Long.valueOf(lFileId), userName, docClassId);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!replaced) {
            long lFileId = Long.parseLong(fileId);
            FileVersionsManager.setFileAsFirstVersion((Long)lFileId, (String)userName);
            iDocID = DBManagement.SaveIndeciesToDB((SharkTransaction)sharkTransaction, indexes, (DocClassTable)docClassTable, (long)Long.valueOf(fileId));
        }
        return new FileVersionsManager.DocumentActionResult(iDocID, parentFileId);
    }

    public static String CheckIfDocumentExistsWS(String sURL, String sDestClass, String[] indexes, String sLogin, String sPassword) {
        log.trace((Object)("************ CheckIfDocumentExistsWS(sURL=" + sURL + ", sDestClass=" + sDestClass + ", String[], sLogin, sPassword) ************"));
        String sExists = "-1";
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            log.info((Object)("Sprawdzanie czy dokument istnieje w systemie " + sURL + " w klasie dokumentow " + sDestClass));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            call.setOperationName(new QName("DoesDocumentExistInDocClass"));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke DoesDocumentExistInDocClass: User=" + sLogin + "; Class=" + sDestClass));
            Object[] params = new Object[]{sLogin, sPassword, sDestClass, indexes};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            Object result = call.invoke(params);
            if (result != null) {
                sExists = result.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sExists;
    }

    public static String[] GetDocClassesIDsWithNamesWS(String sURL, String sLogin, String sPassword) {
        log.trace((Object)("************ GetDocClassesIDsWithNamesWS(sURL=" + sURL + ", sLogin, sPassword) ************"));
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            log.info((Object)("Pobieranie identyfikatorow i nazw klas z systemu " + sURL));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            call.setOperationName(new QName("GetArchiveDocClasses"));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke GetArchiveDocClasses: User=" + sLogin));
            Object[] params = new Object[]{sLogin, sPassword};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            String sDocClasses = call.invoke(params).toString();
            String[] sDocClassesTable = sDocClasses.split("[$]");
            return sDocClassesTable;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String[] GetIndeciesIDsWithNamesWS(String sURL, String sDocClassId, String sLogin, String sPassword) {
        log.trace((Object)("************ GetIndeciesIDsWithNamesWS(sURL=" + sURL + ", sDocClassId=" + sDocClassId + ", sLogin, sPassword) ************"));
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            log.info((Object)("Pobieranie identyfikatorow i nazw indeksow z systemu " + sURL + " dla klasy dokumentow o identyfikatorze " + sDocClassId));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            call.setOperationName(new QName("GetArchiveDocClassIndecies"));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke GetArchiveDocClassIndecies: User=" + sLogin + "; docClassId=" + sDocClassId));
            Object[] params = new Object[]{sLogin, sPassword, sDocClassId};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            String indecies = call.invoke(params).toString();
            String[] indeciesTable = indecies.split("[$]");
            return indeciesTable;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String CheckVersionWS(String sURL, String sFoundFileId, String sLogin, String sPassword) {
        log.trace((Object)("************ CheckVersionWS(sURL=" + sURL + ", sFoundFileId=, sLogin, sPassword) ************"));
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            log.info((Object)("Sprawdzanie wersji dokumentu w systemie " + sURL + " dla identyfikatora pliku " + sFoundFileId));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            call.setOperationName(new QName("GetVersionForFile"));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke GetVersionForFile: User=" + sLogin + "; fileId=" + sFoundFileId));
            Object[] params = new Object[]{sLogin, sPassword, sFoundFileId};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            String version = call.invoke(params).toString();
            return version;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int AddFileToArchiveWS(String sURL, String sClassId, Object[] asIndexes, File fFile, String sDescription, String sNewVersion, String sLogin, String sPassword) {
        log.trace((Object)("********** AddFileToArchiveWS(sURL=" + sURL + ", sClassId=" + sClassId + ", Object[], File, sDescription=" + sDescription + ", sNewVersion=" + sNewVersion + ", sLogin, sPassword) ************"));
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            String[] indexes;
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            call.setOperationName(new QName("SaveDocumentInArchive"));
            call.setTargetEndpointAddress(WSDLURL2);
            String sFile = fFile.getName();
            sFile = sFile.replace("'", "_");
            FileInputStream inStream = new FileInputStream(fFile);
            Long nStreamSize = new Long(inStream.available());
            String sSize = nStreamSize.toString();
            byte[] aFile = new byte[nStreamSize.intValue()];
            int i = 0;
            while ((long)i < nStreamSize) {
                aFile[i] = (byte)inStream.read();
                ++i;
            }
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            log.info((Object)("Invoke SaveDocumentInArchive: User=" + sLogin + "; Class=" + sClassId + "; File=" + sFile + "; sSize=" + sSize + ";"));
            Object[] params = new Object[]{sLogin, sPassword, sClassId, sFile, sSize, null, sDescription, null, aFile};
            String sRes = call.invoke(params).toString();
            Integer nFileId = new Integer(sRes);
            if (nFileId > 0) {
                serviceQN = new QName(Namespace, ServiceName);
                serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
                service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
                call = (Call)service.createCall();
                call.setOperationName(new QName("SaveIndeciesInArchive"));
                call.setTargetEndpointAddress(WSDLURL2);
                log.info((Object)("Invoke SaveIndeciesInArchive: User=" + sLogin + "; sClass=" + sClassId + "; FileId=" + nFileId.toString()));
                indexes = new String[asIndexes.length];
                for (int i2 = 0; i2 < asIndexes.length; ++i2) {
                    indexes[i2] = (String)asIndexes[i2];
                }
            } else {
                return -1;
            }
            Object[] params2 = new Object[]{sLogin, sPassword, sClassId, nFileId.toString(), indexes, sNewVersion};
            sRes = call.invoke(params2).toString();
            return nFileId;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static ArrayList<String> FindDocumentsWS(String sURL, String sClassName, String sFrom, String sTo, String[] indexes, String sLogin, String sPassword, String sDomain) {
        log.trace((Object)("************ FindDocumentsWS(sURL=" + sURL + ", sClassName=" + sClassName + ", sFrom=" + sFrom + ", sTo=" + sTo + ", indexes, sLogin, sPassword, sDomain=" + sDomain + ") ************"));
        ArrayList<String> fileIdsList = null;
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            String sObj;
            log.info((Object)("Wyszukiwanie plikow o okreslonych indeksach w klasie dokumentow o nazwie " + sClassName + " w systemie o adresie " + sURL));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            String sMethodName = "";
            sMethodName = StringUtils.isBlank((String)sDomain) ? "FindDocuments" : "FindDocumentsWithDomain";
            call.setOperationName(new QName(sMethodName));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke " + sMethodName + ": User=" + sLogin + "; Domain=" + sDomain + "; ClassName=" + sClassName + "; From=" + sFrom + "; To=" + sTo + "; indexes"));
            Object[] params = null;
            params = StringUtils.isBlank((String)sDomain) ? new Object[]{sLogin, sPassword, sClassName, sFrom, sTo, indexes} : new Object[]{sLogin, sPassword, sDomain, sClassName, sFrom, sTo, indexes};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            Object obj = call.invoke(params);
            if (obj != null && !(sObj = obj.toString()).equalsIgnoreCase("")) {
                String[] splitTab;
                fileIdsList = new ArrayList<String>();
                for (String oneSplit : splitTab = sObj.split(";")) {
                    fileIdsList.add(oneSplit);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return fileIdsList;
    }

    public static boolean MoveDocumentWS(String sURL, String sFileId, String sDestClassName, boolean bCopyIndexes, String sLogin, String sPassword, String sDomain) {
        log.trace((Object)("************ MoveDocumentWS(sURL=" + sURL + ", sFileId=" + sFileId + ", sDestClassName=" + sDestClassName + ", bCopyIndexes=" + String.valueOf(bCopyIndexes) + ", sLogin, sPassword, sDomain=" + sDomain + ") ************"));
        boolean bSuccess = false;
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            log.info((Object)("Przenoszenie pliku o identyfikatorze " + sFileId + " do klasy dokumentow o nazwie " + sDestClassName + " w systemie o adresie " + sURL));
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            String sMethodName = "";
            sMethodName = StringUtils.isBlank((String)sDomain) ? "MoveDocumentBetweenDocClasses" : "MoveDocumentBetweenDocClassesWithDomain";
            call.setOperationName(new QName(sMethodName));
            call.setTargetEndpointAddress(WSDLURL2);
            log.info((Object)("Invoke " + sMethodName + ": User=" + sLogin + "; Domain=" + sDomain + "; FileId=" + sFileId + "; DestClassName=" + sDestClassName + "; CopyIndexes=" + String.valueOf(bCopyIndexes)));
            Object[] params = null;
            String sCopyIndexes = String.valueOf(bCopyIndexes);
            params = StringUtils.isBlank((String)sDomain) ? new Object[]{sLogin, sPassword, sFileId, sDestClassName, sCopyIndexes} : new Object[]{sLogin, sPassword, sDomain, sFileId, sDestClassName, sCopyIndexes};
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            Object obj = call.invoke(params);
            if (obj != null) {
                String sObj = obj.toString();
                bSuccess = Boolean.parseBoolean(sObj);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bSuccess;
    }

    public static PlusWorkflowDocument GetDocumentWS(String sURL, String sFileId, String sLogin, String sPassword, String sDomain) {
        log.trace((Object)("************ GetDocumentWS(sURL=" + sURL + ", sFileId=" + sFileId + ", sLogin, sPassword, sDomain=" + sDomain + ") ************"));
        PlusWorkflowDocument document = null;
        String WSDLURL = sURL + "/services/ArchiveServices?wsdl";
        String WSDLURL2 = sURL + "/services/ArchiveServices";
        String Namespace = "http://CUF.services.plusmpm.com";
        String ServiceName = "ArchiveServices";
        try {
            QName serviceQN = new QName(Namespace, ServiceName);
            javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();
            Service service = serviceFactory.createService(new URL(WSDLURL), serviceQN);
            Call call = (Call)service.createCall();
            String sMethodName = "";
            sMethodName = StringUtils.isBlank((String)sDomain) ? "GetDocument" : "GetDocumentWothDomain";
            call.setOperationName(new QName(sMethodName));
            call.setTargetEndpointAddress(WSDLURL2);
            call.setReturnType(serviceQN, PlusWorkflowDocument.class);
            call.addParameter("userName", serviceQN, ParameterMode.IN);
            call.addParameter("password", serviceQN, ParameterMode.IN);
            if (!StringUtils.isBlank((String)sDomain)) {
                call.addParameter("domain", serviceQN, ParameterMode.IN);
            }
            call.addParameter("fileId", serviceQN, ParameterMode.IN);
            TypeMappingRegistry registry = service.getTypeMappingRegistry();
            TypeMapping mapping = registry.createTypeMapping();
            mapping.register(PlusWorkflowDocument.class, serviceQN, (SerializerFactory)new BeanSerializerFactory(PlusWorkflowDocument.class, serviceQN), (DeserializerFactory)new BeanDeserializerFactory(PlusWorkflowDocument.class, serviceQN));
            registry.register("http://schemas.xmlsoap.org/soap/encoding/", mapping);
            Object[] params = null;
            if (StringUtils.isBlank((String)sDomain)) {
                params = new Object[]{sLogin, sPassword, sFileId};
            } else {
                params = new Object[4];
                params[0] = sLogin;
                params[1] = sPassword;
                params[1] = sDomain;
                params[3] = sFileId;
            }
            log.info((Object)"Uzycie Web Service'u ArchiveServices");
            log.info((Object)("Invoke " + sMethodName + " User=" + sLogin + "; Domain=" + sDomain + "; FileId=" + sFileId));
            Object obj = call.invoke(params);
            if (obj != null) {
                log.info((Object)("Znaleziono dokument o identyfikatorze " + sFileId + " w systemie PlusWorkflow o adresie " + sURL));
                document = (PlusWorkflowDocument)obj;
            } else {
                log.info((Object)("Nie znaleziono dokumentu o identyfikatorze " + sFileId + " w systemie PlusWorkflow o adresie " + sURL));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return document;
    }

    private List<Long> getDocIdsFromProcess(String processId, String activityId) {
        String[] aDocIds;
        Map ctx = SharkClientFunctions.getActivityContextMap(processId, activityId);
        String docIds = (String)ctx.get("DocIds");
        ArrayList<Long> fileIds = new ArrayList<Long>();
        if (StringUtils.isBlank((String)docIds)) {
            log.info((Object)"W procesie nie ma DocIDs");
            return fileIds;
        }
        for (String id : aDocIds = docIds.split(",")) {
            try {
                fileIds.add(Long.valueOf(id));
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"W zmiennej DocIds sa niedozwolone wartosci");
            }
        }
        return fileIds;
    }

    public List<ExtendedFile> getDocumentsFromProcess(String processId, String activityId) {
        ArrayList<ExtendedFile> files = new ArrayList<ExtendedFile>();
        DocumentFinder df = FinderFactory.getDocumentFinder();
        List docs = df.getDocumentsFromProcess(processId, new String[]{"documentClass"});
        for (WfDocument doc : docs) {
            ExtendedFile ef = new ExtendedFile(doc);
            files.add(ef);
        }
        return files;
    }

    public static String encodeFileId(Long fileId) {
        FileFinder fileFinder = FinderFactory.getFileFinder();
        WfFile file = (WfFile)fileFinder.get((Serializable)fileId);
        String fileName = file.getSystemFileName();
        String encoded = Base64.encode((byte[])fileName.getBytes());
        return encoded;
    }

    public static WfFile getFileByEncodedId(String code) {
        String fileName = new String(Base64.decode((String)code));
        FileFinder fileFinder = FinderFactory.getFileFinder();
        return (WfFile)fileFinder.findOneByProperty("systemFileName", (Object)fileName, new String[0]);
    }
}

