/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.google.common.collect.Lists;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.io.office.model.SheetDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StructureData {
    private List<Map<String, CellValue<String>>> users;
    private List<Map<String, CellValue<String>>> positions;
    private List<Map<String, CellValue<String>>> orgUnits;
    private List<Map<String, CellValue<String>>> groups;

    public StructureData(List<SheetDefinition> sheets) {
        if (sheets.size() == 1) {
            this.getSheetsOldXls(sheets);
        } else {
            this.getSheets(sheets);
        }
    }

    private void getSheets(List<SheetDefinition> sheets) {
        this.groups = this.getSheet(sheets, "Grupy");
        this.orgUnits = this.getSheet(sheets, "Jednostki organizacyjne");
        this.positions = this.getSheet(sheets, "Stanowiska");
        this.users = this.getSheet(sheets, "U\u017cytkownicy");
    }

    private List<Map<String, CellValue<String>>> getSheet(List<SheetDefinition> struct, String name) {
        for (SheetDefinition excelSheet : struct) {
            if (!excelSheet.getName().equals(name)) continue;
            ArrayList result = Lists.newArrayList();
            for (Map<String, CellValue<?>> source : excelSheet.getImportCellData()) {
                HashMap map = new HashMap();
                for (Map.Entry<String, CellValue<?>> entry : source.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                result.add(map);
            }
            return result;
        }
        throw new CUFServiceException("Sheet with name " + name + " not found");
    }

    private void getSheetsOldXls(List<SheetDefinition> struct) {
        this.users = Lists.newArrayList();
        this.groups = Lists.newArrayList();
        this.positions = Lists.newArrayList();
        this.orgUnits = Lists.newArrayList();
        ArrayList higherPositions = Lists.newArrayList();
        ArrayList higherOrgUnits = Lists.newArrayList();
        for (Map<String, CellValue<?>> source : struct.get(0).getImportCellData()) {
            HashMap mapUsers = new HashMap();
            HashMap mapPositions = new HashMap();
            HashMap mapOrgUnits = new HashMap();
            String userName = (String)source.get("userName").getValue();
            Optional<Map> userExist = this.users.stream().filter(u -> ((String)((CellValue)u.get("userName")).getValue()).equals(userName)).findFirst();
            for (Map.Entry<String, CellValue<?>> entry : source.entrySet()) {
                HashMap mapHiPos;
                CellValue<?> value = entry.getValue();
                if (value == null) continue;
                if (entry.getKey().equals("groups")) {
                    String[] splitedGr;
                    mapUsers.put(entry.getKey(), value);
                    if (value.getValue() == null) continue;
                    for (String gr : splitedGr = ((String)value.getValue()).split(";")) {
                        if (!this.groups.stream().noneMatch(g -> ((String)((CellValue)g.get("name")).getValue()).equals(gr))) continue;
                        HashMap<String, CellValue<String>> mapGroups = new HashMap<String, CellValue<String>>();
                        mapGroups.put("name", new CellValue<String>(value.getCell(), gr));
                        mapGroups.put("description", new CellValue<String>(value.getCell(), ""));
                        this.groups.add(mapGroups);
                    }
                    continue;
                }
                if (entry.getKey().equals("positionSymbol")) {
                    if (!userExist.isPresent()) {
                        mapUsers.put("positions", entry.getValue());
                    } else {
                        CellValue userPositionsCell = (CellValue)userExist.get().get("positions");
                        String positionsValue = (String)userPositionsCell.getValue();
                        positionsValue = StringUtils.isNotBlank((CharSequence)positionsValue) ? positionsValue + ";" + (String)entry.getValue().getValue() : (String)entry.getValue().getValue();
                        userExist.get().put("positions", new CellValue<String>(userPositionsCell.getCell(), positionsValue));
                    }
                    mapPositions.put("symbol", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("positionName")) {
                    mapPositions.put("name", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("higherPositionSymbol")) {
                    mapPositions.put("higherPosition", value);
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)value.getValue()))) continue;
                    mapHiPos = new HashMap();
                    mapHiPos.put("symbol", value);
                    mapHiPos.put("name", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("higherPosition", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("orgUnit", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("roles", new CellValue<String>(value.getCell(), ""));
                    higherPositions.add(mapHiPos);
                    continue;
                }
                if (entry.getKey().equals("roles")) {
                    mapPositions.put("roles", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("organizationalUnitSymbol")) {
                    mapPositions.put("orgUnit", entry.getValue());
                    mapOrgUnits.put("symbol", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("organizationalUnitName")) {
                    mapOrgUnits.put("name", entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("higherOrganizationalUnitSymbol")) {
                    mapOrgUnits.put("higherOrgUnit", value);
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)value.getValue()))) continue;
                    HashMap mapHiOrgUn = new HashMap();
                    mapHiOrgUn.put("symbol", value);
                    mapHiOrgUn.put("name", new CellValue<String>(value.getCell(), ""));
                    mapHiOrgUn.put("higherOrgUnit", new CellValue<String>(value.getCell(), ""));
                    mapHiOrgUn.put("directorPosition", new CellValue<String>(value.getCell(), ""));
                    higherOrgUnits.add(mapHiOrgUn);
                    continue;
                }
                if (entry.getKey().equals("directorPositionSymbol")) {
                    mapOrgUnits.put("directorPosition", value);
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)value.getValue()))) continue;
                    mapHiPos = new HashMap();
                    mapHiPos.put("symbol", value);
                    mapHiPos.put("name", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("higherPosition", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("orgUnit", new CellValue<String>(value.getCell(), ""));
                    mapHiPos.put("roles", new CellValue<String>(value.getCell(), ""));
                    higherPositions.add(mapHiPos);
                    continue;
                }
                mapUsers.put(entry.getKey(), entry.getValue());
            }
            if (!userExist.isPresent()) {
                this.users.add(mapUsers);
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)((CellValue)mapPositions.get("symbol")).getValue())) && this.positions.stream().noneMatch(p -> ((String)((CellValue)p.get("symbol")).getValue()).equals(((CellValue)mapPositions.get("symbol")).getValue()))) {
                this.positions.add(mapPositions);
            }
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)((CellValue)mapOrgUnits.get("symbol")).getValue())) || !this.orgUnits.stream().noneMatch(p -> ((String)((CellValue)p.get("symbol")).getValue()).equals(((CellValue)mapOrgUnits.get("symbol")).getValue()))) continue;
            this.orgUnits.add(mapOrgUnits);
        }
        for (Map<String, CellValue<Object>> pos : higherPositions) {
            if (!this.positions.stream().noneMatch(p -> ((String)((CellValue)p.get("symbol")).getValue()).equals(((CellValue)pos.get("symbol")).getValue()))) continue;
            this.positions.add(pos);
        }
        for (Map<String, CellValue<Object>> ou : higherOrgUnits) {
            if (!this.orgUnits.stream().noneMatch(p -> ((String)((CellValue)p.get("symbol")).getValue()).equals(((CellValue)ou.get("symbol")).getValue()))) continue;
            this.orgUnits.add(ou);
        }
    }

    public List<Map<String, CellValue<String>>> getUsers() {
        return this.users;
    }

    public List<Map<String, CellValue<String>>> getPositions() {
        return this.positions;
    }

    public List<Map<String, CellValue<String>>> getOrgUnits() {
        return this.orgUnits;
    }

    public List<Map<String, CellValue<String>>> getGroups() {
        return this.groups;
    }
}

