/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.read.biff.BiffException;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadXlsDataToDynamicTable
extends HttpServlet {
    public static Logger log = Logger.getLogger(LoadXlsDataToDynamicTable.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public static String getServerPath(HttpServletRequest request) throws Exception {
        String path = request.getSession(false).getServletContext().getRealPath("/");
        path = CUFTools.convertBackslashesToSlashes(path);
        int slashPos = path.lastIndexOf("/");
        path = path.substring(0, slashPos);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* LoadXlsDataToDynamicTable Servlet ****************************");
        PrintWriter printWriter = null;
        DiskFileItem file = null;
        I18Nxpdl i18n = new I18Nxpdl(request);
        String tempPath = "";
        String helpTempPath = "";
        try {
            String colNames = request.getParameter("cols");
            String processId = request.getParameter("processId");
            String[] keys = colNames.split(";");
            tempPath = LoadXlsDataToDynamicTable.getServerPath(request);
            DiskFileItemFactory fFactory = new DiskFileItemFactory(1, new File(tempPath));
            ServletFileUpload fUpLoad = new ServletFileUpload((FileItemFactory)fFactory);
            List fItems = fUpLoad.parseRequest(request);
            file = (DiskFileItem)fItems.get(0);
            HashMap<String, String> idTypeMap = new HashMap<String, String>();
            List<Map<String, String>> dane = null;
            String processDefId = null;
            try {
                processDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(processId);
            }
            catch (Exception e) {
                log.info((Object)"nie mo\u017cna pobra\u0107 porcessDefId");
            }
            log.info((Object)("Pobieram proces. ProcesDefId=" + processDefId));
            if (!Tools.isNullOrEmpty((String)processDefId) && !processDefId.equals("null")) {
                log.info((Object)"Pobieram package");
                Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
                WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
                DataFields df = wp.getDataFields();
                HashMap<String, String> mapIdName = new HashMap<String, String>();
                for (int i = 0; i < df.size(); ++i) {
                    DataField d = (DataField)df.get(i);
                    log.info((Object)("tlumazcenie: " + i18n.getString(XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).forDataField(d.getId()).getKey())));
                    mapIdName.put(i18n.getString(XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).forDataField(d.getId()).getKey()), d.getId());
                }
                for (String k : keys) {
                    String varType = SharkClientFunctions.getVarTypeForVarId(wp, (String)mapIdName.get(k));
                    idTypeMap.put(k, varType);
                }
                dane = this.getDataFromExcelWithTypeValidation(file, idTypeMap);
            } else {
                dane = this.getDataFromExcel(file, keys);
            }
            JSONObject jsObj = new JSONObject();
            jsObj.put("success", true);
            String respText = "";
            for (int i = 0; i < dane.size(); ++i) {
                if (i != 0) {
                    respText = respText.concat("@row@");
                }
                Map<String, String> oneResult = dane.get(i);
                for (int j = 0; j < keys.length; ++j) {
                    String tempValue = oneResult.get(keys[j]);
                    if (tempValue == null) {
                        tempValue = "";
                    }
                    if (idTypeMap.get(keys[j]) != null && idTypeMap.get(keys[j]).equals("Date")) {
                        log.info((Object)"Pole typu data");
                        tempValue = tempValue.replace(".", "-");
                        log.info((Object)tempValue);
                    }
                    respText = respText.concat(tempValue);
                    if (j >= keys.length - 1) continue;
                    respText = respText.concat("@col@");
                }
            }
            jsObj.put("dane", (Object)respText);
            response.setContentType("text/html;charset=UTF-8");
            printWriter = response.getWriter();
            printWriter.println(jsObj.toString());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            response.setContentType("text/html;charset=UTF-8");
            if (printWriter == null) {
                printWriter = response.getWriter();
            }
            try {
                JSONObject jsObj = new JSONObject();
                jsObj.put("success", false);
                jsObj.put("error", (Object)e.getMessage());
                printWriter = response.getWriter();
                printWriter.print(jsObj.toString());
            }
            catch (IOException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (JSONException e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                if (file != null) {
                    file.delete();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<Map<String, String>> getDataFromExcel(DiskFileItem file, String[] keys) throws BiffException, IOException, CUFException {
        log.trace((Object)"************ getDataFromExcel(DiskFileItem, String[]) ************");
        String fileName = file.getStoreLocation().getAbsolutePath();
        log.info((Object)("Sciezka do pliku: " + fileName));
        List<Map<String, String>> data = CUFTools.getListColumnValues(fileName, keys);
        return data;
    }

    public List<Map<String, String>> getDataFromExcelWithTypeValidation(DiskFileItem file, Map<String, String> idTypeMap) throws Exception {
        log.trace((Object)"************ getDataFromExcelWithTypeValidation(DiskFileItem, Map<String, String>) ************");
        String fileName = file.getStoreLocation().getAbsolutePath();
        log.info((Object)("Sciezka do pliku: " + fileName));
        List<Map<String, String>> data = CUFTools.getListColumnValuesWithTypeValidation(fileName, idTypeMap);
        return data;
    }
}

