/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.pdf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtils {
    private static final Logger log = LoggerFactory.getLogger(PdfUtils.class);

    public static void removeBlankPages(String sFilePathPdf) {
        File input = new File(sFilePathPdf);
        try {
            PDDocument doc = PDDocument.load((File)input);
            List list = doc.getDocumentCatalog().getAllPages();
            PDResources pdResources = ((PDPage)list.get(0)).findResources();
            Map pageImages = pdResources.getXObjects();
            for (int i = list.size(); i > 0; --i) {
                String pageText;
                PDFTextStripper reader = new PDFTextStripper();
                reader.setStartPage(i);
                reader.setEndPage(i);
                PDStream contents = ((PDPage)list.get(i - 1)).getContents();
                PDFStreamParser parser = new PDFStreamParser(contents.getStream());
                parser.parse();
                List tokens = parser.getTokens();
                Boolean isImageOnPage = false;
                if (pageImages != null) {
                    for (String key : pageImages.keySet()) {
                        COSName COSNameKey = COSName.getPDFName((String)key);
                        if (!tokens.contains(COSNameKey)) continue;
                        isImageOnPage = true;
                        break;
                    }
                }
                if ((pageText = reader.getText(doc).replaceAll("\\s+", "")).length() != 0 || isImageOnPage.booleanValue()) break;
                doc.removePage((PDPage)list.get(i - 1));
            }
            doc.save(sFilePathPdf);
            log.info("Deleting blank pages completed");
        }
        catch (IOException e) {
            log.info("ERROR - problem while deleting blank pages from a PDF file");
        }
        catch (COSVisitorException e) {
            log.info("ERROR - problem while deleting blank pages from a PDF file");
        }
    }
}

