var variableService = ServiceFactory.getVariableService();

/**
 * Set Variables action implementation. 
 */
PW.FormActions.create('set-variables-action', {
	
    init: function(){
    	this.variablesToChange = this.get("variables");
    	this.oldValues = [];
    },
    
    /*
     * If action is on form, then check initiation parameter
     */
    formInit: function(){
        this.initiation = this.get("initiation");
        this.initiated = false;
    },
    
    /*
     * If action is on the button, then call only if pressed.
     */
    buttonInit: function(button){
        this.initiation = true; 
        this.initiated = true;
    },

    defaultActions: {
        button: function(button){
            this.setVariables();
        }
    },
    
    enable : function(){
    	if(!this.initiated){
    		this.setVariables();
    	}
    	if(!this.initiation){
            this.getRaw('values').on('change',  this.setVariables, this );
    	}
    },
    
    disable : function(){
    	if(!this.initiation){
            this.getRaw('values').off('change',  this.setVariables, this );
    	}
    },

    setVariables: function(args) {
        var valuesToSet = args ? args.get() : this.get("values");
    	var me = this;
    	PW.each(me.variablesToChange, function (variable, index){
    	    var hasChanged = this.initiated ? valuesToSet[index] !== me.oldValues[index] : true;
	    	var type = variable.getType();
	    	if(type.isArray){
	    		valuesToSet[index] = me.convertToArray(valuesToSet[index], type);
	    	}
			if(hasChanged){
				variable.setValue(valuesToSet[index]);
				me.oldValues[index] = valuesToSet[index];
			}
    	});
    	this.initiated = true;
    },
    
    convertToArray: function(value, type) {
    	if (value == "") return [];
    	var arr = value.split(";");
    	var convertedArray = [];
    	if (type.is("integer[]") || type.is("float[]")){
			for(var i = 0; i < arr.length; i++){
				convertedArray.push(Number(arr[i]));
			}
		}
		else if (type.is("date[]")){
			for(var i = 0; i < arr.length; i++){
				convertedArray.push(new Date(arr[i]));
			}
		}
		else if (type.is("string[]")){
			for(var i = 0; i < arr.length; i++){
				convertedArray = arr;
			}
		}
    	return convertedArray;
    }
});