PWE.integrationComponent.registerDataChooser('userchooser', {
    apiVersion: 2,
    buildForm: function (form, options) {
        
        createCombobox(form, "usersFilterType", getUserFilterTypes(), "users", "all");
        CufComp.addComboboxAllUsers(form, "users");
        hideByDefault(form, "usersFilterType", "users", "all");
        
        form.addEmptyLine();
        form.addLabel(CUFCommon.t('dc.userdatachooser.filtering-component'));
        
        createCombobox(form, "groupsFilterType", getFilterTypes("groups"), "groups", "off");
        CufComp.addComboboxAllGroups(form, "groups");
        hideByDefault(form, "groupsFilterType", "groups", "off");
        form.addEmptyLine();
        
        createCombobox(form, "ousFilterType", getFilterTypes("ous"), "ous", "off");
        CufComp.addComboboxAllOus(form, "ous");
        hideByDefault(form, "ousFilterType", "ous", "off");
        form.addEmptyLine();
        
        createCombobox(form, "rolesFilterType", getFilterTypes("roles"), "roles", "off");
        CufComp.addComboboxAllRoles(form, "roles");
        hideByDefault(form, "rolesFilterType", "roles", "off");
        
        form.addEmptyLine();
        form.addEmptyLine();
        
        form.addLabel(CUFCommon.t('dc.userdatachooser.filtering-field-edit'));
        createCombobox(form, "filterBy", getRealTimeFilterByOptions(), "customFilterFields", "visible")
        form.addCombobox({
            id:"customFilterFields",
            values: getFilterMappings()
        });
        hideByDefault(form, "filterBy", "customFilterFields", "visible");
        
        form.addEmptyLine();
        form.addEmptyLine();
        
        form.addLabel(CUFCommon.t('dc.userdatachooser.sorting'));
        form.addCombobox({
            id:"sortBy",
            values: getSortMappings()
        });
        form.addCombobox({
            id: "sortDirection",
            values: [
                { id: "ASC", display: CUFCommon.t('dc.userdatachooser.ASC')},
                { id: "DESC", display: CUFCommon.t('dc.userdatachooser.DESC') }
            ]
        });
        
        function getRealTimeFilterByOptions()
        {
            return [
                { id: "visible", display: CUFCommon.t('dc.userdatachooser.visible-mappings')},
                { id: "custom", display: CUFCommon.t('dc.userdatachooser.custom-mappings') }
            ];
        }
        
        function getFilterMappings()
        {
            return [
                { id: "userName", display: CUFCommon.t('default.username')},
                { id: "firstName", display: CUFCommon.t('default.firstname') },
                { id: "lastName", display: CUFCommon.t('default.lastname')},
                { id: "email", display: CUFCommon.t('default.email')},
                { id: "fullName", display: CUFCommon.t('default.fullname') },
                { id: "ous", display: CUFCommon.t('default.ous')},
                { id: "ousSymbols", display: CUFCommon.t('default.ouSymbols')},
                { id: "groups", display: CUFCommon.t('default.groups')},
                { id: "positions", display: CUFCommon.t('default.positions')},
                { id: "positionsSymbols", display: CUFCommon.t('default.positionsSymbols')},
                { id: "superiors", display: CUFCommon.t('default.superiorsUserNames')}
            ];
        }
        
        function getSortMappings()
        {
            return [
                { id: "userName", display: CUFCommon.t('default.username')},
                { id: "firstName", display: CUFCommon.t('default.firstname') },
                { id: "lastName", display: CUFCommon.t('default.lastname')},
                { id: "email", display: CUFCommon.t('default.email')}
            ];
        }
        
        function hideByDefault(form, checkField, hideField, hideValue){
            if (form.getValue(checkField) == hideValue){
                form.hide(hideField);
            }            
        };
        
        function createCombobox(form, comboboxId, values, hideField, hideValue){
            form.addCombobox({
                id: comboboxId, 
                values: values,
                listeners: {
                    change: function(value) {
                        if (value != hideValue){
                            form.show(hideField);
                        } else{
                            form.hide(hideField);   
                        }
                    }
                }
            });
        };
        
        function getUserFilterTypes(){
            return [{
                id: 'custom',
                display : CUFCommon.t('dc.userchooser.custom')
            }, {
                id: 'users-excluded',
                display: CUFCommon.t('dc.userchooser.users-excluded')
            }, {
                id: 'all',
                display: CUFCommon.t('dc.userchooser.all')
            }];
        };
        
        function getFilterTypes(category){
            return [{
                id: 'all',
                display : CUFCommon.t('dc.userchooser.all-' + category)
            }, {
                id: 'any',
                display: CUFCommon.t('dc.userchooser.any-' + category)
            }, {
                id: 'none',
                display: CUFCommon.t('dc.userchooser.none-' + category)
            }, {
                id: 'off',
                display: CUFCommon.t('dc.userchooser.off')
            }];
        };
    }
});