PWE.integrationComponent.registerApplication("execute-datasource", {
  apiVersion: 2,
  buildForm: function(form) {
    handle(form);
  },
  validateForm: function(api) {
  	return validate(api);
  }
});

PWE.integrationComponent.registerVariablesSetter("execute-datasource", {
  apiVersion: 2,
  buildForm: function(form) {
    handle(form);
  },
  validateForm: function(api) {
  	return validate(api);
  }
});

function handle(form) {
  DataSource.buildDataSourceSelectionCombobox(
    form,
    DataSource.Operations.ALL,
    "datasource",
    "datasources"
  );

  DataSource.buildParametersForNonDatachooser(form, {
    datasourceParamId: "datasource",
    datasourcesParamId: "datasources",
    datasourceInputParametersId: "datasourceInputParametersId",
    datasourceInputParametersValue: "datasourceInputParametersValue",
    datasourceOutputParametersId: "datasourceOutputParametersId",
    datasourceOutputParametersValue: "datasourceOutputParametersValue"
  });

  form.addCombobox({
    id: "manyValuesHandler",
    forceSelection: true,
    values: [
      {
        id: "block",
        display: CUFCommon.t("datasource.handleManyVals.block.name"),
        description: CUFCommon.t("datasource.handleManyVals.block.desc")
      },
      {
        id: "first",
        display: CUFCommon.t("datasource.handleManyVals.first.name"),
        description: CUFCommon.t("datasource.handleManyVals.first.desc")
      },
      {
        id: "unique",
        display: CUFCommon.t("datasource.handleManyVals.unique.name"),
        description: CUFCommon.t("datasource.handleManyVals.unique.desc")
      }
    ]
  });
  form.addField("overwriteData");
}

function validate(api) {
	const types = api.getVariableType("datasourceOutputParametersValue");
	for (var i = 0; i < types.length; i++) {
		if (types[i] != null && types[i] !== "string" && api.getValue("manyValuesHandler") === "unique" ) {
			api.markError("manyValuesHandler");
			api.showErrorMessage(CUFCommon.t("datasource.form-validator-message.get-data-from-datasource"));
			return false;
		}
	}

	return true;
}
