PWE.integrationComponent.registerFormAction("data-table-from-datasource", {
    apiVersion: 2,
    validateForm: (form) => {
        const inputParameterValueArray = form.getValue("inputParameterValue");
        const inputParameterFunctionArray = form.getValue("inputParameterFunction");

        for (let i = 0; i < inputParameterValueArray.length; i++) {
            const inputValue = inputParameterValueArray[i];
            const inputFunction = inputParameterFunctionArray[i];

            if (!!inputValue === !!inputFunction) {
                form.showErrorMessage(CUFCommon.t("action.data-table-from-datasource.error.function-and-nor-value-set"));
                return false;
            }
        }

        return true;
    },
    buildForm: (form) => {
        form.addCombobox({
            id: "datasource",
            remote: {
                url: "api/datasources",
                fields: [
                    {
                        name: "id",
                        type: "string"
                    },
                    {
                        name: "name",
                        type: "string"
                    }
                ],
                remoteSort: true
            },
            valueField: "id",
            displayField: "name",
            listeners: {
                change: function (datasource) {
                    const inputParameters = [];
                    const outputParameters = [];

                    form.hide("inputParametersTable");
                    form.hide("outputParametersTable");

                    loadDatasourceParameters(form, datasource, inputParameters, outputParameters);

                    rebuildParameters(form, {
                        parameters: inputParameters,
                        parametersId: "inputParameterId",
                        parametersName: "inputParameterName"
                    }, inputParametersTable);
                    rebuildParameters(form, {
                        parameters: outputParameters,
                        parametersId: "outputParameterId",
                        parametersName: "outputParameterName"
                    }, outputParametersTable);

                    renderParameters(form, inputParameters, outputParameters);
                }
            }
        });

        const inputParametersTable = form.addTable({
            id: "inputParametersTable",
            blocked: true,
            hidden: !form.getValue("datasource")
        });
        inputParametersTable.addField({
            id: "inputParameterId",
            readOnly: true,
            hidden: true
        });
        inputParametersTable.addField({
            id: "inputParameterName",
            name: CUFCommon.t("action.data-table-from-datasource.param.inputParameterName.name"),
            description: CUFCommon.t("action.data-table-from-datasource.param.inputParameterName.desc"),
            type: "string",
            readOnly: true
        });
        inputParametersTable.addField("inputParameterValue");
        inputParametersTable.addField("inputParameterFunction");

        const outputParametersTable = form.addTable({
            id: "outputParametersTable",
            blocked: true,
            hidden: !form.getValue("datasource")
        });
        outputParametersTable.addField({
            id: "outputParameterId",
            readOnly: true,
            hidden: true
        });
        outputParametersTable.addField({
            id: "outputParameterName",
            name: CUFCommon.t("action.data-table-from-datasource.param.outputParameterName.name"),
            description: CUFCommon.t("action.data-table-from-datasource.param.outputParameterName.desc"),
            type: "string",
            readOnly: true
        });
        outputParametersTable.addField("outputParameterValue");
        outputParametersTable.addField("columnName");
        outputParametersTable.addCombobox({
            id: "type",
            value: "string", //czekamy na ewentualną zmianę w systemie
            hidden: true,    //czekamy na ewentualną zmianę w systemie
            optional: true,  //czekamy na ewentualną zmianę w systemie
            values: [
                {id: "string", display: CUFCommon.t("action.data-table-from-datasource.param.type.text")},
                {id: "integer", display: CUFCommon.t("action.data-table-from-datasource.param.type.integer")},
                {id: "float", display: CUFCommon.t("action.data-table-from-datasource.param.type.float")},
                {id: "date", display: CUFCommon.t("action.data-table-from-datasource.param.type.date")}
            ]
        });
        outputParametersTable.addField("hidden");
        outputParametersTable.addField("wrapText");

        form.addField("pageSize");
        form.addField({
            id: "transfer",
            listeners: {
                change: function (value) {
                    if (!value) {
                        form.hide("multipleRowsSelection");
                        form.hide("multipleValuesSupport");
                        form.hide("saveForm");
                        form.hide("overwrite");
                        form.hide("executeAutomapping");
                    } else {
                        form.show("multipleRowsSelection");
                        form.show("multipleValuesSupport");
                        form.show("saveForm");
                        form.show("overwrite");
                        form.show("executeAutomapping");
                    }
                }
            }
        });

        form.addField({
            id: "overwrite",
            hidden: !form.getValue("transfer")
        });

        form.addField({
            id: "multipleRowsSelection",
            hidden: !form.getValue("transfer"),
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("multipleValuesSupport");
                    } else {
                        form.hide("multipleValuesSupport");
                    }
                }
            }
        });

        form.addCombobox({
            id: "multipleValuesSupport",
            hidden: !form.getValue("multipleRowsSelection"),
            values: [
                {id: "BLOCK", display: CUFCommon.t("action.data-table-from-datasource.param.multipleValuesSupport.block")},
                {id: "UNIQUE", display: CUFCommon.t("action.data-table-from-datasource.param.multipleValuesSupport.unique")},
                {id: "FIRST", display: CUFCommon.t("action.data-table-from-datasource.param.multipleValuesSupport.first")}
            ]
        });

        form.addField("rowNumber");
        form.addField("columnContextMenu");
        form.addField({
            id: "saveForm",
            hidden: !form.getValue("transfer")
        });
        form.addField({
            id: "executeAutomapping",
            hidden: !form.getValue("transfer")
        });
        form.addField("windowTitle");

        fillParameters(form, true, "inputParameterId", inputParametersTable);
        fillParameters(form, false, "outputParameterId", outputParametersTable);
    }
});

function rebuildParameters(form, datasource, table) {
    if (datasource.parameters && datasource.parameters.length > 0) {
        const addedParameters = [];

        jQuery.each(datasource.parameters, function (index, parameter) {
            if (!addedParameters.includes(parameter.id)) {
                const parametersId = form.getValue(datasource.parametersId);

                if (parametersId[index] === undefined) {
                    table.addRow([
                        {
                            id: datasource.parametersId,
                            value: parameter.id
                        },
                        {
                            id: datasource.parametersName,
                            value: parameter.name
                        }
                    ]);
                } else {
                    form.setFieldValueInArray(datasource.parametersId, index, parameter.id);
                    form.setFieldValueInArray(datasource.parametersName, index, parameter.name);
                }
                addedParameters.push(parameter.id);
            }
        });
    }
    const paramSize = form.getValue(datasource.parametersId).length - 1;
    for (let j = paramSize; j >= datasource.parameters.length; j--) {
        table.removeRow(j);
    }
}

function loadDatasourceParameters(form, datasource, inputParameters, outputParameters) {
    jQuery.ajax({
        async: false,
        url: Suncode.getAbsolutePath("api/datasources/" + datasource),
        success: function (data) {
            if (data.inputParameters.length > 0) {
                data.inputParameters.forEach(function (param) {
                    if (inputParameters.find(function (iparam) {
                        return param.id === iparam.id;
                    }) === undefined) {
                        inputParameters.push(param);
                    }
                });
            }

            if (data.outputParameters.length > 0) {
                data.outputParameters.forEach(function (param) {
                    if (outputParameters.find(function (oparam) {
                        return param.id === oparam.id;
                    }) === undefined) {
                        outputParameters.push(param);
                    }
                });
            }
        }
    });
}

function fillParameters(form, isInputParameters, parametersId, parametersTable) {
    const datasource = form.getValue("datasource");

    jQuery.ajax({
        async: false,
        url: Suncode.getAbsolutePath("api/datasources/" + datasource),
        success: function (data) {
            if ((data.inputParameters && data.inputParameters.length > 0 && isInputParameters) ||
                (data.outputParameters && data.outputParameters.length > 0 && !isInputParameters)) {
                let ids = form.getValue(parametersId);
                let parameters = [];

                if (isInputParameters) {
                    parameters = data.inputParameters;
                } else {
                    parameters = data.outputParameters;
                }

                let removedRowsCounter = 0;
                ids.forEach(function (id, index) {
                    if (parameters.filter(function (param) {
                        return id === param.id
                    }).length <= 0) {
                        parametersTable._applyArrayFields({}, index - removedRowsCounter);
                        parametersTable.removeRow(index - removedRowsCounter);
                        removedRowsCounter++;
                    }
                });

                ids = form.getValue(parametersId);
                jQuery.each(parameters, function (_index, parameter) {
                    const idIndex = ids.indexOf(parameter.id);
                    if (idIndex < 0) {
                        parametersTable.addRow([
                            {id: (isInputParameters ? "input" : "output") + "ParameterId", value: parameter.id},
                            {id: (isInputParameters ? "input" : "output") + "ParameterName", value: parameter.name}
                        ]);
                    } else {
                        form.setFieldValueInArray((isInputParameters ? "input" : "output") + "ParameterName", idIndex, parameter.name);
                    }
                });

                if (parameters.length > 0) {
                    if (isInputParameters) {
                        form.show("inputParametersTable");
                    } else {
                        form.show("outputParametersTable");
                    }
                }
            } else {
                if (isInputParameters) {
                    form.hide("inputParametersTable");
                } else {
                    form.hide("outputParametersTable");
                }
            }
        }
    });
}

function renderParameters(form, inputParameters, outputParameters) {
    if (inputParameters.length > 0) {
        form.show("inputParametersTable");
    } else {
        form.hide("inputParametersTable");
    }

    if (outputParameters.length > 0) {
        form.show("outputParametersTable");
    } else {
        form.hide("outputParametersTable");
    }
}