PWE.integrationComponent.registerApplication("add-substitution-app", {
	apiVersion : 2,
	buildForm : function(form) {
		form.addField("substitutedLogin");
		form.addField("substituteLogin");
		form.addField("dateFrom");
		form.addField("dateTo");
		
		form.addCombobox( {
            id : "substitutionType",
            value: "GENERAL",
            values : [
                {id: "GENERAL", 
                	display: CUFCommon.t("dpwe-add-substitution-app-substitutionType-general"),
                	description: CUFCommon.t("dpwe-add-substitution-app-substitutionType-general.desc")},
                {id: "FOR_PROCESS", 
                	display: CUFCommon.t("dpwe-add-substitution-app-substitutionType-for-process"),
                	description: CUFCommon.t("dpwe-add-substitution-app-substitutionType-for-process.desc")},
                {id: "FOR_ROLE", 
                	display: CUFCommon.t("dpwe-add-substitution-app-substitutionType-for-role"),
                	description: CUFCommon.t("dpwe-add-substitution-app-substitutionType-for-role.desc")}
                ],
                listeners: {
                    change: function(value) {
                        if (value == "GENERAL") {
                        	form.hide("processDefId");
                        	form.hide("roleId");
                        	form.resetValue("processDefId");
                        	form.resetValue("roleId");
                        } else if (value == "FOR_PROCESS"){
                            form.show("processDefId");
                            form.hide("roleId");
                            form.resetValue("roleId");
                        } else{
                            form.show("processDefId");
                            form.show("roleId");
                        }
                    }
                }
        });
		
		form.addCombobox({
			id: "processDefId",
			remote: {
				url: "plugin/com.suncode-cuf-components/processes/processTypes",
				fields: [{
						name: "name",
						type: "string"
					},
					{
						name: "processDefId",
						type: "string"
					}
				]
			},
			template: [{
					label: CUFCommon.t("dpwe-add-substitution-app-processDefId-template-label"),
					field: "name"
			}],
			valueField: "processDefId",
			displayField: "name",
			sort: [{
				property: "name",
				direction: "ASC"
			}],
			listeners: {
                change: function (value) {
                	comboApi.setUrl("plugin/com.suncode-cuf-components/roles/process/" + value); 
                }
            }
		});
		
		var comboApi=form.addCombobox({
			id: "roleId",
			remote: {
				url: "plugin/com.suncode-cuf-components/roles/process/" + form.getValue("processDefId"),
				fields: [{
						name: "roleId",
						type: "string"
					},
					{
						name: "displayName",
						type: "string"
					}
				]
			},
			template: [
				{
					label: CUFCommon.t("dpwe-add-substitution-app-role.name"),
					field: "displayName"
				}
			],
			valueField: "roleId",
			displayField: "displayName",
			sort: [{
				property: "roleId",
				direction: "ASC"
			}]

		});
		
		if (form.getValue("substitutionType") == "GENERAL") {
			form.hide("processDefId");
			form.hide("roleId");
		} 
		else if (form.getValue("substitutionType") == "FOR_PROCESS") {
			form.hide("roleId");
		}
	}
});