/*
 * CUF common objects to use in scripts
 */

/*
 * Translator
 */
window.CUFCommon = {
    t: PW.I18N.createT('com.suncode-cuf-components'),
    generateDefaultButtonId: function () {
        return Ext.id()
    },

    isDivanteSystem: function () {
        return PW.ui.version == 1 ? true : false;
    },
    getCommentWindowHeight: function () {
        if (this.isDivanteSystem() && MobileService.isMobile())
            return 300;
        if (this.isDivanteSystem() && !MobileService.isMobile())
            return 300;
        if (!this.isDivanteSystem() && MobileService.isMobile())
            return 180;
        if (!this.isDivanteSystem() && !MobileService.isMobile())
            return 180;
    },
    getCommentWindowWidth: function () {
        if (this.isDivanteSystem() && MobileService.isMobile())
            return 330;
        if (this.isDivanteSystem() && !MobileService.isMobile())
            return 490;
        if (!this.isDivanteSystem() && MobileService.isMobile())
            return 330;
        if (!this.isDivanteSystem() && !MobileService.isMobile())
            return 490;
    },
    defineCommentWindow: function (id, acceptButtonCfg, cancelButtonHandler, scope, allowEmptyComment) {
        return new Ext4.define(id, {

            extend: 'Ext4.window.Window',
            height: this.getCommentWindowHeight(),
            width: this.getCommentWindowWidth(),
            layout: 'fit',
            modal: true,
            buttonAlign: 'right',
            closable: false,

            title: CUFCommon.t('leave-comment.window-title'),

            items: [{
                xtype: 'form',
                frame: false,
                border: 0,

                layout: {
                    type: 'hbox',
                    align: 'middle'
                },

                fieldDefaults: {
                    msgTarget: 'side',
                    labelWidth: 70
                },

                items: [{
                    xtype: 'container',
                    flex: 1,
                    padding: 10,
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    items: [{
                        xtype: 'textareafield',
                        itemId: 'commentWindow_textarea',
                        name: 'comment',
                        allowBlank: false,
                        flex: 1,
                        maxLength: 4000,
                        maxLengthText: CUFCommon.t('leave-comment.max-length-text')
                    }]
                }]
            }],

            buttons: [{
                text: CUFCommon.t('leave-comment.accept-button-name'),
                itemId: 'acceptButton',
                handler: function () {
                    if (!allowEmptyComment || (allowEmptyComment && !(this.up('window').down('textareafield').getValue() == ""))) {
                        var isValid = this.up('window').down('form').getForm().isValid();
                        if (isValid) {
                            CommentService.add(this.up('window').down('textareafield').getValue(), acceptButtonCfg);
                        }
                    } else {
                        acceptButtonCfg.success();
                    }
                },
            },
                {
                    text: CUFCommon.t('leave-comment.cancel-button-name'),
                    itemId: 'cancelButton',
                    handler: cancelButtonHandler,
                    scope: scope
                }]
        });
    },
    getSingleType: function (type) {
        if (type.is("string[]") || type.is("string")) {
            return "string";
        } else if (type.is("integer[]") || type.is("integer")) {
            return "integer";
        } else if (type.is("float[]") || type.is("float")) {
            return "float";
        } else if (type.is("date[]") || type.is("date")) {
            return "date";
        } else if (type.is("datetime[]") || type.is("datetime")) {
            return "datetime";
        } else if (type.is("boolean[]") || type.is("boolean")) {
            return "boolean";
        }
    },

    stringToObject: function (value, type) {
        if (type == "string") {
            return value;
        }
        if (type == "boolean") {
            return value == "true";
        } else if (type == "float" || type == "integer") {
            return Number(value);
        } else if (value == null || value == undefined) {
            return null;
        } else if (type == "date" || type == "datetime") {
            return new Date(value);
        } else if (type == "float[]") {
            var stringValuesArray = value == "" ? [] : value.split(";");
            var valuesArray = [];
            for (var i = 0; i < stringValuesArray.length; i++) {
                valuesArray.push(Number(stringValuesArray[i]));
            }
            return valuesArray;
        } else if (type == "integer[]") {
            var stringValuesArray = value == "" ? [] : value.split(";");
            var valuesArray = [];
            for (var i = 0; i < stringValuesArray.length; i++) {
                valuesArray.push(Number(stringValuesArray[i]));
            }
            return valuesArray;
        } else if (type == "date[]") {
            var stringValuesArray = value == "" ? [] : value.split(";");
            var valuesArray = [];
            for (var i = 0; i < stringValuesArray.length; i++) {
                valuesArray.push(new Date(stringValuesArray[i]));
            }
            return valuesArray;
        } else if (type == "string[]") {
            var stringValuesArray = value == "" ? [] : value.split(";");
            return stringValuesArray;
        }
    },
    addProcessedTable: function (tableId) {
        this.CurrentProcessingTables.add(tableId);
    },
    removeProcessedTable: function (tableId) {
        this.CurrentProcessingTables.delete(tableId);
    },
    isProcessedTable: function (tableId) {
        return this.CurrentProcessingTables.has(tableId);
    }
};

CUFCommon.DateTimeConstants = {};
CUFCommon.DateTimeConstants.MILLIS_PER_SECOND = 1000;
CUFCommon.DateTimeConstants.MILLIS_PER_MINUTE = CUFCommon.DateTimeConstants.MILLIS_PER_SECOND * 60;
CUFCommon.DateTimeConstants.MILLIS_PER_HOUR = CUFCommon.DateTimeConstants.MILLIS_PER_MINUTE * 60;
CUFCommon.DateTimeConstants.MILLIS_PER_DAY = CUFCommon.DateTimeConstants.MILLIS_PER_HOUR * 24;
CUFCommon.DateTimeConstants.MILLIS_PER_WEEK = CUFCommon.DateTimeConstants.MILLIS_PER_DAY * 7;
CUFCommon.DateTimeConstants.MILLIS_PER_YEAR = CUFCommon.DateTimeConstants.MILLIS_PER_DAY * CUFCommon.DateTimeConstants.DYS_PER_YEAR;
CUFCommon.DateTimeConstants.MILLIS_PER_MONTH = CUFCommon.DateTimeConstants.MILLIS_PER_DAY * CUFCommon.DateTimeConstants.DAY_PER_MONTH;
CUFCommon.CurrentProcessingTables = new Set();