/**
 * Action checking for the existence of a given user within the system. 
 */
PW.FormActions.create('existing-user-action', {
    
    variableInit : function(variable){
        this.sourceVariable = variable;
    },
    
    buttonInit : function(button) {
    	this.button = button;
    },
    
    init : function () {
    	this.lock = new Suncode.form.plugin.locking.Lock();
    	this.targetVariable = this.get("targetVariable");
    	this.onlyActive = this.get("onlyActive");
    	this.userExistsStatus = this.get("userExistsStatus");
    	this.userDoesNotExistStatus = this.get("userDoesNotExistStatus");
    },
    
    defaultActions: {
        button : function(button) {
             this.checkUser();
         },
         variable : function(variable) {
        	 this.checkUser();
         } 
     },
    
    enable : function(){
    	if (!this.button) {
			this.checkUser();
		}
    },
    
    checkUser : function(unlock) {
    	var lock = this.lock,
    		userName = this.get("userName"),
    		targetVariable = this.targetVariable,
    		userExistsStatus = this.userExistsStatus,
    		userDoesNotExistStatus = this.userDoesNotExistStatus,
    		onlyActive = this.onlyActive;
    		
    	lock.pushVariable(targetVariable);
    	lock.lock();
    	
    	jQuery.ajax({
			type : "GET",
			data : {
				userName : userName,
				onlyActive : onlyActive
			},
			url : "plugin/com.suncode-cuf-components/user/user-exists/",
			error :  function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			}, 
			async : true
		})
		.done(function (data){
			if (devMode){
	    		Logger.debug("Action user-exists will now set variable...");
	    	}
			if (data) {
				targetVariable.setValue(userExistsStatus);
			} else {
				targetVariable.setValue(userDoesNotExistStatus)
			}
		})
		.fail(function(){
			Logger.error("Request failed.");
		})
		.always(function(){
			lock.unlock();
		});
    }
});