PW.FormActions.create('table-remove-all-records', {
	defaultActions: {
		button: function () {
			this.execute();
		},
		dtButton: function (button) {
			this.removeAllRecords(button.getVariableSet());
		}
	},
	execute: function () {
		const tableId = this.get('tableId');
		const variableSet = VariableSetService.getVariableSet(tableId);
		const wipeData = this.get('wipeData');

		if (!variableSet && wipeData) {
			console.error('Invalid VariableSet id: ' + tableId);
			alert(CUFCommon.t('action.invoking-action-error-occured'));
			return;
		}

		this.removeAllRecords(variableSet);
	},
	removeAllRecords: function (variableSet) {
		if (this.get('wipeData')) {
			variableSet.clear();
		}

		const emptyTableStore = {variableType: {}, data: []};
		this.getRaw('tableStore').value.value.setValue(JSON.stringify(emptyTableStore));
	}
});